﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticache/ElastiCacheRequest.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ElastiCache {
namespace Model {

/**
 */
class TestFailoverRequest : public ElastiCacheRequest {
 public:
  AWS_ELASTICACHE_API TestFailoverRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "TestFailover"; }

  AWS_ELASTICACHE_API Aws::String SerializePayload() const override;

 protected:
  AWS_ELASTICACHE_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The name of the replication group (console: cluster) whose automatic failover
   * is being tested by this operation.</p>
   */
  inline const Aws::String& GetReplicationGroupId() const { return m_replicationGroupId; }
  inline bool ReplicationGroupIdHasBeenSet() const { return m_replicationGroupIdHasBeenSet; }
  template <typename ReplicationGroupIdT = Aws::String>
  void SetReplicationGroupId(ReplicationGroupIdT&& value) {
    m_replicationGroupIdHasBeenSet = true;
    m_replicationGroupId = std::forward<ReplicationGroupIdT>(value);
  }
  template <typename ReplicationGroupIdT = Aws::String>
  TestFailoverRequest& WithReplicationGroupId(ReplicationGroupIdT&& value) {
    SetReplicationGroupId(std::forward<ReplicationGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the node group (called shard in the console) in this replication
   * group on which automatic failover is to be tested. You may test automatic
   * failover on up to 15 node groups in any rolling 24-hour period.</p>
   */
  inline const Aws::String& GetNodeGroupId() const { return m_nodeGroupId; }
  inline bool NodeGroupIdHasBeenSet() const { return m_nodeGroupIdHasBeenSet; }
  template <typename NodeGroupIdT = Aws::String>
  void SetNodeGroupId(NodeGroupIdT&& value) {
    m_nodeGroupIdHasBeenSet = true;
    m_nodeGroupId = std::forward<NodeGroupIdT>(value);
  }
  template <typename NodeGroupIdT = Aws::String>
  TestFailoverRequest& WithNodeGroupId(NodeGroupIdT&& value) {
    SetNodeGroupId(std::forward<NodeGroupIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_replicationGroupId;

  Aws::String m_nodeGroupId;
  bool m_replicationGroupIdHasBeenSet = false;
  bool m_nodeGroupIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElastiCache
}  // namespace Aws
