/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.Node;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.AllFieldsExcludeMeta;
import org.opensearch.sql.ast.expression.And;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Between;
import org.opensearch.sql.ast.expression.Case;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.ast.expression.Compare;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.In;
import org.opensearch.sql.ast.expression.Interval;
import org.opensearch.sql.ast.expression.LambdaFunction;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Map;
import org.opensearch.sql.ast.expression.Not;
import org.opensearch.sql.ast.expression.Or;
import org.opensearch.sql.ast.expression.ParseMethod;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.When;
import org.opensearch.sql.ast.expression.WindowFunction;
import org.opensearch.sql.ast.expression.Xor;
import org.opensearch.sql.ast.expression.subquery.ExistsSubquery;
import org.opensearch.sql.ast.expression.subquery.InSubquery;
import org.opensearch.sql.ast.expression.subquery.ScalarSubquery;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.ast.statement.Query;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.ast.tree.AddColTotals;
import org.opensearch.sql.ast.tree.AddTotals;
import org.opensearch.sql.ast.tree.Aggregation;
import org.opensearch.sql.ast.tree.Append;
import org.opensearch.sql.ast.tree.AppendCol;
import org.opensearch.sql.ast.tree.AppendPipe;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.Chart;
import org.opensearch.sql.ast.tree.CountBin;
import org.opensearch.sql.ast.tree.Dedupe;
import org.opensearch.sql.ast.tree.DefaultBin;
import org.opensearch.sql.ast.tree.DescribeRelation;
import org.opensearch.sql.ast.tree.Eval;
import org.opensearch.sql.ast.tree.Expand;
import org.opensearch.sql.ast.tree.FillNull;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Flatten;
import org.opensearch.sql.ast.tree.Head;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.ast.tree.MinSpanBin;
import org.opensearch.sql.ast.tree.Multisearch;
import org.opensearch.sql.ast.tree.MvCombine;
import org.opensearch.sql.ast.tree.Parse;
import org.opensearch.sql.ast.tree.Patterns;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.RangeBin;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Regex;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.Rename;
import org.opensearch.sql.ast.tree.Replace;
import org.opensearch.sql.ast.tree.Reverse;
import org.opensearch.sql.ast.tree.Rex;
import org.opensearch.sql.ast.tree.SPath;
import org.opensearch.sql.ast.tree.Search;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.ast.tree.SpanBin;
import org.opensearch.sql.ast.tree.StreamWindow;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.TableFunction;
import org.opensearch.sql.ast.tree.Transpose;
import org.opensearch.sql.ast.tree.Trendline;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.ast.tree.Window;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.ppl.utils.UnresolvedPlanHelper;
import org.opensearch.sql.utils.QueryStringUtils;

public class PPLQueryDataAnonymizer
extends AbstractNodeVisitor<String, String> {
    public static final String MASK_TABLE = "table";
    private final AnonymizerExpressionAnalyzer expressionAnalyzer = new AnonymizerExpressionAnalyzer(this);
    private final Settings settings;

    public PPLQueryDataAnonymizer(Settings settings) {
        this.settings = settings;
    }

    public String anonymizeData(UnresolvedPlan plan) {
        return (String)plan.accept((AbstractNodeVisitor)this, null);
    }

    public String anonymizeStatement(Statement plan) {
        return (String)plan.accept((AbstractNodeVisitor)this, null);
    }

    public String visitQuery(Query node, String context) {
        return (String)node.getPlan().accept((AbstractNodeVisitor)this, null);
    }

    public String visitExplain(Explain node, String context) {
        return StringUtils.format((String)"explain %s %s", (Object[])new Object[]{node.getMode().name().toLowerCase(Locale.ROOT), node.getStatement().accept((AbstractNodeVisitor)this, null)});
    }

    public String visitRelation(Relation node, String context) {
        if (node instanceof DescribeRelation) {
            return StringUtils.format((String)"describe %s", (Object[])new Object[]{MASK_TABLE});
        }
        return StringUtils.format((String)"source=%s", (Object[])new Object[]{MASK_TABLE});
    }

    public String visitJoin(Join node, String context) {
        String max;
        String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
        String rightTableOrSubquery = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
        String right = rightTableOrSubquery.startsWith("source=") ? rightTableOrSubquery.substring("source=".length()) : rightTableOrSubquery;
        Argument.ArgumentMap argumentMap = node.getArgumentMap();
        String string = max = argumentMap.get("max") == null ? "0" : argumentMap.get("max").toString().toLowerCase(Locale.ROOT);
        if (node.getJoinCondition().isEmpty()) {
            String joinType = argumentMap.get("type") == null ? "inner" : argumentMap.get("type").toString().toLowerCase(Locale.ROOT);
            String overwrite = argumentMap.get("overwrite") == null ? "true" : argumentMap.get("overwrite").toString().toLowerCase(Locale.ROOT);
            String fieldList = node.getJoinFields().isEmpty() ? "" : String.join((CharSequence)",", ((List)node.getJoinFields().get()).stream().map(c -> this.expressionAnalyzer.analyze((UnresolvedExpression)c, context)).toList());
            return StringUtils.format((String)"%s | join type=%s overwrite=%s max=%s %s %s", (Object[])new Object[]{left, joinType, "***", "***", fieldList, right});
        }
        String joinType = node.getJoinType().name().toLowerCase(Locale.ROOT);
        String leftAlias = node.getLeftAlias().map(l -> " left = identifier").orElse("");
        String rightAlias = node.getRightAlias().map(r -> " right = identifier").orElse("");
        String condition = node.getJoinCondition().map(c -> this.expressionAnalyzer.analyze((UnresolvedExpression)c, context)).orElse("true");
        return StringUtils.format((String)"%s | %s join max=%s%s%s on %s %s", (Object[])new Object[]{left, joinType, "***", leftAlias, rightAlias, condition, right});
    }

    public String visitLookup(Lookup node, String context) {
        String child = (String)((Node)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String mappingFields = this.formatFieldAlias(node.getMappingAliasMap());
        String strategy = node.getOutputAliasMap().isEmpty() ? "" : String.format(" %s ", node.getOutputStrategy().toString().toLowerCase());
        String outputFields = this.formatFieldAlias(node.getOutputAliasMap());
        return StringUtils.format((String)"%s | lookup %s %s%s%s", (Object[])new Object[]{child, MASK_TABLE, mappingFields, strategy, outputFields});
    }

    private String formatFieldAlias(java.util.Map<String, String> fieldMap) {
        return fieldMap.entrySet().stream().map(entry -> Objects.equals(entry.getKey(), entry.getValue()) ? (String)entry.getKey() : StringUtils.format((String)"%s as %s", (Object[])new Object[]{entry.getKey(), entry.getValue()})).collect(Collectors.joining(", "));
    }

    public String visitSubqueryAlias(SubqueryAlias node, String context) {
        Project project;
        Node childNode = (Node)node.getChild().get(0);
        String child = (String)childNode.accept((AbstractNodeVisitor)this, (Object)context);
        if (childNode instanceof Project && (project = (Project)childNode).getProjectList().get(0) instanceof AllFields) {
            childNode = (Node)childNode.getChild().get(0);
        }
        String format = childNode.getChild().isEmpty() ? "%s as %s" : "[ %s ] as %s";
        return StringUtils.format((String)format, (Object[])new Object[]{child, "identifier"});
    }

    public String visitTableFunction(TableFunction node, String context) {
        String arguments = node.getArguments().stream().map(unresolvedExpression -> this.expressionAnalyzer.analyze((UnresolvedExpression)unresolvedExpression, context)).collect(Collectors.joining(","));
        return StringUtils.format((String)"source=%s(%s)", (Object[])new Object[]{node.getFunctionName().toString(), arguments});
    }

    public String visitSearch(Search node, String context) {
        String source = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        return StringUtils.format((String)"%s %s", (Object[])new Object[]{source, node.getOriginalExpression().toAnonymizedString()});
    }

    public String visitFilter(Filter node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String condition = this.visitExpression(node.getCondition());
        return StringUtils.format((String)"%s | where %s", (Object[])new Object[]{child, condition});
    }

    public String visitRename(Rename node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        ImmutableMap.Builder renameMapBuilder = new ImmutableMap.Builder();
        for (Map renameMap : node.getRenameList()) {
            renameMapBuilder.put((Object)this.visitExpression(renameMap.getOrigin()), (Object)((Field)renameMap.getTarget()).getField().toString());
        }
        String renames = node.getRenameList().stream().map(entry -> StringUtils.format((String)"%s as %s", (Object[])new Object[]{"identifier", "identifier"})).collect(Collectors.joining(","));
        return StringUtils.format((String)"%s | rename %s", (Object[])new Object[]{child, renames});
    }

    public String visitReplace(Replace node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String pairs = node.getReplacePairs().stream().map(pair -> StringUtils.format((String)"%s WITH %s", (Object[])new Object[]{this.visitExpression((UnresolvedExpression)pair.getPattern()), this.visitExpression((UnresolvedExpression)pair.getReplacement())})).collect(Collectors.joining(", "));
        String fieldListStr = " IN " + node.getFieldList().stream().map(Field::toString).collect(Collectors.joining(", "));
        return StringUtils.format((String)"%s | replace %s%s", (Object[])new Object[]{child, pairs, fieldListStr});
    }

    public String visitAggregation(Aggregation node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        UnresolvedExpression span = node.getSpan();
        ArrayList<UnresolvedExpression> groupByExprList = new ArrayList<UnresolvedExpression>();
        if (!Objects.isNull(span)) {
            groupByExprList.add(span);
        }
        groupByExprList.addAll(node.getGroupExprList());
        String group = this.visitExpressionList(groupByExprList);
        return StringUtils.format((String)"%s | stats %s", (Object[])new Object[]{child, String.join((CharSequence)" ", this.visitExpressionList(node.getAggExprList()), this.groupBy(group)).trim()});
    }

    public String visitBin(Bin node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        StringBuilder binCommand = new StringBuilder();
        binCommand.append(" | bin ").append(this.visitExpression(node.getField()));
        if (node instanceof SpanBin) {
            SpanBin spanBin = (SpanBin)node;
            binCommand.append(" span=").append(this.visitExpression(spanBin.getSpan()));
            if (spanBin.getAligntime() != null) {
                binCommand.append(" aligntime=").append(this.visitExpression(spanBin.getAligntime()));
            }
        } else if (node instanceof MinSpanBin) {
            MinSpanBin minSpanBin = (MinSpanBin)node;
            binCommand.append(" minspan=").append(this.visitExpression(minSpanBin.getMinspan()));
            if (minSpanBin.getStart() != null) {
                binCommand.append(" start=").append(this.visitExpression(minSpanBin.getStart()));
            }
            if (minSpanBin.getEnd() != null) {
                binCommand.append(" end=").append(this.visitExpression(minSpanBin.getEnd()));
            }
        } else if (node instanceof CountBin) {
            CountBin countBin = (CountBin)node;
            binCommand.append(" bins=").append("***");
            if (countBin.getStart() != null) {
                binCommand.append(" start=").append(this.visitExpression(countBin.getStart()));
            }
            if (countBin.getEnd() != null) {
                binCommand.append(" end=").append(this.visitExpression(countBin.getEnd()));
            }
        } else if (node instanceof RangeBin) {
            RangeBin rangeBin = (RangeBin)node;
            if (rangeBin.getStart() != null) {
                binCommand.append(" start=").append(this.visitExpression(rangeBin.getStart()));
            }
            if (rangeBin.getEnd() != null) {
                binCommand.append(" end=").append(this.visitExpression(rangeBin.getEnd()));
            }
        } else if (node instanceof DefaultBin) {
            // empty if block
        }
        if (node.getAlias() != null) {
            binCommand.append(" as ").append("identifier");
        }
        return StringUtils.format((String)"%s%s", (Object[])new Object[]{child, binCommand.toString()});
    }

    public String visitWindow(Window node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        return StringUtils.format((String)"%s | eventstats %s", (Object[])new Object[]{child, String.join((CharSequence)" ", this.visitExpressionList(node.getWindowFunctionList())).trim()});
    }

    public String visitStreamWindow(StreamWindow node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        return StringUtils.format((String)"%s | streamstats %s", (Object[])new Object[]{child, String.join((CharSequence)" ", this.visitExpressionList(node.getWindowFunctionList())).trim()});
    }

    public String visitRareTopN(RareTopN node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        Argument.ArgumentMap arguments = Argument.ArgumentMap.of((List)node.getArguments());
        Integer noOfResults = node.getNoOfResults();
        String countField = (String)arguments.get(RareTopN.Option.countField.name()).getValue();
        Boolean showCount = (Boolean)arguments.get(RareTopN.Option.showCount.name()).getValue();
        Boolean useNull = (Boolean)arguments.get(RareTopN.Option.useNull.name()).getValue();
        String fields = this.visitFieldList(node.getFields());
        String group = this.visitExpressionList(node.getGroupExprList());
        String options = UnresolvedPlanHelper.isCalciteEnabled(this.settings) ? StringUtils.format((String)"countield='%s' showcount=%s usenull=%s ", (Object[])new Object[]{countField, showCount, useNull}) : "";
        return StringUtils.format((String)"%s | %s %d %s%s", (Object[])new Object[]{child, node.getCommandType().name().toLowerCase(), noOfResults, options, String.join((CharSequence)" ", fields, this.groupBy(group)).trim()});
    }

    public String visitProject(Project node, String context) {
        Argument argument;
        Boolean exclude;
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String arg = "+";
        String fields = this.visitExpressionList(node.getProjectList());
        if (Strings.isNullOrEmpty((String)fields)) {
            return child;
        }
        if (node.hasArgument() && (exclude = (Boolean)(argument = (Argument)node.getArgExprList().get(0)).getValue().getValue()).booleanValue()) {
            arg = "-";
        }
        return StringUtils.format((String)"%s | fields %s %s", (Object[])new Object[]{child, arg, fields});
    }

    public String visitEval(Eval node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        ImmutableList.Builder expressionsBuilder = new ImmutableList.Builder();
        for (Let let : node.getExpressionList()) {
            String expression = this.visitExpression(let.getExpression());
            String target = let.getVar().getField().toString();
            expressionsBuilder.add((Object)ImmutablePair.of((Object)target, (Object)expression));
        }
        String expressions = expressionsBuilder.build().stream().map(pair -> StringUtils.format((String)"%s=%s", (Object[])new Object[]{"identifier", pair.getRight()})).collect(Collectors.joining(" "));
        return StringUtils.format((String)"%s | eval %s", (Object[])new Object[]{child, expressions});
    }

    public String visitExpand(Expand node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().getFirst()).accept((AbstractNodeVisitor)this, (Object)context);
        String field = this.visitExpression((UnresolvedExpression)node.getField());
        return StringUtils.format((String)"%s | expand %s", (Object[])new Object[]{child, field});
    }

    public String visitMvCombine(MvCombine node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().getFirst()).accept((AbstractNodeVisitor)this, (Object)context);
        String field = this.visitExpression((UnresolvedExpression)node.getField());
        return StringUtils.format((String)"%s | mvcombine delim=%s %s", (Object[])new Object[]{child, "***", field});
    }

    public String visitSort(Sort node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        Integer count = node.getCount();
        String sortList = this.visitFieldList(node.getSortList());
        if (count != 0) {
            return StringUtils.format((String)"%s | sort %d %s", (Object[])new Object[]{child, count, sortList});
        }
        return StringUtils.format((String)"%s | sort %s", (Object[])new Object[]{child, sortList});
    }

    public String visitDedupe(Dedupe node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String fields = this.visitFieldList(node.getFields());
        List options = node.getOptions();
        Integer allowedDuplication = (Integer)((Argument)options.get(0)).getValue().getValue();
        Boolean keepEmpty = (Boolean)((Argument)options.get(1)).getValue().getValue();
        Boolean consecutive = (Boolean)((Argument)options.get(2)).getValue().getValue();
        return StringUtils.format((String)"%s | dedup %s %d keepempty=%b consecutive=%b", (Object[])new Object[]{child, fields, allowedDuplication, keepEmpty, consecutive});
    }

    public String visitHead(Head node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        Integer size = node.getSize();
        return StringUtils.format((String)"%s | head %d", (Object[])new Object[]{child, size});
    }

    public String visitReverse(Reverse node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        return StringUtils.format((String)"%s | reverse", (Object[])new Object[]{child});
    }

    public String visitChart(Chart node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        StringBuilder chartCommand = new StringBuilder();
        boolean isTimechart = this.isTimechartNode(node);
        chartCommand.append(isTimechart ? " | timechart" : " | chart");
        block14: for (Argument arg : node.getArguments()) {
            String argName = arg.getArgName();
            if ("top".equals(argName)) continue;
            switch (argName) {
                case "limit": 
                case "useother": 
                case "usenull": 
                case "otherstr": 
                case "nullstr": {
                    chartCommand.append(" ").append(argName).append("=").append("***");
                    continue block14;
                }
                case "spanliteral": {
                    chartCommand.append(" span=").append("***");
                    continue block14;
                }
                case "timefield": {
                    chartCommand.append(" ").append(argName).append("=").append("time_identifier");
                    continue block14;
                }
            }
            throw new NotImplementedException(StringUtils.format((String)"Please implement anonymizer for arg: %s", (Object[])new Object[]{argName}));
        }
        chartCommand.append(" ").append(this.visitExpression(node.getAggregationFunction()));
        if (node.getRowSplit() != null && node.getColumnSplit() != null) {
            chartCommand.append(" by");
            if (!isTimechart) {
                chartCommand.append(" ").append(this.visitExpression(node.getRowSplit()));
            }
            chartCommand.append(" ").append(this.visitExpression(node.getColumnSplit()));
        } else if (node.getRowSplit() != null && !isTimechart) {
            chartCommand.append(" by ").append(this.visitExpression(node.getRowSplit()));
        } else if (node.getColumnSplit() != null) {
            chartCommand.append(" by ").append(this.visitExpression(node.getColumnSplit()));
        }
        return StringUtils.format((String)"%s%s", (Object[])new Object[]{child, chartCommand.toString()});
    }

    private boolean isTimechartNode(Chart node) {
        Alias alias;
        if (node.getRowSplit() instanceof Alias && (alias = (Alias)node.getRowSplit()).getDelegated() instanceof Span) {
            Span span = (Span)alias.getDelegated();
            String timeFieldName = Optional.ofNullable(Argument.ArgumentMap.of((List)node.getArguments()).get("timefield")).map(Literal::toString).orElse("@timestamp");
            return span.getField() instanceof Field && timeFieldName.equals(((Field)span.getField()).getField().toString());
        }
        return false;
    }

    public String visitRex(Rex node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String field = this.visitExpression(node.getField());
        String pattern = "\"***\"";
        StringBuilder command = new StringBuilder();
        command.append(String.format("%s | rex field=%s mode=%s %s", child, field, node.getMode().toString().toLowerCase(), pattern));
        if (node.getMaxMatch().isPresent()) {
            command.append(" max_match=").append("***");
        }
        if (node.getOffsetField().isPresent()) {
            command.append(" offset_field=").append("identifier");
        }
        return command.toString();
    }

    public String visitParse(Parse node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String source = this.visitExpression(node.getSourceField());
        String regex = node.getPattern().toString();
        String commandName = switch (node.getParseMethod()) {
            case ParseMethod.PATTERNS -> "patterns";
            case ParseMethod.GROK -> "grok";
            default -> "parse";
        };
        return ParseMethod.PATTERNS.equals((Object)node.getParseMethod()) && regex.isEmpty() ? StringUtils.format((String)"%s | %s %s", (Object[])new Object[]{child, commandName, source}) : StringUtils.format((String)"%s | %s %s '%s'", (Object[])new Object[]{child, commandName, source, "***"});
    }

    public String visitRegex(Regex node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String operator = node.isNegated() ? "!=" : "=";
        String pattern = "***";
        String field = this.visitExpression(node.getField());
        return StringUtils.format((String)"%s | regex %s%s%s", (Object[])new Object[]{child, field, operator, pattern});
    }

    public String visitFlatten(Flatten node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().getFirst()).accept((AbstractNodeVisitor)this, (Object)context);
        String field = this.visitExpression((UnresolvedExpression)node.getField());
        return StringUtils.format((String)"%s | flatten %s", (Object[])new Object[]{child, field});
    }

    public String visitTrendline(Trendline node, String context) {
        String child = (String)((Node)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String computations = this.visitExpressionList(node.getComputations(), " ");
        return StringUtils.format((String)"%s | trendline %s", (Object[])new Object[]{child, computations});
    }

    public String visitTranspose(Transpose node, String context) {
        Argument numberArg;
        if (node.getChild().isEmpty()) {
            return "source=*** | transpose";
        }
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        StringBuilder anonymized = new StringBuilder(StringUtils.format((String)"%s | transpose", (Object[])new Object[]{child}));
        java.util.Map arguments = node.getArguments();
        if (arguments.containsKey("number") && (numberArg = (Argument)arguments.get("number")) != null) {
            anonymized.append(StringUtils.format((String)" %s", (Object[])new Object[]{numberArg.getValue()}));
        }
        if (arguments.containsKey("columnName")) {
            anonymized.append(StringUtils.format((String)" %s=***", (Object[])new Object[]{"column_name"}));
        }
        return anonymized.toString();
    }

    public String visitAppendCol(AppendCol node, String context) {
        String child = (String)((Node)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        UnresolvedPlan relation = PlanUtils.getRelation((UnresolvedPlan)node);
        PlanUtils.transformPlanToAttachChild((UnresolvedPlan)node.getSubSearch(), (UnresolvedPlan)relation);
        String subsearch = this.anonymizeData(node.getSubSearch());
        String subsearchWithoutRelation = subsearch.substring(subsearch.indexOf("|") + 1);
        return StringUtils.format((String)"%s | appendcol override=%s [%s ]", (Object[])new Object[]{child, node.isOverride(), subsearchWithoutRelation});
    }

    public String visitAppend(Append node, String context) {
        String child = (String)((Node)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String subsearch = this.anonymizeData(node.getSubSearch());
        return StringUtils.format((String)"%s | append [%s ]", (Object[])new Object[]{child, subsearch});
    }

    public String visitMultisearch(Multisearch node, String context) {
        ArrayList<String> anonymizedSubsearches = new ArrayList<String>();
        for (UnresolvedPlan subsearch : node.getSubsearches()) {
            Object anonymizedSubsearch = this.anonymizeData(subsearch);
            anonymizedSubsearch = "search " + (String)anonymizedSubsearch;
            anonymizedSubsearch = ((String)anonymizedSubsearch).replaceAll("\\bsource=\\w+", "source=table").replaceAll("\\b(?!source|fields|where|stats|head|tail|sort|eval|rename|multisearch|search|table|identifier|\\*\\*\\*)\\w+(?=\\s*[<>=!])", "identifier").replaceAll("\\b(?!source|fields|where|stats|head|tail|sort|eval|rename|multisearch|search|table|identifier|\\*\\*\\*)\\w+(?=\\s*,)", "identifier").replaceAll("fields \\+\\s*\\b(?!source|fields|where|stats|head|tail|sort|eval|rename|multisearch|search|table|identifier|\\*\\*\\*)\\w+", "fields + identifier").replaceAll("fields \\+\\s*identifier,\\s*\\b(?!source|fields|where|stats|head|tail|sort|eval|rename|multisearch|search|table|identifier|\\*\\*\\*)\\w+", "fields + identifier,identifier");
            anonymizedSubsearches.add(StringUtils.format((String)"[%s]", (Object[])new Object[]{anonymizedSubsearch}));
        }
        return StringUtils.format((String)"| multisearch %s", (Object[])new Object[]{String.join((CharSequence)" ", anonymizedSubsearches)});
    }

    public String visitValues(Values node, String context) {
        return "";
    }

    private String visitFieldList(List<Field> fieldList) {
        return fieldList.stream().map(this::visitExpression).collect(Collectors.joining(","));
    }

    private String visitExpressionList(List<? extends UnresolvedExpression> expressionList) {
        return this.visitExpressionList(expressionList, ",");
    }

    private String visitExpressionList(List<? extends UnresolvedExpression> expressionList, String delimiter) {
        return expressionList.isEmpty() ? "" : expressionList.stream().map(this::visitExpression).collect(Collectors.joining(delimiter));
    }

    private String visitExpression(UnresolvedExpression expression) {
        return this.expressionAnalyzer.analyze(expression, null);
    }

    public String visitAppendPipe(AppendPipe node, String context) {
        Values emptyValue = new Values(null);
        UnresolvedPlan childNode = node.getSubQuery();
        while (childNode != null && !childNode.getChild().isEmpty()) {
            childNode = (UnresolvedPlan)childNode.getChild().get(0);
        }
        childNode.attach((UnresolvedPlan)emptyValue);
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String subPipeline = this.anonymizeData(node.getSubQuery());
        return StringUtils.format((String)"%s | appendpipe [%s]", (Object[])new Object[]{child, subPipeline});
    }

    public String visitFillNull(FillNull node, String context) {
        String child = (String)((Node)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        List fieldFills = node.getReplacementPairs();
        if (node.isUseValueSyntax()) {
            if (fieldFills.isEmpty()) {
                return StringUtils.format((String)"%s | fillnull value=%s", (Object[])new Object[]{child, "***"});
            }
            return StringUtils.format((String)"%s | fillnull value=%s %s", (Object[])new Object[]{child, "***", fieldFills.stream().map(n -> this.visitExpression((UnresolvedExpression)n.getLeft())).collect(Collectors.joining(" "))});
        }
        if (fieldFills.isEmpty()) {
            return StringUtils.format((String)"%s | fillnull with %s", (Object[])new Object[]{child, "***"});
        }
        UnresolvedExpression firstReplacement = (UnresolvedExpression)((Pair)fieldFills.getFirst()).getRight();
        if (fieldFills.stream().allMatch(n -> firstReplacement == n.getRight())) {
            return StringUtils.format((String)"%s | fillnull with %s in %s", (Object[])new Object[]{child, "***", fieldFills.stream().map(n -> this.visitExpression((UnresolvedExpression)n.getLeft())).collect(Collectors.joining(", "))});
        }
        return StringUtils.format((String)"%s | fillnull using %s", (Object[])new Object[]{child, fieldFills.stream().map(n -> StringUtils.format((String)"%s = %s", (Object[])new Object[]{this.visitExpression((UnresolvedExpression)n.getLeft()), "***"})).collect(Collectors.joining(", "))});
    }

    public String visitSpath(SPath node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        StringBuilder builder = new StringBuilder();
        builder.append(child).append(" | spath");
        if (node.getInField() != null) {
            builder.append(" input=").append("identifier");
        }
        if (node.getOutField() != null) {
            builder.append(" output=").append("identifier");
        }
        if (node.getPath() != null) {
            builder.append(" path=").append("identifier");
        }
        return builder.toString();
    }

    public void appendAddTotalsOptionParameters(List<Field> fieldList, java.util.Map<String, Literal> options, StringBuilder builder) {
        if (!fieldList.isEmpty()) {
            builder.append(this.visitExpressionList(fieldList, " "));
        }
        if (!options.isEmpty()) {
            for (String key : options.keySet()) {
                String value = options.get(key).toString();
                if (value.matches(".*\\s.*")) {
                    value = StringUtils.format((String)"'%s'", (Object[])new Object[]{value});
                }
                builder.append(" ").append(key).append("=").append(value);
            }
        }
    }

    public String visitAddTotals(AddTotals node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        StringBuilder builder = new StringBuilder();
        builder.append(child).append(" | addtotals");
        this.appendAddTotalsOptionParameters(node.getFieldList(), node.getOptions(), builder);
        return builder.toString();
    }

    public String visitAddColTotals(AddColTotals node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        StringBuilder builder = new StringBuilder();
        builder.append(child).append(" | addcoltotals");
        this.appendAddTotalsOptionParameters(node.getFieldList(), node.getOptions(), builder);
        return builder.toString();
    }

    public String visitPatterns(Patterns node, String context) {
        String child = (String)((UnresolvedPlan)node.getChild().get(0)).accept((AbstractNodeVisitor)this, (Object)context);
        String sourceField = this.visitExpression(node.getSourceField());
        StringBuilder builder = new StringBuilder();
        builder.append(child).append(" | patterns ").append(sourceField);
        if (!node.getPartitionByList().isEmpty()) {
            String partitionByList = this.visitExpressionList(node.getPartitionByList());
            builder.append(" by ").append(partitionByList);
        }
        builder.append(" method=").append(node.getPatternMethod().toString());
        builder.append(" mode=").append(node.getPatternMode().toString());
        builder.append(" max_sample_count=").append(this.visitExpression(node.getPatternMaxSampleCount()));
        builder.append(" buffer_limit=").append(this.visitExpression(node.getPatternBufferLimit()));
        builder.append(" new_field=").append("identifier");
        if (!node.getArguments().isEmpty()) {
            for (Map.Entry entry : node.getArguments().entrySet()) {
                builder.append(String.format(Locale.ROOT, " %s=%s", entry.getKey(), this.visitExpression((UnresolvedExpression)entry.getValue())));
            }
        }
        return builder.toString();
    }

    private String groupBy(String groupBy) {
        return Strings.isNullOrEmpty((String)groupBy) ? "" : StringUtils.format((String)"by %s", (Object[])new Object[]{groupBy});
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    private static class AnonymizerExpressionAnalyzer
    extends AbstractNodeVisitor<String, String> {
        private final PPLQueryDataAnonymizer queryAnonymizer;

        public AnonymizerExpressionAnalyzer(PPLQueryDataAnonymizer queryAnonymizer) {
            this.queryAnonymizer = queryAnonymizer;
        }

        public String analyze(UnresolvedExpression unresolved, String context) {
            return (String)unresolved.accept((AbstractNodeVisitor)this, (Object)context);
        }

        public String visitLiteral(Literal node, String context) {
            return "***";
        }

        public String visitInterval(Interval node, String context) {
            String value = (String)node.getValue().accept((AbstractNodeVisitor)this, (Object)context);
            String unit = node.getUnit().name();
            return StringUtils.format((String)"INTERVAL %s %s", (Object[])new Object[]{value, unit});
        }

        public String visitAnd(And node, String context) {
            String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
            String right = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s and %s", (Object[])new Object[]{left, right});
        }

        public String visitOr(Or node, String context) {
            String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
            String right = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s or %s", (Object[])new Object[]{left, right});
        }

        public String visitXor(Xor node, String context) {
            String left = (String)node.getLeft().accept((AbstractNodeVisitor)this, (Object)context);
            String right = (String)node.getRight().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s xor %s", (Object[])new Object[]{left, right});
        }

        public String visitNot(Not node, String context) {
            String expr = (String)node.getExpression().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"not %s", (Object[])new Object[]{expr});
        }

        public String visitAggregateFunction(AggregateFunction node, String context) {
            String arg = (String)node.getField().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{node.getFuncName(), arg});
        }

        public String visitSpan(Span node, String context) {
            String field = this.analyze(node.getField(), context);
            String value = this.analyze(node.getValue(), context);
            return StringUtils.format((String)"span(%s, %s %s)", (Object[])new Object[]{field, value, node.getUnit().getName()});
        }

        public String visitFunction(Function node, String context) {
            if ("mvmap".equalsIgnoreCase(node.getFuncName()) && node.getFuncArgs().size() == 2 && node.getFuncArgs().get(1) instanceof LambdaFunction) {
                String firstArg = this.analyze((UnresolvedExpression)node.getFuncArgs().get(0), context);
                LambdaFunction lambda = (LambdaFunction)node.getFuncArgs().get(1);
                String lambdaBody = this.analyze(lambda.getFunction(), context);
                return StringUtils.format((String)"%s(%s,%s)", (Object[])new Object[]{node.getFuncName(), firstArg, lambdaBody});
            }
            String arguments = node.getFuncArgs().stream().map(unresolvedExpression -> this.analyze((UnresolvedExpression)unresolvedExpression, context)).collect(Collectors.joining(","));
            return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{node.getFuncName(), arguments});
        }

        public String visitLambdaFunction(LambdaFunction node, String context) {
            String args = node.getFuncArgs().stream().map(arg -> QueryStringUtils.maskField((String)arg.toString())).collect(Collectors.joining(","));
            String function = this.analyze(node.getFunction(), context);
            return StringUtils.format((String)"%s -> %s", (Object[])new Object[]{args, function});
        }

        public String visitWindowFunction(WindowFunction node, String context) {
            String function = this.analyze(node.getFunction(), context);
            String partitions = node.getPartitionByList().stream().map(p -> this.analyze((UnresolvedExpression)p, context)).collect(Collectors.joining(","));
            if (partitions.isEmpty()) {
                return StringUtils.format((String)"%s", (Object[])new Object[]{function});
            }
            return StringUtils.format((String)"%s by %s", (Object[])new Object[]{function, partitions});
        }

        public String visitCompare(Compare node, String context) {
            String left = this.analyze(node.getLeft(), context);
            String right = this.analyze(node.getRight(), context);
            return StringUtils.format((String)"%s %s %s", (Object[])new Object[]{left, node.getOperator(), right});
        }

        public String visitBetween(Between node, String context) {
            String value = this.analyze(node.getValue(), context);
            String left = this.analyze(node.getLowerBound(), context);
            String right = this.analyze(node.getUpperBound(), context);
            return StringUtils.format((String)"%s between %s and %s", (Object[])new Object[]{value, left, right});
        }

        public String visitIn(In node, String context) {
            String field = this.analyze(node.getField(), context);
            return StringUtils.format((String)"%s in (%s)", (Object[])new Object[]{field, "***"});
        }

        public String visitField(Field node, String context) {
            String fieldName = node.getField().toString();
            return QueryStringUtils.maskField((String)fieldName);
        }

        public String visitAllFields(AllFields node, String context) {
            return "";
        }

        public String visitAllFieldsExcludeMeta(AllFieldsExcludeMeta node, String context) {
            return "";
        }

        public String visitAlias(Alias node, String context) {
            String expr = (String)node.getDelegated().accept((AbstractNodeVisitor)this, (Object)context);
            return StringUtils.format((String)"%s", (Object[])new Object[]{expr});
        }

        public String visitTrendlineComputation(Trendline.TrendlineComputation node, String context) {
            String dataField = (String)node.getDataField().accept((AbstractNodeVisitor)this, (Object)context);
            String aliasClause = " as identifier";
            String computationType = node.getComputationType().name().toLowerCase(Locale.ROOT);
            return StringUtils.format((String)"%s(%d, %s)%s", (Object[])new Object[]{computationType, node.getNumberOfDataPoints(), dataField, " as identifier"});
        }

        public String visitInSubquery(InSubquery node, String context) {
            String nodes = node.getChild().stream().map(c -> this.analyze((UnresolvedExpression)c, context)).collect(Collectors.joining(","));
            String subquery = this.queryAnonymizer.anonymizeData(node.getQuery());
            return StringUtils.format((String)"(%s) in [ %s ]", (Object[])new Object[]{nodes, subquery});
        }

        public String visitScalarSubquery(ScalarSubquery node, String context) {
            String subquery = this.queryAnonymizer.anonymizeData(node.getQuery());
            return StringUtils.format((String)"[ %s ]", (Object[])new Object[]{subquery});
        }

        public String visitExistsSubquery(ExistsSubquery node, String context) {
            String subquery = this.queryAnonymizer.anonymizeData(node.getQuery());
            return StringUtils.format((String)"exists [ %s ]", (Object[])new Object[]{subquery});
        }

        public String visitCase(Case node, String context) {
            StringBuilder builder = new StringBuilder();
            builder.append("case(");
            for (When when : node.getWhenClauses()) {
                builder.append(this.analyze(when.getCondition(), context));
                builder.append(",");
                builder.append(this.analyze(when.getResult(), context));
                builder.append(",");
            }
            builder.deleteCharAt(builder.lastIndexOf(","));
            node.getElseClause().ifPresent(elseClause -> {
                builder.append(" else ");
                builder.append(this.analyze((UnresolvedExpression)elseClause, context));
            });
            builder.append(")");
            return builder.toString();
        }

        public String visitCast(Cast node, String context) {
            String expr = this.analyze(node.getExpression(), context);
            return StringUtils.format((String)"cast(%s as %s)", (Object[])new Object[]{expr, node.getConvertedType().toString()});
        }

        public String visitQualifiedName(QualifiedName node, String context) {
            return "identifier";
        }
    }
}

