/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.EnumSet;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.core.util.Throwables;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.NoShardAvailableActionException;
import org.opensearch.action.UnavailableShardsException;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NotSerializableExceptionWrapper;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;

public class ExceptionUtil {
    private static final EnumSet<RestStatus> RETRYABLE_STATUS = EnumSet.of(RestStatus.REQUEST_TIMEOUT, RestStatus.CONFLICT, RestStatus.INTERNAL_SERVER_ERROR);

    public static boolean isException(Throwable exception, Class<? extends Exception> expected, String expectedExceptionName) {
        if (exception == null) {
            return false;
        }
        if (expected.isAssignableFrom(exception.getClass())) {
            return true;
        }
        return exception instanceof NotSerializableExceptionWrapper && exception.getMessage().trim().startsWith(expectedExceptionName);
    }

    public static String getShardsFailure(IndexResponse response) {
        if (response != null && response.getShardInfo() != null && response.getShardInfo().getFailed() > 0) {
            StringBuilder failureReasons = new StringBuilder();
            for (ReplicationResponse.ShardInfo.Failure failure : response.getShardInfo().getFailures()) {
                failureReasons.append(failure.reason());
            }
            return failureReasons.toString();
        }
        return null;
    }

    public static boolean countInStats(Exception e) {
        return !(e instanceof TimeSeriesException) || ((TimeSeriesException)e).isCountedInStats();
    }

    public static String getErrorMessage(Exception e) {
        if (e.getMessage() != null && (e instanceof IllegalArgumentException || e instanceof TimeSeriesException)) {
            return e.getMessage();
        }
        if (e instanceof OpenSearchException) {
            return ((OpenSearchException)e).getDetailedMessage();
        }
        return ExceptionUtils.getStackTrace((Throwable)e);
    }

    public static boolean isOverloaded(Throwable exception) {
        Throwable cause = Throwables.getRootCause((Throwable)exception);
        return cause instanceof RejectedExecutionException || cause instanceof OpenSearchRejectedExecutionException || cause instanceof UnavailableShardsException || cause instanceof LimitExceededException;
    }

    public static boolean isRetryAble(Exception e) {
        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
        RestStatus status = ExceptionsHelper.status((Throwable)cause);
        return ExceptionUtil.isRetryAble(status);
    }

    public static boolean isRetryAble(RestStatus status) {
        return RETRYABLE_STATUS.contains(status);
    }

    public static <T> ActionListener<T> wrapListener(ActionListener<T> original, Exception exceptionToReturn, String detectorId) {
        return ActionListener.wrap(r -> original.onFailure(exceptionToReturn), e -> original.onFailure(ExceptionUtil.selectHigherPriorityException(exceptionToReturn, e)));
    }

    public static Exception selectHigherPriorityException(Exception exception1, Exception exception2) {
        if (exception1 instanceof EndRunException) {
            EndRunException endRunException = (EndRunException)exception1;
            if (endRunException.isEndNow()) {
                return exception1;
            }
            if (!(exception2 instanceof EndRunException) || !((EndRunException)exception2).isEndNow()) {
                return exception1;
            }
        }
        return exception2;
    }

    public static boolean isIndexNotAvailable(Exception e) {
        if (e == null) {
            return false;
        }
        return e instanceof IndexNotFoundException || e instanceof NoShardAvailableActionException;
    }
}

