"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEncrypt = void 0;
const encrypt_stream_1 = require("./encrypt_stream");
const encrypt_1 = require("./encrypt");
const material_management_node_1 = require("@aws-crypto/material-management-node");
function buildEncrypt(options = {}) {
    const { commitmentPolicy = material_management_node_1.CommitmentPolicy.REQUIRE_ENCRYPT_REQUIRE_DECRYPT, maxEncryptedDataKeys = false, } = typeof options === 'string' ? { commitmentPolicy: options } : options;
    /* Precondition: node buildEncrypt needs a valid commitmentPolicy. */
    (0, material_management_node_1.needs)(material_management_node_1.CommitmentPolicy[commitmentPolicy], 'Invalid commitment policy.');
    /* Precondition: node buildEncrypt needs a valid maxEncryptedDataKeys. */
    (0, material_management_node_1.needs)(maxEncryptedDataKeys === false || maxEncryptedDataKeys >= 1, 'Invalid maxEncryptedDataKeys value.');
    const clientOptions = {
        commitmentPolicy,
        maxEncryptedDataKeys,
    };
    return {
        encryptStream: encrypt_stream_1._encryptStream.bind({}, clientOptions),
        encrypt: encrypt_1._encrypt.bind({}, clientOptions),
    };
}
exports.buildEncrypt = buildEncrypt;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5jcnlwdF9jbGllbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZW5jcnlwdF9jbGllbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7OztBQUV0QyxxREFBaUQ7QUFDakQsdUNBQW9DO0FBQ3BDLG1GQUk2QztBQVM3QyxTQUFnQixZQUFZLENBQzFCLFVBQXFELEVBQUU7SUFPdkQsTUFBTSxFQUNKLGdCQUFnQixHQUFHLDJDQUFnQixDQUFDLCtCQUErQixFQUNuRSxvQkFBb0IsR0FBRyxLQUFLLEdBQzdCLEdBQUcsT0FBTyxPQUFPLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLGdCQUFnQixFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUE7SUFFekUscUVBQXFFO0lBQ3JFLElBQUEsZ0NBQUssRUFBQywyQ0FBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLDRCQUE0QixDQUFDLENBQUE7SUFDdkUseUVBQXlFO0lBQ3pFLElBQUEsZ0NBQUssRUFDSCxvQkFBb0IsS0FBSyxLQUFLLElBQUksb0JBQW9CLElBQUksQ0FBQyxFQUMzRCxxQ0FBcUMsQ0FDdEMsQ0FBQTtJQUVELE1BQU0sYUFBYSxHQUFrQjtRQUNuQyxnQkFBZ0I7UUFDaEIsb0JBQW9CO0tBQ3JCLENBQUE7SUFDRCxPQUFPO1FBQ0wsYUFBYSxFQUFFLCtCQUFjLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxhQUFhLENBQUM7UUFDckQsT0FBTyxFQUFFLGtCQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxhQUFhLENBQUM7S0FDMUMsQ0FBQTtBQUNILENBQUM7QUE3QkQsb0NBNkJDIn0=