/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityReservation;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse;

public class DescribeCapacityReservationsIterable
implements SdkIterable<DescribeCapacityReservationsResponse> {
    private final Ec2Client client;
    private final DescribeCapacityReservationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityReservationsIterable(Ec2Client client, DescribeCapacityReservationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityReservationsResponseFetcher();
    }

    public Iterator<DescribeCapacityReservationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityReservation> capacityReservations() {
        Function<DescribeCapacityReservationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityReservations() != null) {
                return response.capacityReservations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityReservationsResponseFetcher
    implements SyncPageFetcher<DescribeCapacityReservationsResponse> {
        private DescribeCapacityReservationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityReservationsResponse nextPage(DescribeCapacityReservationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityReservationsIterable.this.client.describeCapacityReservations(DescribeCapacityReservationsIterable.this.firstRequest);
            }
            return DescribeCapacityReservationsIterable.this.client.describeCapacityReservations((DescribeCapacityReservationsRequest)((Object)DescribeCapacityReservationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

