/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.assertion;

import java.util.Objects;
import org.assertj.core.api.recursive.AbstractRecursiveOperationConfiguration;
import org.assertj.core.api.recursive.assertion.DefaultRecursiveAssertionIntrospectionStrategy;
import org.assertj.core.api.recursive.assertion.RecursiveAssertionIntrospectionStrategy;
import org.assertj.core.configuration.ConfigurationProvider;

public class RecursiveAssertionConfiguration
extends AbstractRecursiveOperationConfiguration {
    private boolean ignorePrimitiveFields;
    private final boolean skipJavaLibraryTypeObjects;
    private CollectionAssertionPolicy collectionAssertionPolicy;
    private MapAssertionPolicy mapAssertionPolicy;
    private OptionalAssertionPolicy optionalAssertionPolicy;
    private boolean ignoreAllNullFields;
    private RecursiveAssertionIntrospectionStrategy introspectionStrategy;

    private RecursiveAssertionConfiguration(Builder builder) {
        super(builder);
        this.ignorePrimitiveFields = builder.ignorePrimitiveFields;
        this.skipJavaLibraryTypeObjects = builder.skipJavaLibraryTypeObjects;
        this.collectionAssertionPolicy = builder.collectionAssertionPolicy;
        this.mapAssertionPolicy = builder.mapAssertionPolicy;
        this.optionalAssertionPolicy = builder.optionalAssertionPolicy;
        this.ignoreAllNullFields = builder.ignoreAllNullFields;
        this.introspectionStrategy = builder.introspectionStrategy;
    }

    public void ignorePrimitiveFields(boolean ignorePrimitiveFields) {
        this.ignorePrimitiveFields = ignorePrimitiveFields;
    }

    public void ignoreAllNullFields(boolean ignoreAllNullFields) {
        this.ignoreAllNullFields = ignoreAllNullFields;
    }

    @Override
    public void ignoreFields(String ... fieldsToIgnore) {
        super.ignoreFields(fieldsToIgnore);
    }

    @Override
    public void ignoreFieldsMatchingRegexes(String ... regexes) {
        super.ignoreFieldsMatchingRegexes(regexes);
    }

    @Override
    public void ignoreFieldsOfTypes(Class<?> ... types) {
        super.ignoreFieldsOfTypes(types);
    }

    public void setOptionalAssertionPolicy(OptionalAssertionPolicy optionalAssertionPolicy) {
        this.optionalAssertionPolicy = optionalAssertionPolicy;
    }

    public void setMapAssertionPolicy(MapAssertionPolicy mapAssertionPolicy) {
        this.mapAssertionPolicy = mapAssertionPolicy;
    }

    public void setCollectionAssertionPolicy(CollectionAssertionPolicy collectionAssertionPolicy) {
        this.collectionAssertionPolicy = collectionAssertionPolicy;
    }

    public void setIntrospectionStrategy(RecursiveAssertionIntrospectionStrategy introspectionStrategy) {
        this.introspectionStrategy = introspectionStrategy;
    }

    public String toString() {
        ConfigurationProvider.CONFIGURATION_PROVIDER.representation();
        StringBuilder description = new StringBuilder();
        this.describeIgnoreAllNullFields(description);
        this.describeIgnoredFields(description);
        this.describeIgnoredFieldsRegexes(description);
        this.describeIgnoredFieldsOfTypes(description);
        this.describeIgnorePrimitiveFields(description);
        this.describeSkipJCLTypeObjects(description);
        this.describeCollectionAssertionPolicy(description);
        this.describeMapAssertionPolicy(description);
        this.describeOptionalAssertionPolicy(description);
        this.describeIntrospectionStrategy(description);
        return description.toString();
    }

    boolean shouldIgnorePrimitiveFields() {
        return this.ignorePrimitiveFields;
    }

    boolean shouldSkipJavaLibraryTypeObjects() {
        return this.skipJavaLibraryTypeObjects;
    }

    CollectionAssertionPolicy getCollectionAssertionPolicy() {
        return this.collectionAssertionPolicy;
    }

    MapAssertionPolicy getMapAssertionPolicy() {
        return this.mapAssertionPolicy;
    }

    OptionalAssertionPolicy getOptionalAssertionPolicy() {
        return this.optionalAssertionPolicy;
    }

    RecursiveAssertionIntrospectionStrategy getIntrospectionStrategy() {
        return this.introspectionStrategy;
    }

    boolean shouldIgnoreMap() {
        return this.mapAssertionPolicy == MapAssertionPolicy.MAP_VALUES_ONLY;
    }

    boolean shouldIgnoreOptional() {
        return this.optionalAssertionPolicy == OptionalAssertionPolicy.OPTIONAL_VALUE_ONLY;
    }

    boolean shouldIgnoreContainer() {
        return this.collectionAssertionPolicy == CollectionAssertionPolicy.ELEMENTS_ONLY;
    }

    boolean shouldIgnoreAllNullFields() {
        return this.ignoreAllNullFields;
    }

    private void describeIgnoreAllNullFields(StringBuilder description) {
        if (this.shouldIgnoreAllNullFields()) {
            description.append("- all null fields were ignored in the assertion%n".formatted(new Object[0]));
        }
    }

    private void describeIgnorePrimitiveFields(StringBuilder description) {
        if (this.shouldIgnorePrimitiveFields()) {
            description.append("- primitive fields were ignored in the recursive assertion%n".formatted(new Object[0]));
        }
    }

    private void describeSkipJCLTypeObjects(StringBuilder description) {
        if (!this.shouldSkipJavaLibraryTypeObjects()) {
            description.append("- fields from Java Class Library types (java.* or javax.*) were included in the recursive assertion%n".formatted(new Object[0]));
        } else {
            description.append("- fields from Java Class Library types (java.* or javax.*) were excluded in the recursive assertion%n".formatted(new Object[0]));
        }
    }

    private void describeCollectionAssertionPolicy(StringBuilder description) {
        description.append("- the collection assertion policy was %s%n".formatted(this.getCollectionAssertionPolicy().name()));
    }

    private void describeMapAssertionPolicy(StringBuilder description) {
        description.append("- the map assertion policy was %s%n".formatted(this.getMapAssertionPolicy().name()));
    }

    private void describeOptionalAssertionPolicy(StringBuilder description) {
        description.append("- the optional assertion policy was %s%n".formatted(this.getOptionalAssertionPolicy().name()));
    }

    private void describeIgnoredFieldsOfTypes(StringBuilder description) {
        if (!this.getIgnoredTypes().isEmpty()) {
            description.append("- the following types were ignored in the assertion: %s%n".formatted(this.describeIgnoredTypes()));
        }
    }

    private void describeIntrospectionStrategy(StringBuilder description) {
        description.append("- the introspection strategy used was: %s%n".formatted(this.introspectionStrategy.getDescription()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecursiveAssertionConfiguration that = (RecursiveAssertionConfiguration)o;
        return this.shouldIgnoreAllNullFields() == that.shouldIgnoreAllNullFields() && Objects.equals(this.getIgnoredFields(), that.getIgnoredFields()) && Objects.equals(this.getIgnoredFieldsRegexes(), that.getIgnoredFieldsRegexes()) && this.shouldIgnorePrimitiveFields() == that.shouldIgnorePrimitiveFields() && this.shouldSkipJavaLibraryTypeObjects() == that.shouldSkipJavaLibraryTypeObjects() && this.getCollectionAssertionPolicy() == that.getCollectionAssertionPolicy() && this.getOptionalAssertionPolicy() == that.getOptionalAssertionPolicy() && this.getMapAssertionPolicy() == that.getMapAssertionPolicy();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shouldIgnoreAllNullFields(), this.getIgnoredFields(), this.getIgnoredFieldsRegexes(), this.getIgnoredTypes(), this.shouldIgnorePrimitiveFields(), this.shouldSkipJavaLibraryTypeObjects(), this.getCollectionAssertionPolicy(), this.getOptionalAssertionPolicy(), this.getMapAssertionPolicy()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractRecursiveOperationConfiguration.AbstractBuilder<Builder> {
        private boolean ignorePrimitiveFields = false;
        private boolean skipJavaLibraryTypeObjects = true;
        private CollectionAssertionPolicy collectionAssertionPolicy = CollectionAssertionPolicy.ELEMENTS_ONLY;
        private MapAssertionPolicy mapAssertionPolicy = MapAssertionPolicy.MAP_VALUES_ONLY;
        private OptionalAssertionPolicy optionalAssertionPolicy = OptionalAssertionPolicy.OPTIONAL_VALUE_ONLY;
        private boolean ignoreAllNullFields;
        private RecursiveAssertionIntrospectionStrategy introspectionStrategy = new DefaultRecursiveAssertionIntrospectionStrategy();

        private Builder() {
            super(Builder.class);
        }

        @Override
        public Builder withIgnoredFields(String ... fieldsToIgnore) {
            return (Builder)super.withIgnoredFields(fieldsToIgnore);
        }

        @Override
        public Builder withIgnoredFieldsMatchingRegexes(String ... regexes) {
            return (Builder)super.withIgnoredFieldsMatchingRegexes(regexes);
        }

        public Builder withIgnoreAllNullFields(boolean ignoreAllNullFields) {
            this.ignoreAllNullFields = ignoreAllNullFields;
            return this;
        }

        public Builder withIgnorePrimitiveFields(boolean ignorePrimitiveFields) {
            this.ignorePrimitiveFields = ignorePrimitiveFields;
            return this;
        }

        public Builder withRecursionIntoJavaClassLibraryTypes(boolean recursionIntoJavaClassLibraryTypes) {
            this.skipJavaLibraryTypeObjects = !recursionIntoJavaClassLibraryTypes;
            return this;
        }

        @Override
        public Builder withIgnoredFieldsOfTypes(Class<?> ... types) {
            return (Builder)super.withIgnoredFieldsOfTypes(types);
        }

        public Builder withCollectionAssertionPolicy(CollectionAssertionPolicy policy) {
            this.collectionAssertionPolicy = policy;
            return this;
        }

        public Builder withMapAssertionPolicy(MapAssertionPolicy policy) {
            this.mapAssertionPolicy = policy;
            return this;
        }

        public Builder withOptionalAssertionPolicy(OptionalAssertionPolicy policy) {
            this.optionalAssertionPolicy = policy;
            return this;
        }

        public Builder withIntrospectionStrategy(RecursiveAssertionIntrospectionStrategy introspectionStrategy) {
            this.introspectionStrategy = introspectionStrategy;
            return this;
        }

        public RecursiveAssertionConfiguration build() {
            return new RecursiveAssertionConfiguration(this);
        }
    }

    public static enum CollectionAssertionPolicy {
        ELEMENTS_ONLY,
        COLLECTION_OBJECT_ONLY,
        COLLECTION_OBJECT_AND_ELEMENTS;

    }

    public static enum MapAssertionPolicy {
        MAP_OBJECT_ONLY,
        MAP_VALUES_ONLY,
        MAP_OBJECT_AND_ENTRIES;

    }

    public static enum OptionalAssertionPolicy {
        OPTIONAL_VALUE_ONLY,
        OPTIONAL_OBJECT_ONLY,
        OPTIONAL_OBJECT_AND_VALUE;

    }
}

