/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public class SelectFilesDialog
extends DialogWrapper
implements ActionListener {
    @NotNull
    private final SortedSet<String> myPaths;
    private FilesList myFilesList;
    private JButton mySelectAllButton;
    private JButton myDeselectAllButton;

    public SelectFilesDialog(@NotNull Project project, @NotNull SortedSet<String> paths) {
        if (project == null) {
            SelectFilesDialog.$$$reportNull$$$0(0);
        }
        if (paths == null) {
            SelectFilesDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myPaths = paths;
        this.setOKButtonText(SvnBundle.message("action.name.mark.resolved", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.mark.resolved", new Object[0]));
        this.setResizable(true);
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    @NotNull
    protected String getHelpId() {
        return "vcs.subversion.resolve";
    }

    protected void init() {
        super.init();
        this.mySelectAllButton.addActionListener(this);
        this.myDeselectAllButton.addActionListener(this);
    }

    protected String getDimensionServiceKey() {
        return "svn.selectFilesDialog";
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFilesList;
    }

    public boolean isOKActionEnabled() {
        return !this.getSelectedPaths().isEmpty();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(5, 5));
        JLabel label = new JLabel(SvnBundle.message("label.select.files.and.directories.to.mark.resolved", new Object[0]));
        panel2.add((Component)label, "North");
        this.myFilesList = new FilesList(this.myPaths);
        int height = this.myFilesList.getFontMetrics(this.myFilesList.getFont()).getHeight();
        this.myFilesList.setPreferredSize(new Dimension(this.myFilesList.getPreferredSize().width, height * 7));
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFilesList)), "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        this.mySelectAllButton = new JButton(SvnBundle.message("button.text.select.all", new Object[0]));
        this.myDeselectAllButton = new JButton(SvnBundle.message("button.text.deselect.all", new Object[0]));
        buttonsPanel.add(this.mySelectAllButton);
        buttonsPanel.add(this.myDeselectAllButton);
        panel2.add((Component)buttonsPanel, "South");
        return panel2;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (String file : this.myPaths) {
            this.myFilesList.setChecked(file, e.getSource() == this.mySelectAllButton);
        }
        this.myFilesList.clear();
        this.myFilesList.init();
        this.setOKActionEnabled(this.isOKActionEnabled());
    }

    @NotNull
    public SortedSet<String> getSelectedPaths() {
        SortedSet<String> sortedSet = this.myFilesList.getSelectedPaths();
        if (sortedSet == null) {
            SelectFilesDialog.$$$reportNull$$$0(2);
        }
        return sortedSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/SelectFilesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/SelectFilesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class FilesList
    extends OrderPanel<String> {
        private final Map<String, Boolean> mySelectedFiles;

        private FilesList(SortedSet<String> paths) {
            if (paths == null) {
                FilesList.$$$reportNull$$$0(0);
            }
            super(String.class);
            this.mySelectedFiles = new TreeMap<String, Boolean>();
            for (String path : paths) {
                this.mySelectedFiles.put(path, Boolean.TRUE);
            }
            this.init();
        }

        public boolean isChecked(@NotNull String entry) {
            if (entry == null) {
                FilesList.$$$reportNull$$$0(1);
            }
            return FilesList.isChecked(this.mySelectedFiles.get(entry));
        }

        public void setChecked(@NotNull String entry, boolean checked) {
            if (entry == null) {
                FilesList.$$$reportNull$$$0(2);
            }
            this.mySelectedFiles.put(entry, checked);
            SelectFilesDialog.this.getOKAction().setEnabled(SelectFilesDialog.this.isOKActionEnabled());
        }

        private void init() {
            this.addAll(this.mySelectedFiles.keySet());
        }

        @NotNull
        private SortedSet<String> getSelectedPaths() {
            TreeSet<String> selected = new TreeSet<String>();
            for (Map.Entry<String, Boolean> entry : this.mySelectedFiles.entrySet()) {
                if (!FilesList.isChecked(entry.getValue())) continue;
                selected.add(entry.getKey());
            }
            SortedSet<String> sortedSet = Collections.unmodifiableSortedSet(selected);
            if (sortedSet == null) {
                FilesList.$$$reportNull$$$0(3);
            }
            return sortedSet;
        }

        private static boolean isChecked(@Nullable Boolean value) {
            return Boolean.TRUE.equals(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/dialogs/SelectFilesDialog$FilesList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/dialogs/SelectFilesDialog$FilesList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isChecked";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setChecked";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

