/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import org.freeplane.main.application.AuxillaryEditorSplitPane;

class SplitPaneLayoutManagerDecorator
implements LayoutManager {
    private final LayoutManager lm;

    SplitPaneLayoutManagerDecorator(LayoutManager lm) {
        this.lm = lm;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.lm.removeLayoutComponent(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        JSplitPane splitPane = (JSplitPane)parent;
        if (this.isDividerRequired(splitPane)) {
            return this.lm.preferredLayoutSize(parent);
        }
        if (splitPane instanceof AuxillaryEditorSplitPane) {
            AuxillaryEditorSplitPane a = (AuxillaryEditorSplitPane)splitPane;
            JComponent aux = a.getAuxiliaryComponent();
            Component primary = aux == splitPane.getLeftComponent() ? splitPane.getRightComponent() : splitPane.getLeftComponent();
            return primary != null ? primary.getPreferredSize() : this.lm.preferredLayoutSize(parent);
        }
        return splitPane.getLeftComponent().getPreferredSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        JSplitPane splitPane = (JSplitPane)parent;
        if (this.isDividerRequired(splitPane)) {
            return this.lm.minimumLayoutSize(parent);
        }
        if (splitPane instanceof AuxillaryEditorSplitPane) {
            AuxillaryEditorSplitPane a = (AuxillaryEditorSplitPane)splitPane;
            JComponent aux = a.getAuxiliaryComponent();
            Component primary = aux == splitPane.getLeftComponent() ? splitPane.getRightComponent() : splitPane.getLeftComponent();
            return primary != null ? primary.getMinimumSize() : this.lm.minimumLayoutSize(parent);
        }
        return splitPane.getLeftComponent().getMinimumSize();
    }

    @Override
    public void layoutContainer(Container parent) {
        AuxillaryEditorSplitPane a;
        JComponent aux;
        JSplitPane splitPane = (JSplitPane)parent;
        if (this.isDividerRequired(splitPane)) {
            this.lm.layoutContainer(parent);
            return;
        }
        Component primary = splitPane instanceof AuxillaryEditorSplitPane ? ((aux = (a = (AuxillaryEditorSplitPane)splitPane).getAuxiliaryComponent()) == splitPane.getLeftComponent() ? splitPane.getRightComponent() : splitPane.getLeftComponent()) : splitPane.getLeftComponent();
        for (int i = 0; i < splitPane.getComponentCount(); ++i) {
            Component component = splitPane.getComponent(i);
            if (component.equals(primary)) {
                component.setBounds(0, 0, splitPane.getWidth(), splitPane.getHeight());
                continue;
            }
            component.setBounds(0, 0, 0, 0);
        }
    }

    boolean isDividerRequired(JSplitPane splitPane) {
        if (splitPane instanceof AuxillaryEditorSplitPane) {
            AuxillaryEditorSplitPane a = (AuxillaryEditorSplitPane)splitPane;
            JComponent aux = a.getAuxiliaryComponent();
            return aux != null && aux.isVisible();
        }
        Component rightComponent = splitPane.getRightComponent();
        boolean rightComponentVisible = rightComponent != null && rightComponent.isVisible();
        return rightComponentVisible;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.lm.addLayoutComponent(name, comp);
    }
}

