/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.freeplane.core.ui.components.JAutoScrollBarPane;
import org.freeplane.core.ui.components.UITools;

public class PopupDialog {
    public static JDialog createOptionPanelPopupDialog(Component popup) {
        Component optionComponent;
        if (popup instanceof JScrollPane) {
            optionComponent = popup;
        } else {
            JAutoScrollBarPane scrollPane = new JAutoScrollBarPane(popup);
            UITools.setScrollbarIncrement(scrollPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            optionComponent = scrollPane;
        }
        JOptionPane pane = new JOptionPane(optionComponent);
        Component menuComponent = UITools.getMenuComponent();
        JDialog d = pane.createDialog(menuComponent, popup.getName());
        d.getRootPane().applyComponentOrientation(menuComponent.getComponentOrientation());
        d.setDefaultCloseOperation(2);
        d.setModal(false);
        d.pack();
        PopupDialog.closeWhenOwnerIsFocused(d);
        return d;
    }

    public static void closeWhenOwnerIsFocused(final JDialog d) {
        final Window frame = d.getOwner();
        d.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                frame.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        d.setVisible(false);
                        frame.removeWindowFocusListener(this);
                    }
                });
                d.removeWindowFocusListener(this);
            }
        });
    }

    public static void closeOnEscape(final JDialog dialog) {
        InputMap in = dialog.getRootPane().getInputMap(2);
        in.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap aMap = dialog.getRootPane().getActionMap();
        aMap.put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
    }
}

