/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.lock.internal.MySQLLockingSupport;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class TiDBLockingSupport
implements LockingSupport,
LockingSupport.Metadata {
    public static final TiDBLockingSupport TIDB_LOCKING_SUPPORT = new TiDBLockingSupport();

    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case -2, -1 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.QUERY;
        };
    }

    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.FULL;
    }

    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return MySQLLockingSupport.MYSQL_CONN_LOCK_TIMEOUT_STRATEGY;
    }
}

