/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCUserAttributeMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-user-attribute-mapper";
    public static final String AGGREGATE_ATTRIBUTES_KEY = "aggregateAttributes";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public void setClaim(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
    }

    @Override
    public void setClaim(Map<String, Object> claims, UserSessionModel userSessionModel) {
        List<String> attributePath = this.getMetadataAttributePath();
        String propertyName = attributePath.get(attributePath.size() - 1);
        String userAttribute = (String)this.mapperModel.getConfig().get("userAttribute");
        boolean aggregateAttributes = Optional.ofNullable((String)this.mapperModel.getConfig().get(AGGREGATE_ATTRIBUTES_KEY)).map(Boolean::parseBoolean).orElse(false);
        Collection attributes = KeycloakModelUtils.resolveAttribute((UserModel)userSessionModel.getUser(), (String)userAttribute, (boolean)aggregateAttributes);
        attributes.removeAll(Collections.singleton(null));
        if (!attributes.isEmpty()) {
            claims.put(propertyName, String.join((CharSequence)",", attributes));
        }
    }

    public static ProtocolMapperModel create(String mapperName, String userAttribute, String propertyName, boolean aggregateAttributes) {
        ProtocolMapperModel mapperModel = new ProtocolMapperModel();
        mapperModel.setName(mapperName);
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("claim.name", propertyName);
        configMap.put("userAttribute", userAttribute);
        configMap.put(AGGREGATE_ATTRIBUTES_KEY, Boolean.toString(aggregateAttributes));
        mapperModel.setConfig(configMap);
        mapperModel.setProtocol("oid4vc");
        mapperModel.setProtocolMapper(MAPPER_ID);
        return mapperModel;
    }

    public String getDisplayType() {
        return "User Attribute Mapper";
    }

    public String getHelpText() {
        return "Maps user attributes or properties to credential claims.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCUserAttributeMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty subjectPropertyNameConfig = new ProviderConfigProperty();
        subjectPropertyNameConfig.setName("claim.name");
        subjectPropertyNameConfig.setLabel("tokenClaimName.label");
        subjectPropertyNameConfig.setHelpText("tokenClaimName.tooltip");
        subjectPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(subjectPropertyNameConfig);
        ProviderConfigProperty userAttributeConfig = new ProviderConfigProperty();
        userAttributeConfig.setName("userAttribute");
        userAttributeConfig.setLabel("usermodel.attr.label");
        userAttributeConfig.setHelpText("usermodel.attr.tooltip");
        userAttributeConfig.setType("UserProfileAttributeList");
        CONFIG_PROPERTIES.add(userAttributeConfig);
        ProviderConfigProperty aggregateAttributesConfig = new ProviderConfigProperty();
        aggregateAttributesConfig.setName(AGGREGATE_ATTRIBUTES_KEY);
        aggregateAttributesConfig.setLabel("Aggregate attributes");
        aggregateAttributesConfig.setHelpText("Should the mapper aggregate user attributes.");
        aggregateAttributesConfig.setType("boolean");
        CONFIG_PROPERTIES.add(aggregateAttributesConfig);
    }
}

