/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.aggregation;

import java.io.IOException;
import org.apache.lucene.search.Scorable;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.opensearch.search.profile.aggregation.AggregationTimingType;

public class ProfilingLeafBucketCollector
extends LeafBucketCollector {
    private LeafBucketCollector delegate;
    private Timer collectTimer;

    public ProfilingLeafBucketCollector(LeafBucketCollector delegate, AggregationProfileBreakdown profileBreakdown) {
        this.delegate = delegate;
        this.collectTimer = profileBreakdown.getTimer(AggregationTimingType.COLLECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(int doc, long bucket) throws IOException {
        this.collectTimer.start();
        try {
            this.delegate.collect(doc, bucket);
        }
        finally {
            this.collectTimer.stop();
        }
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }
}

