/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class WildcardUtils {
    private static final String WILDCARD = "*";

    public static boolean matchesWildcardPattern(String pattern, String fieldName) {
        if (pattern == null || fieldName == null) {
            return false;
        }
        if (!WildcardUtils.containsWildcard(pattern)) {
            return pattern.equals(fieldName);
        }
        String[] compiledPattern = pattern.split("\\*", -1);
        return WildcardUtils.matchesCompiledPattern(compiledPattern, fieldName);
    }

    public static List<String> expandWildcardPattern(String pattern, List<String> availableFields) {
        if (pattern == null || availableFields == null) {
            return List.of();
        }
        if (!WildcardUtils.containsWildcard(pattern)) {
            return availableFields.stream().filter(field -> pattern.equals(field)).collect(Collectors.toList());
        }
        String[] compiledPattern = pattern.split("\\*", -1);
        return availableFields.stream().filter(field -> WildcardUtils.matchesCompiledPattern(compiledPattern, field)).collect(Collectors.toList());
    }

    private static boolean matchesCompiledPattern(String[] parts, String fieldName) {
        if (fieldName == null) {
            return false;
        }
        int startIndex = 0;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            if (i == 0) {
                if (!fieldName.startsWith(part)) {
                    return false;
                }
                startIndex = part.length();
                continue;
            }
            int index = fieldName.indexOf(part, startIndex);
            if (index == -1) {
                return false;
            }
            startIndex = index + part.length();
        }
        String lastPart = parts[parts.length - 1];
        return lastPart.isEmpty() || fieldName.endsWith(lastPart);
    }

    public static boolean containsWildcard(String str) {
        return str != null && str.contains(WILDCARD);
    }

    public static String convertWildcardPatternToRegex(String wildcardPattern) {
        String[] parts = WildcardUtils.splitWildcards(wildcardPattern);
        StringBuilder regexBuilder = new StringBuilder("^");
        for (int i = 0; i < parts.length; ++i) {
            regexBuilder.append(Pattern.quote(parts[i]));
            if (i >= parts.length - 1) continue;
            regexBuilder.append("(.*?)");
        }
        regexBuilder.append("$");
        return regexBuilder.toString();
    }

    public static String convertWildcardReplacementToRegex(String wildcardReplacement) {
        if (!wildcardReplacement.contains(WILDCARD)) {
            return wildcardReplacement;
        }
        StringBuilder result = new StringBuilder();
        int captureIndex = 1;
        boolean escaped = false;
        for (char c : wildcardReplacement.toCharArray()) {
            if (escaped) {
                result.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '*') {
                result.append('$').append(captureIndex++);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String[] splitWildcards(String pattern) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        for (char c : pattern.toCharArray()) {
            if (escaped) {
                current.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '*') {
                parts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (escaped) {
            throw new IllegalArgumentException("Invalid escape sequence: pattern ends with unescaped backslash");
        }
        parts.add(current.toString());
        return parts.toArray(new String[0]);
    }

    private static int countWildcards(String str) {
        int count = 0;
        boolean escaped = false;
        for (char c : str.toCharArray()) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != '*') continue;
            ++count;
        }
        return count;
    }

    public static void validateWildcardSymmetry(String pattern, String replacement) {
        int patternWildcards = WildcardUtils.countWildcards(pattern);
        int replacementWildcards = WildcardUtils.countWildcards(replacement);
        if (replacementWildcards != 0 && replacementWildcards != patternWildcards) {
            throw new IllegalArgumentException(String.format("Error in 'replace' command: Wildcard count mismatch - pattern has %d wildcard(s), replacement has %d. Replacement must have same number of wildcards or none.", patternWildcards, replacementWildcards));
        }
    }
}

