---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              diagramme, diagramme commutatif, diagrammes commutatifs, xypic
---

# Comment tracer des diagrammes commutatifs ?

## Avec les commandes de base

Un diagramme commutatif simple peut être obtenu en mélangeant 
un tableau mathématique et différentes flèches. Par exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \begin{array}{ccccc}
    d & \longrightarrow & e & \longrightarrow &f \\
    \uparrow &&&& \uparrow \\
    a & \longrightarrow & b &\longrightarrow& c\\
  \end{array}
\]
\end{document}
```


## Avec l'extension <ctanpkg:xypic>

L'extension <ctanpkg:xypic> est un outil simple et puissant qui permet
de réaliser ces diagrammes.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[all]{xy}

\begin{document}
\[
  \xymatrix{
    A \ar[d] \ar[r] \ar@{=}[rd] & B \ar[d] \\
    C \ar[r] & D }
\]
\end{document}
```


## Avec l'extension <ctanpkg:amscd>

L'extension <ctanpkg:amscd>, qui appartient à l'ensemble des extensions 
[AMS-LaTeX](/1_generalites/glossaire/ams-tex_et_ams-latex), met à disposition
un environnement `CD` dont voici un exemple d'utilisation 
(avec <ctanpkg:mathtools> pour certains commandes) :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools,amscd}

\begin{document}
\[
  \begin{CD}
    \mathcal{F} @>\otimes>> T\\
    @VdrVlfV @ViVjV\\
    \mathtt{f} @= t
  \end{CD}
\]
\[
  \begin{CD}
    d @>>> e @>>> f \\
    @AAA @. @AAA \\
    a @>>> b @>>> c
  \end{CD}
\]
\end{document}
```

La documentation de cette extension indique cependant qu'elle est limitée
dans ses fonctionnalités et recommande <ctanpkg:xypic>.


## Cas de LaTeX 2.09

```{warning}
Ce qui suit n'a qu'un caractère historique et l'usage des extensions indiquées
n'est pas recommandé.
```

En [LaTeX 2.09](/1_generalites/documentation/documents/documents_sur_latex209),
deux extensions au moins traitaient de ce sujet : 
[catmac](https://www.ctan.org/tex-archive/macros/latex209/contrib/misc/) 
et [cd](https://www.ctan.org/tex-archive/macros/latex209/contrib/ams-cd).

Voici un exemple de code avec `catmac`. Notez que cette extension n'est pas
compatible avec l'option `[french]` de <ctanpkg:babel> qui rend le `;` actif.

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{catmac}

\begin{document}
\begin{center}
  \resetparms
  \square[A`B`C`D;f`g`h`k]
\end{center}
\end{document}
```

Et voici un exemple avec `cd` :

```{noedit}
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{cd}

  \newcommand{\cdrl}{\cd\rightleftarrows}
  \newcommand{\cdlr}{\cd\leftrightarrows}
  \newcommand{\cdr}{\cd\to}
  \newcommand{\cdl}{\cd\gets}
  \newcommand{\cdu}{\cd\uparrow}
  \newcommand{\cdd}{\cd\downarrow}
  \newcommand{\cdud}{\cd\updownarrows}
  \newcommand{\cddu}{\cd\downuparrows}

\begin{document}
\[
  \CD G \cdrl {\gamma}{\delta} H \cdr {}{\Delta} K \\
  \cd. \cdud {f}{g} \cd| {h}{k} \\
  0 \cdr {}{} G' \cd= {\beta}{} H' \endCD
\]
\end{document}
```


:::{seealso}
Une [page](https://ctan.org/pkg/diagrams) 
du [CTAN](/1_generalites/documentation/le_catalogue_du_ctan) est dédiée 
au sujet des diagrammes commutatifs. Elle renvoit en particulier vers un
[article du TUGboat](https://tug.org/TUGboat/Articles/tb15-4/tb45vali.pdf)
datant de 1994 comparant les différentes extensions traitant alors de ce sujet.
:::