﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/opensearch/OpenSearchService_EXPORTS.h>

namespace Aws {
namespace OpenSearchService {
namespace Model {
enum class AWSServicePrincipal { NOT_SET, application_opensearchservice_amazonaws_com };

namespace AWSServicePrincipalMapper {
AWS_OPENSEARCHSERVICE_API AWSServicePrincipal GetAWSServicePrincipalForName(const Aws::String& name);

AWS_OPENSEARCHSERVICE_API Aws::String GetNameForAWSServicePrincipal(AWSServicePrincipal value);
}  // namespace AWSServicePrincipalMapper
}  // namespace Model
}  // namespace OpenSearchService
}  // namespace Aws
