/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Properties;
import javax.security.auth.Subject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.access.DBAAuthSubjectCredentials;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;

class JDBCConnectionOpener
implements DBRRunnableWithProgress,
PrivilegedExceptionAction<Connection> {
    private final JDBCDataSource dataSource;
    private final DBPDriver driver;
    private final Driver driverInstance;
    private final String url;
    private final Properties connectProps;
    private final Object authResult;
    private Connection connection;
    private Throwable error;

    public JDBCConnectionOpener(@NotNull JDBCDataSource dataSource, @NotNull DBPDriver driver, @Nullable Driver driverInstance, @NotNull String url, @NotNull Properties connectProps, @Nullable Object authResult) {
        this.dataSource = dataSource;
        this.driver = driver;
        this.driverInstance = driverInstance;
        this.url = url;
        this.connectProps = connectProps;
        this.authResult = authResult;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Throwable getError() {
        return this.error;
    }

    public void run(DBRProgressMonitor monitor1) throws InvocationTargetException, InterruptedException {
        try {
            DBAAuthSubjectCredentials sc;
            Subject authSubject;
            Connection jdbcConnection = null;
            boolean connected = false;
            Object object = this.authResult;
            if (object instanceof DBAAuthSubjectCredentials && (authSubject = (sc = (DBAAuthSubjectCredentials)object).getAuthSubject()) != null) {
                jdbcConnection = Subject.doAs(authSubject, this);
                connected = true;
            }
            if (!connected) {
                jdbcConnection = this.run();
            }
            this.connection = jdbcConnection;
        }
        catch (Throwable e) {
            this.error = e;
        }
    }

    @Override
    public Connection run() throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.driver.getDriverLoader(this.dataSource.getContainer()).getClassLoader());
        try {
            try {
                Field driversInitializedField = DriverManager.class.getDeclaredField("driversInitialized");
                driversInitializedField.setAccessible(true);
                driversInitializedField.set(null, false);
            }
            catch (Throwable throwable) {}
            if (this.driverInstance == null) {
                Connection connection = DriverManager.getConnection(this.url, this.connectProps);
                return connection;
            }
            Connection connection = this.driverInstance.connect(this.url, this.connectProps);
            return connection;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

