/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;

public class AttributesToMapConverter {
    private AttributesToMapConverter() {
    }

    public static Map<String, String> convertToMap(AttributeContainer attributes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Attribute attribute : attributes.keySet()) {
            String strValue = AttributesToMapConverter.getAttributeValueAsString(attributes, attribute);
            builder.put((Object)attribute.getName(), (Object)strValue);
        }
        return builder.build();
    }

    private static String getAttributeValueAsString(AttributeContainer attributeContainer, Attribute<?> attribute) {
        Object attributeValue = attributeContainer.getAttribute(attribute);
        if (attributeValue == null) {
            throw new IllegalStateException("No attribute value for " + attribute);
        }
        if (attributeValue instanceof Named) {
            return ((Named)attributeValue).getName();
        }
        if (attributeValue instanceof Object[]) {
            return Arrays.toString((Object[])attributeValue);
        }
        return attributeValue.toString();
    }
}

