/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.micrometer.runtime.HttpServerMetricsTagsContributor;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.vertx.HttpRequestMetric;
import io.quarkus.micrometer.runtime.binder.vertx.VertxMetricsTags;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpServerMetrics;
import io.quarkus.micrometer.runtime.export.exemplars.OpenTelemetryContextUnwrapper;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.jboss.logging.Logger;

public class VertxHttpServerMetrics
extends VertxTcpServerMetrics
implements HttpServerMetrics<HttpRequestMetric, LongTaskTimer.Sample, LongTaskTimer.Sample> {
    static final Logger log = Logger.getLogger(VertxHttpServerMetrics.class);
    HttpBinderConfiguration config;
    OpenTelemetryContextUnwrapper openTelemetryContextUnwrapper;
    final LongAdder activeRequests;
    final Meter.MeterProvider<Timer> requestsTimer;
    final Meter.MeterProvider<LongTaskTimer> websocketConnectionTimer;
    final Meter.MeterProvider<Counter> pushCounter;
    private final List<HttpServerMetricsTagsContributor> httpServerMetricsTagsContributors;

    VertxHttpServerMetrics(MeterRegistry registry, HttpBinderConfiguration config, OpenTelemetryContextUnwrapper openTelemetryContextUnwrapper, HttpServerOptions httpServerOptions) {
        super(registry, "http.server", VertxHttpServerMetrics.commonTags(httpServerOptions));
        this.config = config;
        this.openTelemetryContextUnwrapper = openTelemetryContextUnwrapper;
        this.activeRequests = new LongAdder();
        Tags commonTags = VertxHttpServerMetrics.commonTags(httpServerOptions);
        Gauge.Builder activeRequestsBuilder = Gauge.builder((String)config.getHttpServerActiveRequestsName(), (Object)this.activeRequests, LongAdder::doubleValue).tag("url.scheme", httpServerOptions.isSsl() ? "https" : "http");
        for (Tag commonTag : commonTags) {
            activeRequestsBuilder.tag(commonTag.getKey(), commonTag.getValue());
        }
        activeRequestsBuilder.register(registry);
        this.httpServerMetricsTagsContributors = this.resolveHttpServerMetricsTagsContributors();
        this.requestsTimer = Timer.builder((String)config.getHttpServerRequestsName()).description("HTTP server request processing time").withRegistry(registry);
        this.websocketConnectionTimer = LongTaskTimer.builder((String)config.getHttpServerWebSocketConnectionsName()).description("Server web socket connection time").withRegistry(registry);
        this.pushCounter = Counter.builder((String)config.getHttpServerPushName()).description("HTTP server response push counter").withRegistry(registry);
    }

    private static Tags commonTags(HttpServerOptions httpServerOptions) {
        Tags result = Tags.empty();
        if (httpServerOptions.getPort() > 0) {
            result = result.and("server.port", "" + httpServerOptions.getPort());
        }
        return result;
    }

    private List<HttpServerMetricsTagsContributor> resolveHttpServerMetricsTagsContributors() {
        List<HttpServerMetricsTagsContributor> httpServerMetricsTagsContributors;
        ArcContainer arcContainer = Arc.container();
        if (arcContainer == null) {
            httpServerMetricsTagsContributors = Collections.emptyList();
        } else {
            List handles = arcContainer.listAll(HttpServerMetricsTagsContributor.class, new Annotation[0]);
            if (handles.isEmpty()) {
                httpServerMetricsTagsContributors = Collections.emptyList();
            } else {
                httpServerMetricsTagsContributors = new ArrayList<HttpServerMetricsTagsContributor>(handles.size());
                for (InstanceHandle handle : handles) {
                    httpServerMetricsTagsContributors.add((HttpServerMetricsTagsContributor)handle.get());
                }
            }
        }
        return httpServerMetricsTagsContributors;
    }

    public HttpRequestMetric responsePushed(LongTaskTimer.Sample socketMetric, HttpMethod method, String uri, HttpResponse response) {
        HttpRequestMetric requestMetric = new HttpRequestMetric(uri, this.activeRequests);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            ((Counter)this.pushCounter.withTags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.uri(path, requestMetric.getInitialPath(), response.statusCode(), this.config.isServerSuppress4xxErrors()), VertxMetricsTags.method(method), VertxMetricsTags.outcome(response), HttpCommonTags.status(response.statusCode())}))).increment();
        }
        log.debugf("responsePushed %s, %s", (Object)socketMetric, (Object)requestMetric);
        return requestMetric;
    }

    public void requestRouted(HttpRequestMetric requestMetric, String route) {
        log.debugf("requestRouted %s %s", (Object)route, (Object)requestMetric);
        requestMetric.appendCurrentRoutePath(route);
        if (route != null) {
            requestMetric.request().context().putLocal((Object)"VertxRoute", (Object)route);
        }
    }

    public HttpRequestMetric requestBegin(LongTaskTimer.Sample sample, HttpRequest request) {
        HttpRequestMetric requestMetric = new HttpRequestMetric(request, this.activeRequests);
        requestMetric.setSample(Timer.start((MeterRegistry)this.registry));
        requestMetric.requestStarted();
        return requestMetric;
    }

    public void requestReset(HttpRequestMetric requestMetric) {
        log.debugf("requestReset %s", (Object)requestMetric);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            Timer.Sample sample = requestMetric.getSample();
            this.openTelemetryContextUnwrapper.executeInContext(arg_0 -> ((Timer.Sample)sample).stop(arg_0), (Timer)this.requestsTimer.withTags((Iterable)Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(requestMetric.request().method()), HttpCommonTags.uri(path, requestMetric.getInitialPath(), 0, false), Outcome.CLIENT_ERROR.asTag(), HttpCommonTags.STATUS_RESET})), requestMetric.request().context());
        }
        requestMetric.requestEnded();
    }

    public void responseEnd(HttpRequestMetric requestMetric, HttpResponse response, long bytesWritten) {
        log.debugf("responseEnd %s, %s", (Object)response, (Object)requestMetric);
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            Timer.Sample sample = requestMetric.getSample();
            Tags allTags = Tags.of((Tag[])new Tag[]{VertxMetricsTags.method(requestMetric.request().method()), HttpCommonTags.uri(path, requestMetric.getInitialPath(), response.statusCode(), this.config.isServerSuppress4xxErrors()), VertxMetricsTags.outcome(response), HttpCommonTags.status(response.statusCode())});
            if (!this.httpServerMetricsTagsContributors.isEmpty()) {
                DefaultContext context = new DefaultContext((HttpServerRequest)requestMetric.request(), response);
                for (int i = 0; i < this.httpServerMetricsTagsContributors.size(); ++i) {
                    try {
                        Tags additionalTags = this.httpServerMetricsTagsContributors.get(i).contribute(context);
                        allTags = allTags.and((Iterable)additionalTags);
                        continue;
                    }
                    catch (Exception e) {
                        log.debug((Object)"Unable to obtain additional tags", (Throwable)e);
                    }
                }
            }
            this.openTelemetryContextUnwrapper.executeInContext(arg_0 -> ((Timer.Sample)sample).stop(arg_0), (Timer)this.requestsTimer.withTags((Iterable)allTags), requestMetric.request().context());
        }
        requestMetric.requestEnded();
    }

    public LongTaskTimer.Sample connected(LongTaskTimer.Sample sample, HttpRequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        String path = requestMetric.getNormalizedUriPath(this.config.getServerMatchPatterns(), this.config.getServerIgnorePatterns());
        if (path != null) {
            return ((LongTaskTimer)this.websocketConnectionTimer.withTags((Iterable)Tags.of((Tag[])new Tag[]{HttpCommonTags.uri(path, requestMetric.getInitialPath(), 0, false)}))).start();
        }
        return null;
    }

    public void disconnected(LongTaskTimer.Sample websocketMetric) {
        log.debugf("websocket disconnected %s", (Object)websocketMetric);
        if (websocketMetric != null) {
            websocketMetric.stop();
        }
    }

    private record DefaultContext(HttpServerRequest request, HttpResponse response) implements HttpServerMetricsTagsContributor.Context
    {
        @Override
        public <T> T requestContextLocalData(Object key) {
            return (T)((HttpServerRequestInternal)this.request).context().getLocal(key);
        }
    }
}

