/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.rollup.model.metric.Average;
import org.opensearch.indexmanagement.rollup.model.metric.Cardinality;
import org.opensearch.indexmanagement.rollup.model.metric.Max;
import org.opensearch.indexmanagement.rollup.model.metric.Metric;
import org.opensearch.indexmanagement.rollup.model.metric.Min;
import org.opensearch.indexmanagement.rollup.model.metric.Sum;
import org.opensearch.indexmanagement.rollup.model.metric.ValueCount;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\bJ\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sourceField", "", "targetField", "metrics", "", "Lorg/opensearch/indexmanagement/rollup/model/metric/Metric;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getSourceField", "()Ljava/lang/String;", "getTargetField", "getMetrics", "()Ljava/util/List;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "targetFieldWithType", "metric", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMetrics.kt\norg/opensearch/indexmanagement/rollup/model/RollupMetrics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,140:1\n1669#2,8:141\n1#3:149\n37#4:150\n36#4,3:151\n*S KotlinDebug\n*F\n+ 1 RollupMetrics.kt\norg/opensearch/indexmanagement/rollup/model/RollupMetrics\n*L\n33#1:141,8\n67#1:150\n67#1:151,3\n*E\n"})
public final class RollupMetrics
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sourceField;
    @NotNull
    private final String targetField;
    @NotNull
    private final List<Metric> metrics;
    @NotNull
    public static final String SOURCE_FIELD_FIELD = "source_field";
    @NotNull
    public static final String TARGET_FIELD_FIELD = "target_field";
    @NotNull
    public static final String METRICS_FIELD = "metrics";

    /*
     * WARNING - void declaration
     */
    public RollupMetrics(@NotNull String sourceField, @NotNull String targetField, @NotNull List<? extends Metric> metrics) {
        void $this$distinctBy$iv;
        Intrinsics.checkNotNullParameter((Object)sourceField, (String)"sourceField");
        Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
        Intrinsics.checkNotNullParameter(metrics, (String)METRICS_FIELD);
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.metrics = metrics;
        Iterable iterable = this.metrics;
        int n = this.metrics.size();
        boolean $i$f$distinctBy = false;
        HashSet<Metric.Type> set$iv = new HashSet<Metric.Type>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Metric it = (Metric)e$iv;
            boolean bl = false;
            Metric.Type key$iv = it.getType();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List list = list$iv;
        if (!(n == list.size())) {
            boolean $i$a$-require-RollupMetrics$52 = false;
            String $i$a$-require-RollupMetrics$52 = "Cannot have multiple metrics of the same type in a single rollup metric [" + this.metrics + "]";
            throw new IllegalArgumentException($i$a$-require-RollupMetrics$52.toString());
        }
        if (!(((CharSequence)this.sourceField).length() > 0 && ((CharSequence)this.targetField).length() > 0)) {
            boolean $i$a$-require-RollupMetrics$62 = false;
            String $i$a$-require-RollupMetrics$62 = "Source and target field must not be empty";
            throw new IllegalArgumentException($i$a$-require-RollupMetrics$62.toString());
        }
        if (!(!((Collection)this.metrics).isEmpty())) {
            boolean bl = false;
            String string = "Must specify at least one metric to aggregate on for " + this.sourceField;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getSourceField() {
        return this.sourceField;
    }

    @NotNull
    public final String getTargetField() {
        return this.targetField;
    }

    @NotNull
    public final List<Metric> getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - void declaration
     */
    public RollupMetrics(@NotNull StreamInput sin) throws IOException {
        void it;
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        StreamInput streamInput = sin;
        String string3 = string2;
        String string4 = string;
        RollupMetrics rollupMetrics = this;
        boolean bl = false;
        List metricsList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            boolean bl2 = false;
            Metric.Type type = (Metric.Type)it.readEnum(Metric.Type.class);
            List list = metricsList;
            Metric.Type type2 = type;
            if (type2 == null) {
                List list2 = list;
                boolean bl3 = false;
                List list3 = list2;
                String string5 = "Metric type cannot be null";
                throw new IllegalArgumentException(string5.toString());
            }
            list.add(switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1 -> new Average((StreamInput)it);
                case 2 -> new Max((StreamInput)it);
                case 3 -> new Min((StreamInput)it);
                case 4 -> new Sum((StreamInput)it);
                case 5 -> new ValueCount((StreamInput)it);
                case 6 -> new Cardinality((StreamInput)it);
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        List list = CollectionsKt.toList((Iterable)metricsList);
        rollupMetrics(string4, string3, list);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Collection $this$toTypedArray$iv = this.metrics;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder = builder.startObject().field(SOURCE_FIELD_FIELD, this.sourceField).field(METRICS_FIELD, (Object)thisCollection$iv.toArray(new Metric[0])).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.sourceField);
        out.writeString(this.targetField);
        out.writeVInt(this.metrics.size());
        for (Metric metric : this.metrics) {
            out.writeEnum((Enum)metric.getType());
            Metric metric2 = metric;
            if (metric2 instanceof Average) {
                ((Average)metric).writeTo(out);
                continue;
            }
            if (metric2 instanceof Max) {
                ((Max)metric).writeTo(out);
                continue;
            }
            if (metric2 instanceof Min) {
                ((Min)metric).writeTo(out);
                continue;
            }
            if (metric2 instanceof Sum) {
                ((Sum)metric).writeTo(out);
                continue;
            }
            if (metric2 instanceof ValueCount) {
                ((ValueCount)metric).writeTo(out);
                continue;
            }
            if (!(metric2 instanceof Cardinality)) continue;
            ((Cardinality)metric).writeTo(out);
        }
    }

    @NotNull
    public final String targetFieldWithType(@NotNull Metric metric) {
        String string;
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Metric metric2 = metric;
        if (metric2 instanceof Average) {
            string = this.targetField + ".avg";
        } else if (metric2 instanceof Sum) {
            string = this.targetField + ".sum";
        } else if (metric2 instanceof Max) {
            string = this.targetField + ".max";
        } else if (metric2 instanceof Min) {
            string = this.targetField + ".min";
        } else if (metric2 instanceof ValueCount) {
            string = this.targetField + ".value_count";
        } else if (metric2 instanceof Cardinality) {
            string = this.targetField + ".hll";
        } else {
            throw new IllegalArgumentException("Found unsupported metric aggregation " + metric.getType().getType());
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.sourceField;
    }

    @NotNull
    public final String component2() {
        return this.targetField;
    }

    @NotNull
    public final List<Metric> component3() {
        return this.metrics;
    }

    @NotNull
    public final RollupMetrics copy(@NotNull String sourceField, @NotNull String targetField, @NotNull List<? extends Metric> metrics) {
        Intrinsics.checkNotNullParameter((Object)sourceField, (String)"sourceField");
        Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
        Intrinsics.checkNotNullParameter(metrics, (String)METRICS_FIELD);
        return new RollupMetrics(sourceField, targetField, metrics);
    }

    public static /* synthetic */ RollupMetrics copy$default(RollupMetrics rollupMetrics, String string, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = rollupMetrics.sourceField;
        }
        if ((n & 2) != 0) {
            string2 = rollupMetrics.targetField;
        }
        if ((n & 4) != 0) {
            list = rollupMetrics.metrics;
        }
        return rollupMetrics.copy(string, string2, list);
    }

    @NotNull
    public String toString() {
        return "RollupMetrics(sourceField=" + this.sourceField + ", targetField=" + this.targetField + ", metrics=" + this.metrics + ")";
    }

    public int hashCode() {
        int result2 = this.sourceField.hashCode();
        result2 = result2 * 31 + this.targetField.hashCode();
        result2 = result2 * 31 + ((Object)this.metrics).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RollupMetrics)) {
            return false;
        }
        RollupMetrics rollupMetrics = (RollupMetrics)other;
        if (!Intrinsics.areEqual((Object)this.sourceField, (Object)rollupMetrics.sourceField)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetField, (Object)rollupMetrics.targetField)) {
            return false;
        }
        return Intrinsics.areEqual(this.metrics, rollupMetrics.metrics);
    }

    @JvmStatic
    @NotNull
    public static final RollupMetrics parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics$Companion;", "", "<init>", "()V", "SOURCE_FIELD_FIELD", "", "TARGET_FIELD_FIELD", "METRICS_FIELD", "parse", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nRollupMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMetrics.kt\norg/opensearch/indexmanagement/rollup/model/RollupMetrics$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RollupMetrics parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String sourceField = null;
            String targetField = null;
            List metrics = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block18: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block18;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1658170326: {
                            if (string.equals(RollupMetrics.SOURCE_FIELD_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -210221876: {
                            if (string.equals(RollupMetrics.TARGET_FIELD_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case 955826371: {
                            if (string.equals(RollupMetrics.METRICS_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            sourceField = xcp.text();
                            continue block10;
                        }
                        case 2: {
                            targetField = xcp.text();
                            continue block10;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                metrics.add(Metric.Companion.parse(xcp));
                            }
                            continue block10;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid dimension type [" + fieldName + "] found in rollup metrics");
            }
            if (targetField == null) {
                targetField = sourceField;
            }
            String string = sourceField;
            if (string == null) {
                boolean $i$a$-requireNotNull-RollupMetrics$Companion$parse$32 = false;
                String $i$a$-requireNotNull-RollupMetrics$Companion$parse$32 = "Source field must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-RollupMetrics$Companion$parse$32.toString());
            }
            String string2 = targetField;
            if (string2 == null) {
                String string3 = string;
                boolean bl = false;
                String string4 = string3;
                String string5 = "Target field must not be null";
                throw new IllegalArgumentException(string5.toString());
            }
            List list = CollectionsKt.toList((Iterable)metrics);
            String string6 = string2;
            String string7 = string;
            return new RollupMetrics(string7, string6, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Metric.Type.values().length];
            try {
                nArray[Metric.Type.AVERAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Metric.Type.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Metric.Type.MIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Metric.Type.SUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Metric.Type.VALUE_COUNT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Metric.Type.CARDINALITY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

