/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;

class HybridQueryScoreDocsMerger<T extends ScoreDoc> {
    private static final int MIN_NUMBER_OF_ELEMENTS_IN_SCORE_DOC = 3;

    public MergeResult<T> mergeScoreDocsAndCollapseValues(T[] sourceScoreDocs, T[] newScoreDocs, Comparator<T> comparator, Object[] sourceCollapseValues, Object[] newCollapseValues, boolean isSortEnabled, boolean isCollapseEnabled) {
        if (((ScoreDoc[])Objects.requireNonNull(sourceScoreDocs, "score docs cannot be null")).length == 0) {
            return new MergeResult(newScoreDocs, newCollapseValues);
        }
        if (((ScoreDoc[])Objects.requireNonNull(newScoreDocs, "score docs cannot be null")).length == 0) {
            return new MergeResult(sourceScoreDocs, sourceCollapseValues);
        }
        if (sourceScoreDocs.length < 3 || newScoreDocs.length < 3) {
            throw new IllegalArgumentException("cannot merge top docs because it does not have enough elements");
        }
        if (isCollapseEnabled) {
            if (sourceScoreDocs.length != Objects.requireNonNull(sourceCollapseValues, "collapse values cannot be null").length) {
                throw new IllegalArgumentException("cannot merge collapse values of search results of source segment because the number of elements does not match score docs count");
            }
            if (newScoreDocs.length != Objects.requireNonNull(newCollapseValues, "collapse values cannot be null").length) {
                throw new IllegalArgumentException("cannot merge collapse values of search results from another segment because the number of elements does not match score docs count");
            }
        }
        ArrayList<T> mergedScoreDocs = new ArrayList<T>(sourceScoreDocs.length + newScoreDocs.length);
        ArrayList<Object> mergedCollapseValues = null;
        if (isCollapseEnabled) {
            mergedCollapseValues = new ArrayList<Object>(sourceCollapseValues.length + newCollapseValues.length);
        }
        int sourcePointer = 0;
        mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
        if (isCollapseEnabled) {
            mergedCollapseValues.add(sourceCollapseValues[sourcePointer]);
        }
        ++sourcePointer;
        int newPointer = 1;
        while (sourcePointer < sourceScoreDocs.length - 1 && newPointer < newScoreDocs.length - 1) {
            mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
            if (isCollapseEnabled) {
                mergedCollapseValues.add(sourceCollapseValues[sourcePointer]);
            }
            ++sourcePointer;
            ++newPointer;
            while (sourcePointer < sourceScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(sourceScoreDocs[sourcePointer]) && newPointer < newScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(newScoreDocs[newPointer])) {
                if (this.compareCondition((ScoreDoc)sourceScoreDocs[sourcePointer], (ScoreDoc)newScoreDocs[newPointer], comparator, isSortEnabled)) {
                    mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
                    if (isCollapseEnabled) {
                        mergedCollapseValues.add(sourceCollapseValues[sourcePointer]);
                    }
                    ++sourcePointer;
                    continue;
                }
                mergedScoreDocs.add(newScoreDocs[newPointer]);
                if (isCollapseEnabled) {
                    mergedCollapseValues.add(newCollapseValues[newPointer]);
                }
                ++newPointer;
            }
            while (sourcePointer < sourceScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(sourceScoreDocs[sourcePointer])) {
                mergedScoreDocs.add(sourceScoreDocs[sourcePointer]);
                if (isCollapseEnabled) {
                    mergedCollapseValues.add(sourceCollapseValues[sourcePointer]);
                }
                ++sourcePointer;
            }
            while (newPointer < newScoreDocs.length && HybridSearchResultFormatUtil.isHybridQueryScoreDocElement(newScoreDocs[newPointer])) {
                mergedScoreDocs.add(newScoreDocs[newPointer]);
                if (isCollapseEnabled) {
                    mergedCollapseValues.add(newCollapseValues[newPointer]);
                }
                ++newPointer;
            }
        }
        mergedScoreDocs.add(sourceScoreDocs[sourceScoreDocs.length - 1]);
        if (isCollapseEnabled) {
            mergedCollapseValues.add(sourceCollapseValues[sourceScoreDocs.length - 1]);
        }
        if (isCollapseEnabled) {
            return new MergeResult(mergedScoreDocs.toArray((ScoreDoc[])new FieldDoc[0]), mergedCollapseValues.toArray(new Object[0]));
        }
        if (isSortEnabled) {
            return new MergeResult(mergedScoreDocs.toArray((ScoreDoc[])new FieldDoc[0]), null);
        }
        return new MergeResult(mergedScoreDocs.toArray(new ScoreDoc[0]), null);
    }

    private boolean compareCondition(ScoreDoc oldScoreDoc, ScoreDoc secondScoreDoc, Comparator<T> comparator, boolean isSortEnabled) {
        if (isSortEnabled) {
            return comparator.compare(oldScoreDoc, secondScoreDoc) < 0;
        }
        return comparator.compare(oldScoreDoc, secondScoreDoc) >= 0;
    }

    @Generated
    HybridQueryScoreDocsMerger() {
    }

    public record MergeResult<T extends ScoreDoc>(T[] scoreDocs, Object[] collapseValues) {
    }
}

