/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.catalina.users.MemoryUserDatabase;

public class MemoryUserDatabaseFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (!(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        if (!"org.apache.catalina.UserDatabase".equals(reference.getClassName())) {
            return null;
        }
        MemoryUserDatabase memoryUserDatabase = new MemoryUserDatabase(name.toString());
        RefAddr refAddr = reference.get("pathname");
        if (refAddr != null) {
            memoryUserDatabase.setPathname(refAddr.getContent().toString());
        }
        if ((refAddr = reference.get("readonly")) != null) {
            memoryUserDatabase.setReadonly(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("watchSource")) != null) {
            memoryUserDatabase.setWatchSource(Boolean.parseBoolean(refAddr.getContent().toString()));
        }
        memoryUserDatabase.open();
        if (!memoryUserDatabase.getReadonly()) {
            memoryUserDatabase.save();
        }
        return memoryUserDatabase;
    }
}

