/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;
import org.apache.catalina.ant.AbstractCatalinaCommandTask;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends AbstractCatalinaCommandTask {
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("\\w{3,5}\\:");
    protected String config = null;
    protected String localWar = null;
    protected String tag = null;
    protected boolean update = false;
    protected String war = null;

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String string) {
        this.config = string;
    }

    public String getLocalWar() {
        return this.localWar;
    }

    public void setLocalWar(String string) {
        this.localWar = string;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public String getWar() {
        return this.war;
    }

    public void setWar(String string) {
        this.war = string;
    }

    @Override
    public void execute() throws BuildException {
        Object object;
        super.execute();
        if (this.path == null) {
            throw new BuildException("Must specify 'path' attribute");
        }
        if (this.war == null && this.localWar == null && this.config == null && this.tag == null) {
            throw new BuildException("Must specify either 'war', 'localWar', 'config', or 'tag' attribute");
        }
        BufferedInputStream bufferedInputStream = null;
        String string = null;
        long l = -1L;
        if (this.war != null) {
            if (PROTOCOL_PATTERN.matcher(this.war).lookingAt()) {
                try {
                    object = new URI(this.war);
                    URLConnection uRLConnection = ((URI)object).toURL().openConnection();
                    l = uRLConnection.getContentLengthLong();
                    bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream(), 1024);
                }
                catch (IOException | URISyntaxException exception) {
                    throw new BuildException((Throwable)exception);
                }
            }
            object = null;
            try {
                object = new FileInputStream(this.war);
                FileChannel fileChannel = ((FileInputStream)object).getChannel();
                l = fileChannel.size();
                bufferedInputStream = new BufferedInputStream((InputStream)object, 1024);
            }
            catch (IOException iOException) {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                throw new BuildException((Throwable)iOException);
            }
            string = "application/octet-stream";
        }
        object = this.createQueryString("/deploy");
        try {
            if (this.war == null && this.config != null) {
                ((StringBuilder)object).append("&config=");
                ((StringBuilder)object).append(URLEncoder.encode(this.config, this.getCharset()));
            }
            if (this.war == null && this.localWar != null) {
                ((StringBuilder)object).append("&war=");
                ((StringBuilder)object).append(URLEncoder.encode(this.localWar, this.getCharset()));
            }
            if (this.update) {
                ((StringBuilder)object).append("&update=true");
            }
            if (this.tag != null) {
                ((StringBuilder)object).append("&tag=");
                ((StringBuilder)object).append(URLEncoder.encode(this.tag, this.getCharset()));
            }
            this.execute(((StringBuilder)object).toString(), bufferedInputStream, string, l);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

