//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blueprint/armblueprint"
	"net/http"
	"net/url"
	"regexp"
)

// AssignmentsServer is a fake server for instances of the armblueprint.AssignmentsClient type.
type AssignmentsServer struct {
	// CreateOrUpdate is the fake for method AssignmentsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceScope string, assignmentName string, assignment armblueprint.Assignment, options *armblueprint.AssignmentsClientCreateOrUpdateOptions) (resp azfake.Responder[armblueprint.AssignmentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method AssignmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	Delete func(ctx context.Context, resourceScope string, assignmentName string, options *armblueprint.AssignmentsClientDeleteOptions) (resp azfake.Responder[armblueprint.AssignmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AssignmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceScope string, assignmentName string, options *armblueprint.AssignmentsClientGetOptions) (resp azfake.Responder[armblueprint.AssignmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AssignmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceScope string, options *armblueprint.AssignmentsClientListOptions) (resp azfake.PagerResponder[armblueprint.AssignmentsClientListResponse])

	// WhoIsBlueprint is the fake for method AssignmentsClient.WhoIsBlueprint
	// HTTP status codes to indicate success: http.StatusOK
	WhoIsBlueprint func(ctx context.Context, resourceScope string, assignmentName string, options *armblueprint.AssignmentsClientWhoIsBlueprintOptions) (resp azfake.Responder[armblueprint.AssignmentsClientWhoIsBlueprintResponse], errResp azfake.ErrorResponder)
}

// NewAssignmentsServerTransport creates a new instance of AssignmentsServerTransport with the provided implementation.
// The returned AssignmentsServerTransport instance is connected to an instance of armblueprint.AssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssignmentsServerTransport(srv *AssignmentsServer) *AssignmentsServerTransport {
	return &AssignmentsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armblueprint.AssignmentsClientListResponse]](),
	}
}

// AssignmentsServerTransport connects instances of armblueprint.AssignmentsClient to instances of AssignmentsServer.
// Don't use this type directly, use NewAssignmentsServerTransport instead.
type AssignmentsServerTransport struct {
	srv          *AssignmentsServer
	newListPager *tracker[azfake.PagerResponder[armblueprint.AssignmentsClientListResponse]]
}

// Do implements the policy.Transporter interface for AssignmentsServerTransport.
func (a *AssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssignmentsClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "AssignmentsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "AssignmentsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AssignmentsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AssignmentsClient.WhoIsBlueprint":
		resp, err = a.dispatchWhoIsBlueprint(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprintAssignments/(?P<assignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armblueprint.Assignment](req)
	if err != nil {
		return nil, err
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	assignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), resourceScopeParam, assignmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprintAssignments/(?P<assignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	assignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assignmentName")])
	if err != nil {
		return nil, err
	}
	deleteBehaviorUnescaped, err := url.QueryUnescape(qp.Get("deleteBehavior"))
	if err != nil {
		return nil, err
	}
	deleteBehaviorParam := getOptional(armblueprint.AssignmentDeleteBehavior(deleteBehaviorUnescaped))
	var options *armblueprint.AssignmentsClientDeleteOptions
	if deleteBehaviorParam != nil {
		options = &armblueprint.AssignmentsClientDeleteOptions{
			DeleteBehavior: deleteBehaviorParam,
		}
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceScopeParam, assignmentNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprintAssignments/(?P<assignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	assignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceScopeParam, assignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprintAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceScopeParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblueprint.AssignmentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchWhoIsBlueprint(req *http.Request) (*http.Response, error) {
	if a.srv.WhoIsBlueprint == nil {
		return nil, &nonRetriableError{errors.New("fake for method WhoIsBlueprint not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprintAssignments/(?P<assignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/whoIsBlueprint`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	assignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.WhoIsBlueprint(req.Context(), resourceScopeParam, assignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WhoIsBlueprintContract, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
