//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkeyvault_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/keyvault/armkeyvault"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/createVault.json
func ExampleVaultsClient_BeginCreateOrUpdate_createANewVaultOrUpdateAnExistingVault() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVaultsClient().BeginCreateOrUpdate(ctx, "sample-resource-group", "sample-vault", armkeyvault.VaultCreateOrUpdateParameters{
		Location: to.Ptr("westus"),
		Properties: &armkeyvault.VaultProperties{
			AccessPolicies: []*armkeyvault.AccessPolicyEntry{
				{
					ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
					Permissions: &armkeyvault.Permissions{
						Certificates: []*armkeyvault.CertificatePermissions{
							to.Ptr(armkeyvault.CertificatePermissionsGet),
							to.Ptr(armkeyvault.CertificatePermissionsList),
							to.Ptr(armkeyvault.CertificatePermissionsDelete),
							to.Ptr(armkeyvault.CertificatePermissionsCreate),
							to.Ptr(armkeyvault.CertificatePermissionsImport),
							to.Ptr(armkeyvault.CertificatePermissionsUpdate),
							to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
							to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
							to.Ptr(armkeyvault.CertificatePermissionsListissuers),
							to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
							to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
							to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
							to.Ptr(armkeyvault.CertificatePermissionsRecover),
							to.Ptr(armkeyvault.CertificatePermissionsPurge)},
						Keys: []*armkeyvault.KeyPermissions{
							to.Ptr(armkeyvault.KeyPermissionsEncrypt),
							to.Ptr(armkeyvault.KeyPermissionsDecrypt),
							to.Ptr(armkeyvault.KeyPermissionsWrapKey),
							to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
							to.Ptr(armkeyvault.KeyPermissionsSign),
							to.Ptr(armkeyvault.KeyPermissionsVerify),
							to.Ptr(armkeyvault.KeyPermissionsGet),
							to.Ptr(armkeyvault.KeyPermissionsList),
							to.Ptr(armkeyvault.KeyPermissionsCreate),
							to.Ptr(armkeyvault.KeyPermissionsUpdate),
							to.Ptr(armkeyvault.KeyPermissionsImport),
							to.Ptr(armkeyvault.KeyPermissionsDelete),
							to.Ptr(armkeyvault.KeyPermissionsBackup),
							to.Ptr(armkeyvault.KeyPermissionsRestore),
							to.Ptr(armkeyvault.KeyPermissionsRecover),
							to.Ptr(armkeyvault.KeyPermissionsPurge)},
						Secrets: []*armkeyvault.SecretPermissions{
							to.Ptr(armkeyvault.SecretPermissionsGet),
							to.Ptr(armkeyvault.SecretPermissionsList),
							to.Ptr(armkeyvault.SecretPermissionsSet),
							to.Ptr(armkeyvault.SecretPermissionsDelete),
							to.Ptr(armkeyvault.SecretPermissionsBackup),
							to.Ptr(armkeyvault.SecretPermissionsRestore),
							to.Ptr(armkeyvault.SecretPermissionsRecover),
							to.Ptr(armkeyvault.SecretPermissionsPurge)},
					},
					TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
				}},
			EnabledForDeployment:         to.Ptr(true),
			EnabledForDiskEncryption:     to.Ptr(true),
			EnabledForTemplateDeployment: to.Ptr(true),
			PublicNetworkAccess:          to.Ptr("Enabled"),
			SKU: &armkeyvault.SKU{
				Name:   to.Ptr(armkeyvault.SKUNameStandard),
				Family: to.Ptr(armkeyvault.SKUFamilyA),
			},
			TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Vault = armkeyvault.Vault{
	// 	Name: to.Ptr("sample-vault"),
	// 	Type: to.Ptr("Microsoft.KeyVault/vaults"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-resource-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armkeyvault.VaultProperties{
	// 		AccessPolicies: []*armkeyvault.AccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				Permissions: &armkeyvault.Permissions{
	// 					Certificates: []*armkeyvault.CertificatePermissions{
	// 						to.Ptr(armkeyvault.CertificatePermissionsGet),
	// 						to.Ptr(armkeyvault.CertificatePermissionsList),
	// 						to.Ptr(armkeyvault.CertificatePermissionsDelete),
	// 						to.Ptr(armkeyvault.CertificatePermissionsCreate),
	// 						to.Ptr(armkeyvault.CertificatePermissionsImport),
	// 						to.Ptr(armkeyvault.CertificatePermissionsUpdate),
	// 						to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
	// 						to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsListissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsRecover),
	// 						to.Ptr(armkeyvault.CertificatePermissionsPurge)},
	// 						Keys: []*armkeyvault.KeyPermissions{
	// 							to.Ptr(armkeyvault.KeyPermissionsEncrypt),
	// 							to.Ptr(armkeyvault.KeyPermissionsDecrypt),
	// 							to.Ptr(armkeyvault.KeyPermissionsWrapKey),
	// 							to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
	// 							to.Ptr(armkeyvault.KeyPermissionsSign),
	// 							to.Ptr(armkeyvault.KeyPermissionsVerify),
	// 							to.Ptr(armkeyvault.KeyPermissionsGet),
	// 							to.Ptr(armkeyvault.KeyPermissionsList),
	// 							to.Ptr(armkeyvault.KeyPermissionsCreate),
	// 							to.Ptr(armkeyvault.KeyPermissionsUpdate),
	// 							to.Ptr(armkeyvault.KeyPermissionsImport),
	// 							to.Ptr(armkeyvault.KeyPermissionsDelete),
	// 							to.Ptr(armkeyvault.KeyPermissionsBackup),
	// 							to.Ptr(armkeyvault.KeyPermissionsRestore),
	// 							to.Ptr(armkeyvault.KeyPermissionsRecover),
	// 							to.Ptr(armkeyvault.KeyPermissionsPurge)},
	// 							Secrets: []*armkeyvault.SecretPermissions{
	// 								to.Ptr(armkeyvault.SecretPermissionsGet),
	// 								to.Ptr(armkeyvault.SecretPermissionsList),
	// 								to.Ptr(armkeyvault.SecretPermissionsSet),
	// 								to.Ptr(armkeyvault.SecretPermissionsDelete),
	// 								to.Ptr(armkeyvault.SecretPermissionsBackup),
	// 								to.Ptr(armkeyvault.SecretPermissionsRestore),
	// 								to.Ptr(armkeyvault.SecretPermissionsRecover),
	// 								to.Ptr(armkeyvault.SecretPermissionsPurge)},
	// 							},
	// 							TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					}},
	// 					EnabledForDeployment: to.Ptr(true),
	// 					EnabledForDiskEncryption: to.Ptr(true),
	// 					EnabledForTemplateDeployment: to.Ptr(true),
	// 					HsmPoolResourceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					NetworkACLs: &armkeyvault.NetworkRuleSet{
	// 						Bypass: to.Ptr(armkeyvault.NetworkRuleBypassOptionsAzureServices),
	// 						DefaultAction: to.Ptr(armkeyvault.NetworkRuleActionDeny),
	// 						IPRules: []*armkeyvault.IPRule{
	// 							{
	// 								Value: to.Ptr(""),
	// 						}},
	// 						VirtualNetworkRules: []*armkeyvault.VirtualNetworkRule{
	// 							{
	// 								ID: to.Ptr(""),
	// 								IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 						}},
	// 					},
	// 					PrivateEndpointConnections: []*armkeyvault.PrivateEndpointConnectionItem{
	// 						{
	// 							Etag: to.Ptr(""),
	// 							ID: to.Ptr(""),
	// 							Properties: &armkeyvault.PrivateEndpointConnectionProperties{
	// 								PrivateEndpoint: &armkeyvault.PrivateEndpoint{
	// 									ID: to.Ptr(""),
	// 								},
	// 								PrivateLinkServiceConnectionState: &armkeyvault.PrivateLinkServiceConnectionState{
	// 									ActionsRequired: to.Ptr(armkeyvault.ActionsRequiredNone),
	// 									Status: to.Ptr(armkeyvault.PrivateEndpointServiceConnectionStatusApproved),
	// 								},
	// 								ProvisioningState: to.Ptr(armkeyvault.PrivateEndpointConnectionProvisioningStateSucceeded),
	// 							},
	// 					}},
	// 					ProvisioningState: to.Ptr(armkeyvault.VaultProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr("Enabled"),
	// 					SKU: &armkeyvault.SKU{
	// 						Name: to.Ptr(armkeyvault.SKUNameStandard),
	// 						Family: to.Ptr(armkeyvault.SKUFamilyA),
	// 					},
	// 					TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					VaultURI: to.Ptr("https://sample-vault.vault.azure.net"),
	// 				},
	// 				SystemData: &armkeyvault.SystemData{
	// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 					CreatedBy: to.Ptr("keyVaultUser1"),
	// 					CreatedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("keyVaultUser2"),
	// 					LastModifiedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 				},
	// 				Tags: map[string]*string{
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/createVaultWithNetworkAcls.json
func ExampleVaultsClient_BeginCreateOrUpdate_createOrUpdateAVaultWithNetworkAcls() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVaultsClient().BeginCreateOrUpdate(ctx, "sample-resource-group", "sample-vault", armkeyvault.VaultCreateOrUpdateParameters{
		Location: to.Ptr("westus"),
		Properties: &armkeyvault.VaultProperties{
			EnabledForDeployment:         to.Ptr(true),
			EnabledForDiskEncryption:     to.Ptr(true),
			EnabledForTemplateDeployment: to.Ptr(true),
			NetworkACLs: &armkeyvault.NetworkRuleSet{
				Bypass:        to.Ptr(armkeyvault.NetworkRuleBypassOptionsAzureServices),
				DefaultAction: to.Ptr(armkeyvault.NetworkRuleActionDeny),
				IPRules: []*armkeyvault.IPRule{
					{
						Value: to.Ptr("124.56.78.91"),
					},
					{
						Value: to.Ptr("'10.91.4.0/24'"),
					}},
				VirtualNetworkRules: []*armkeyvault.VirtualNetworkRule{
					{
						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"),
					}},
			},
			SKU: &armkeyvault.SKU{
				Name:   to.Ptr(armkeyvault.SKUNameStandard),
				Family: to.Ptr(armkeyvault.SKUFamilyA),
			},
			TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Vault = armkeyvault.Vault{
	// 	Name: to.Ptr("sample-vault"),
	// 	Type: to.Ptr("Microsoft.KeyVault/vaults"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-resource-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armkeyvault.VaultProperties{
	// 		EnabledForDeployment: to.Ptr(true),
	// 		EnabledForDiskEncryption: to.Ptr(true),
	// 		EnabledForTemplateDeployment: to.Ptr(true),
	// 		HsmPoolResourceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		NetworkACLs: &armkeyvault.NetworkRuleSet{
	// 			Bypass: to.Ptr(armkeyvault.NetworkRuleBypassOptionsAzureServices),
	// 			DefaultAction: to.Ptr(armkeyvault.NetworkRuleActionDeny),
	// 			IPRules: []*armkeyvault.IPRule{
	// 				{
	// 					Value: to.Ptr("124.56.78.91/32"),
	// 				},
	// 				{
	// 					Value: to.Ptr("'10.91.4.0/24'"),
	// 			}},
	// 			VirtualNetworkRules: []*armkeyvault.VirtualNetworkRule{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.network/virtualnetworks/test-vnet/subnets/subnet1"),
	// 			}},
	// 		},
	// 		SKU: &armkeyvault.SKU{
	// 			Name: to.Ptr(armkeyvault.SKUNameStandard),
	// 			Family: to.Ptr(armkeyvault.SKUFamilyA),
	// 		},
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		VaultURI: to.Ptr("https://sample-vault.vault.azure.net"),
	// 	},
	// 	SystemData: &armkeyvault.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("keyVaultUser1"),
	// 		CreatedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("keyVaultUser2"),
	// 		LastModifiedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 	},
	// 	Tags: map[string]*string{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/updateVault.json
func ExampleVaultsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVaultsClient().Update(ctx, "sample-resource-group", "sample-vault", armkeyvault.VaultPatchParameters{
		Properties: &armkeyvault.VaultPatchProperties{
			AccessPolicies: []*armkeyvault.AccessPolicyEntry{
				{
					ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
					Permissions: &armkeyvault.Permissions{
						Certificates: []*armkeyvault.CertificatePermissions{
							to.Ptr(armkeyvault.CertificatePermissionsGet),
							to.Ptr(armkeyvault.CertificatePermissionsList),
							to.Ptr(armkeyvault.CertificatePermissionsDelete),
							to.Ptr(armkeyvault.CertificatePermissionsCreate),
							to.Ptr(armkeyvault.CertificatePermissionsImport),
							to.Ptr(armkeyvault.CertificatePermissionsUpdate),
							to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
							to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
							to.Ptr(armkeyvault.CertificatePermissionsListissuers),
							to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
							to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
							to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
							to.Ptr(armkeyvault.CertificatePermissionsRecover),
							to.Ptr(armkeyvault.CertificatePermissionsPurge)},
						Keys: []*armkeyvault.KeyPermissions{
							to.Ptr(armkeyvault.KeyPermissionsEncrypt),
							to.Ptr(armkeyvault.KeyPermissionsDecrypt),
							to.Ptr(armkeyvault.KeyPermissionsWrapKey),
							to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
							to.Ptr(armkeyvault.KeyPermissionsSign),
							to.Ptr(armkeyvault.KeyPermissionsVerify),
							to.Ptr(armkeyvault.KeyPermissionsGet),
							to.Ptr(armkeyvault.KeyPermissionsList),
							to.Ptr(armkeyvault.KeyPermissionsCreate),
							to.Ptr(armkeyvault.KeyPermissionsUpdate),
							to.Ptr(armkeyvault.KeyPermissionsImport),
							to.Ptr(armkeyvault.KeyPermissionsDelete),
							to.Ptr(armkeyvault.KeyPermissionsBackup),
							to.Ptr(armkeyvault.KeyPermissionsRestore),
							to.Ptr(armkeyvault.KeyPermissionsRecover),
							to.Ptr(armkeyvault.KeyPermissionsPurge)},
						Secrets: []*armkeyvault.SecretPermissions{
							to.Ptr(armkeyvault.SecretPermissionsGet),
							to.Ptr(armkeyvault.SecretPermissionsList),
							to.Ptr(armkeyvault.SecretPermissionsSet),
							to.Ptr(armkeyvault.SecretPermissionsDelete),
							to.Ptr(armkeyvault.SecretPermissionsBackup),
							to.Ptr(armkeyvault.SecretPermissionsRestore),
							to.Ptr(armkeyvault.SecretPermissionsRecover),
							to.Ptr(armkeyvault.SecretPermissionsPurge)},
					},
					TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
				}},
			EnabledForDeployment:         to.Ptr(true),
			EnabledForDiskEncryption:     to.Ptr(true),
			EnabledForTemplateDeployment: to.Ptr(true),
			PublicNetworkAccess:          to.Ptr("Enabled"),
			SKU: &armkeyvault.SKU{
				Name:   to.Ptr(armkeyvault.SKUNameStandard),
				Family: to.Ptr(armkeyvault.SKUFamilyA),
			},
			TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Vault = armkeyvault.Vault{
	// 	Name: to.Ptr("sample-vault"),
	// 	Type: to.Ptr("Microsoft.KeyVault/vaults"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-resource-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armkeyvault.VaultProperties{
	// 		AccessPolicies: []*armkeyvault.AccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				Permissions: &armkeyvault.Permissions{
	// 					Certificates: []*armkeyvault.CertificatePermissions{
	// 						to.Ptr(armkeyvault.CertificatePermissionsGet),
	// 						to.Ptr(armkeyvault.CertificatePermissionsList),
	// 						to.Ptr(armkeyvault.CertificatePermissionsDelete),
	// 						to.Ptr(armkeyvault.CertificatePermissionsCreate),
	// 						to.Ptr(armkeyvault.CertificatePermissionsImport),
	// 						to.Ptr(armkeyvault.CertificatePermissionsUpdate),
	// 						to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
	// 						to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsListissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsRecover),
	// 						to.Ptr(armkeyvault.CertificatePermissionsPurge)},
	// 						Keys: []*armkeyvault.KeyPermissions{
	// 							to.Ptr(armkeyvault.KeyPermissionsEncrypt),
	// 							to.Ptr(armkeyvault.KeyPermissionsDecrypt),
	// 							to.Ptr(armkeyvault.KeyPermissionsWrapKey),
	// 							to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
	// 							to.Ptr(armkeyvault.KeyPermissionsSign),
	// 							to.Ptr(armkeyvault.KeyPermissionsVerify),
	// 							to.Ptr(armkeyvault.KeyPermissionsGet),
	// 							to.Ptr(armkeyvault.KeyPermissionsList),
	// 							to.Ptr(armkeyvault.KeyPermissionsCreate),
	// 							to.Ptr(armkeyvault.KeyPermissionsUpdate),
	// 							to.Ptr(armkeyvault.KeyPermissionsImport),
	// 							to.Ptr(armkeyvault.KeyPermissionsDelete),
	// 							to.Ptr(armkeyvault.KeyPermissionsBackup),
	// 							to.Ptr(armkeyvault.KeyPermissionsRestore),
	// 							to.Ptr(armkeyvault.KeyPermissionsRecover),
	// 							to.Ptr(armkeyvault.KeyPermissionsPurge)},
	// 							Secrets: []*armkeyvault.SecretPermissions{
	// 								to.Ptr(armkeyvault.SecretPermissionsGet),
	// 								to.Ptr(armkeyvault.SecretPermissionsList),
	// 								to.Ptr(armkeyvault.SecretPermissionsSet),
	// 								to.Ptr(armkeyvault.SecretPermissionsDelete),
	// 								to.Ptr(armkeyvault.SecretPermissionsBackup),
	// 								to.Ptr(armkeyvault.SecretPermissionsRestore),
	// 								to.Ptr(armkeyvault.SecretPermissionsRecover),
	// 								to.Ptr(armkeyvault.SecretPermissionsPurge)},
	// 							},
	// 							TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					}},
	// 					EnabledForDeployment: to.Ptr(true),
	// 					EnabledForDiskEncryption: to.Ptr(true),
	// 					EnabledForTemplateDeployment: to.Ptr(true),
	// 					HsmPoolResourceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					NetworkACLs: &armkeyvault.NetworkRuleSet{
	// 						Bypass: to.Ptr(armkeyvault.NetworkRuleBypassOptionsAzureServices),
	// 						DefaultAction: to.Ptr(armkeyvault.NetworkRuleActionDeny),
	// 						IPRules: []*armkeyvault.IPRule{
	// 							{
	// 								Value: to.Ptr(""),
	// 						}},
	// 						VirtualNetworkRules: []*armkeyvault.VirtualNetworkRule{
	// 							{
	// 								ID: to.Ptr(""),
	// 								IgnoreMissingVnetServiceEndpoint: to.Ptr(false),
	// 						}},
	// 					},
	// 					PrivateEndpointConnections: []*armkeyvault.PrivateEndpointConnectionItem{
	// 						{
	// 							ID: to.Ptr(""),
	// 							Properties: &armkeyvault.PrivateEndpointConnectionProperties{
	// 								PrivateEndpoint: &armkeyvault.PrivateEndpoint{
	// 									ID: to.Ptr(""),
	// 								},
	// 								PrivateLinkServiceConnectionState: &armkeyvault.PrivateLinkServiceConnectionState{
	// 									ActionsRequired: to.Ptr(armkeyvault.ActionsRequiredNone),
	// 									Status: to.Ptr(armkeyvault.PrivateEndpointServiceConnectionStatusApproved),
	// 								},
	// 								ProvisioningState: to.Ptr(armkeyvault.PrivateEndpointConnectionProvisioningStateSucceeded),
	// 							},
	// 					}},
	// 					ProvisioningState: to.Ptr(armkeyvault.VaultProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr("Enabled"),
	// 					SKU: &armkeyvault.SKU{
	// 						Name: to.Ptr(armkeyvault.SKUNameStandard),
	// 						Family: to.Ptr(armkeyvault.SKUFamilyA),
	// 					},
	// 					TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					VaultURI: to.Ptr("https://sample-vault.vault.azure.net"),
	// 				},
	// 				SystemData: &armkeyvault.SystemData{
	// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 					CreatedBy: to.Ptr("keyVaultUser1"),
	// 					CreatedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("keyVaultUser2"),
	// 					LastModifiedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 				},
	// 				Tags: map[string]*string{
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/deleteVault.json
func ExampleVaultsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewVaultsClient().Delete(ctx, "sample-resource-group", "sample-vault", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/getVault.json
func ExampleVaultsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVaultsClient().Get(ctx, "sample-resource-group", "sample-vault", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Vault = armkeyvault.Vault{
	// 	Name: to.Ptr("sample-vault"),
	// 	Type: to.Ptr("Microsoft.KeyVault/vaults"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-resource-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armkeyvault.VaultProperties{
	// 		AccessPolicies: []*armkeyvault.AccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				Permissions: &armkeyvault.Permissions{
	// 					Certificates: []*armkeyvault.CertificatePermissions{
	// 						to.Ptr(armkeyvault.CertificatePermissionsGet),
	// 						to.Ptr(armkeyvault.CertificatePermissionsList),
	// 						to.Ptr(armkeyvault.CertificatePermissionsDelete),
	// 						to.Ptr(armkeyvault.CertificatePermissionsCreate),
	// 						to.Ptr(armkeyvault.CertificatePermissionsImport),
	// 						to.Ptr(armkeyvault.CertificatePermissionsUpdate),
	// 						to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
	// 						to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsListissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
	// 						to.Ptr(armkeyvault.CertificatePermissionsRecover),
	// 						to.Ptr(armkeyvault.CertificatePermissionsPurge)},
	// 						Keys: []*armkeyvault.KeyPermissions{
	// 							to.Ptr(armkeyvault.KeyPermissionsEncrypt),
	// 							to.Ptr(armkeyvault.KeyPermissionsDecrypt),
	// 							to.Ptr(armkeyvault.KeyPermissionsWrapKey),
	// 							to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
	// 							to.Ptr(armkeyvault.KeyPermissionsSign),
	// 							to.Ptr(armkeyvault.KeyPermissionsVerify),
	// 							to.Ptr(armkeyvault.KeyPermissionsGet),
	// 							to.Ptr(armkeyvault.KeyPermissionsList),
	// 							to.Ptr(armkeyvault.KeyPermissionsCreate),
	// 							to.Ptr(armkeyvault.KeyPermissionsUpdate),
	// 							to.Ptr(armkeyvault.KeyPermissionsImport),
	// 							to.Ptr(armkeyvault.KeyPermissionsDelete),
	// 							to.Ptr(armkeyvault.KeyPermissionsBackup),
	// 							to.Ptr(armkeyvault.KeyPermissionsRestore),
	// 							to.Ptr(armkeyvault.KeyPermissionsRecover),
	// 							to.Ptr(armkeyvault.KeyPermissionsPurge)},
	// 							Secrets: []*armkeyvault.SecretPermissions{
	// 								to.Ptr(armkeyvault.SecretPermissionsGet),
	// 								to.Ptr(armkeyvault.SecretPermissionsList),
	// 								to.Ptr(armkeyvault.SecretPermissionsSet),
	// 								to.Ptr(armkeyvault.SecretPermissionsDelete),
	// 								to.Ptr(armkeyvault.SecretPermissionsBackup),
	// 								to.Ptr(armkeyvault.SecretPermissionsRestore),
	// 								to.Ptr(armkeyvault.SecretPermissionsRecover),
	// 								to.Ptr(armkeyvault.SecretPermissionsPurge)},
	// 							},
	// 							TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					}},
	// 					EnabledForDeployment: to.Ptr(true),
	// 					EnabledForDiskEncryption: to.Ptr(true),
	// 					EnabledForTemplateDeployment: to.Ptr(true),
	// 					HsmPoolResourceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					ProvisioningState: to.Ptr(armkeyvault.VaultProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr("Enabled"),
	// 					SKU: &armkeyvault.SKU{
	// 						Name: to.Ptr(armkeyvault.SKUNameStandard),
	// 						Family: to.Ptr(armkeyvault.SKUFamilyA),
	// 					},
	// 					TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					VaultURI: to.Ptr("https://sample-vault.vault.azure.net"),
	// 				},
	// 				SystemData: &armkeyvault.SystemData{
	// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 					CreatedBy: to.Ptr("keyVaultUser1"),
	// 					CreatedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
	// 					LastModifiedBy: to.Ptr("keyVaultUser2"),
	// 					LastModifiedByType: to.Ptr(armkeyvault.IdentityTypeUser),
	// 				},
	// 				Tags: map[string]*string{
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/updateAccessPoliciesAdd.json
func ExampleVaultsClient_UpdateAccessPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVaultsClient().UpdateAccessPolicy(ctx, "sample-group", "sample-vault", armkeyvault.AccessPolicyUpdateKindAdd, armkeyvault.VaultAccessPolicyParameters{
		Properties: &armkeyvault.VaultAccessPolicyProperties{
			AccessPolicies: []*armkeyvault.AccessPolicyEntry{
				{
					ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
					Permissions: &armkeyvault.Permissions{
						Certificates: []*armkeyvault.CertificatePermissions{
							to.Ptr(armkeyvault.CertificatePermissionsGet)},
						Keys: []*armkeyvault.KeyPermissions{
							to.Ptr(armkeyvault.KeyPermissionsEncrypt)},
						Secrets: []*armkeyvault.SecretPermissions{
							to.Ptr(armkeyvault.SecretPermissionsGet)},
					},
					TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VaultAccessPolicyParameters = armkeyvault.VaultAccessPolicyParameters{
	// 	Type: to.Ptr("Microsoft.KeyVault/vaults/accessPolicies"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-group/providers/Microsoft.KeyVault/vaults/sample-vault/accessPolicies/"),
	// 	Properties: &armkeyvault.VaultAccessPolicyProperties{
	// 		AccessPolicies: []*armkeyvault.AccessPolicyEntry{
	// 			{
	// 				ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				Permissions: &armkeyvault.Permissions{
	// 					Certificates: []*armkeyvault.CertificatePermissions{
	// 						to.Ptr(armkeyvault.CertificatePermissionsGet)},
	// 						Keys: []*armkeyvault.KeyPermissions{
	// 							to.Ptr(armkeyvault.KeyPermissionsEncrypt)},
	// 							Secrets: []*armkeyvault.SecretPermissions{
	// 								to.Ptr(armkeyvault.SecretPermissionsGet)},
	// 							},
	// 							TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/listVaultByResourceGroup.json
func ExampleVaultsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVaultsClient().NewListByResourceGroupPager("sample-group", &armkeyvault.VaultsClientListByResourceGroupOptions{Top: to.Ptr[int32](1)})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VaultListResult = armkeyvault.VaultListResult{
		// 	Value: []*armkeyvault.Vault{
		// 		{
		// 			Name: to.Ptr("sample-vault"),
		// 			Type: to.Ptr("Microsoft.KeyVault/vaults"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armkeyvault.VaultProperties{
		// 				AccessPolicies: []*armkeyvault.AccessPolicyEntry{
		// 					{
		// 						ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						Permissions: &armkeyvault.Permissions{
		// 							Certificates: []*armkeyvault.CertificatePermissions{
		// 								to.Ptr(armkeyvault.CertificatePermissionsGet),
		// 								to.Ptr(armkeyvault.CertificatePermissionsList),
		// 								to.Ptr(armkeyvault.CertificatePermissionsDelete),
		// 								to.Ptr(armkeyvault.CertificatePermissionsCreate),
		// 								to.Ptr(armkeyvault.CertificatePermissionsImport),
		// 								to.Ptr(armkeyvault.CertificatePermissionsUpdate),
		// 								to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
		// 								to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsListissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsRecover),
		// 								to.Ptr(armkeyvault.CertificatePermissionsPurge)},
		// 								Keys: []*armkeyvault.KeyPermissions{
		// 									to.Ptr(armkeyvault.KeyPermissionsEncrypt),
		// 									to.Ptr(armkeyvault.KeyPermissionsDecrypt),
		// 									to.Ptr(armkeyvault.KeyPermissionsWrapKey),
		// 									to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
		// 									to.Ptr(armkeyvault.KeyPermissionsSign),
		// 									to.Ptr(armkeyvault.KeyPermissionsVerify),
		// 									to.Ptr(armkeyvault.KeyPermissionsGet),
		// 									to.Ptr(armkeyvault.KeyPermissionsList),
		// 									to.Ptr(armkeyvault.KeyPermissionsCreate),
		// 									to.Ptr(armkeyvault.KeyPermissionsUpdate),
		// 									to.Ptr(armkeyvault.KeyPermissionsImport),
		// 									to.Ptr(armkeyvault.KeyPermissionsDelete),
		// 									to.Ptr(armkeyvault.KeyPermissionsBackup),
		// 									to.Ptr(armkeyvault.KeyPermissionsRestore),
		// 									to.Ptr(armkeyvault.KeyPermissionsRecover),
		// 									to.Ptr(armkeyvault.KeyPermissionsPurge)},
		// 									Secrets: []*armkeyvault.SecretPermissions{
		// 										to.Ptr(armkeyvault.SecretPermissionsGet),
		// 										to.Ptr(armkeyvault.SecretPermissionsList),
		// 										to.Ptr(armkeyvault.SecretPermissionsSet),
		// 										to.Ptr(armkeyvault.SecretPermissionsDelete),
		// 										to.Ptr(armkeyvault.SecretPermissionsBackup),
		// 										to.Ptr(armkeyvault.SecretPermissionsRestore),
		// 										to.Ptr(armkeyvault.SecretPermissionsRecover),
		// 										to.Ptr(armkeyvault.SecretPermissionsPurge)},
		// 									},
		// 									TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							}},
		// 							EnableSoftDelete: to.Ptr(true),
		// 							EnabledForDeployment: to.Ptr(true),
		// 							EnabledForDiskEncryption: to.Ptr(true),
		// 							EnabledForTemplateDeployment: to.Ptr(true),
		// 							HsmPoolResourceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							ProvisioningState: to.Ptr(armkeyvault.VaultProvisioningStateSucceeded),
		// 							SKU: &armkeyvault.SKU{
		// 								Name: to.Ptr(armkeyvault.SKUNamePremium),
		// 								Family: to.Ptr(armkeyvault.SKUFamilyA),
		// 							},
		// 							TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							VaultURI: to.Ptr("https://sample-vault.vault.azure.net/"),
		// 						},
		// 						SystemData: &armkeyvault.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 							CreatedBy: to.Ptr("keyVaultUser1"),
		// 							CreatedByType: to.Ptr(armkeyvault.IdentityTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("keyVaultUser2"),
		// 							LastModifiedByType: to.Ptr(armkeyvault.IdentityTypeUser),
		// 						},
		// 						Tags: map[string]*string{
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/listVaultBySubscription.json
func ExampleVaultsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVaultsClient().NewListBySubscriptionPager(&armkeyvault.VaultsClientListBySubscriptionOptions{Top: to.Ptr[int32](1)})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VaultListResult = armkeyvault.VaultListResult{
		// 	Value: []*armkeyvault.Vault{
		// 		{
		// 			Name: to.Ptr("sample-vault"),
		// 			Type: to.Ptr("Microsoft.KeyVault/vaults"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armkeyvault.VaultProperties{
		// 				AccessPolicies: []*armkeyvault.AccessPolicyEntry{
		// 					{
		// 						ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						Permissions: &armkeyvault.Permissions{
		// 							Certificates: []*armkeyvault.CertificatePermissions{
		// 								to.Ptr(armkeyvault.CertificatePermissionsGet),
		// 								to.Ptr(armkeyvault.CertificatePermissionsList),
		// 								to.Ptr(armkeyvault.CertificatePermissionsDelete),
		// 								to.Ptr(armkeyvault.CertificatePermissionsCreate),
		// 								to.Ptr(armkeyvault.CertificatePermissionsImport),
		// 								to.Ptr(armkeyvault.CertificatePermissionsUpdate),
		// 								to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
		// 								to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsListissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
		// 								to.Ptr(armkeyvault.CertificatePermissionsRecover),
		// 								to.Ptr(armkeyvault.CertificatePermissionsPurge)},
		// 								Keys: []*armkeyvault.KeyPermissions{
		// 									to.Ptr(armkeyvault.KeyPermissionsEncrypt),
		// 									to.Ptr(armkeyvault.KeyPermissionsDecrypt),
		// 									to.Ptr(armkeyvault.KeyPermissionsWrapKey),
		// 									to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
		// 									to.Ptr(armkeyvault.KeyPermissionsSign),
		// 									to.Ptr(armkeyvault.KeyPermissionsVerify),
		// 									to.Ptr(armkeyvault.KeyPermissionsGet),
		// 									to.Ptr(armkeyvault.KeyPermissionsList),
		// 									to.Ptr(armkeyvault.KeyPermissionsCreate),
		// 									to.Ptr(armkeyvault.KeyPermissionsUpdate),
		// 									to.Ptr(armkeyvault.KeyPermissionsImport),
		// 									to.Ptr(armkeyvault.KeyPermissionsDelete),
		// 									to.Ptr(armkeyvault.KeyPermissionsBackup),
		// 									to.Ptr(armkeyvault.KeyPermissionsRestore),
		// 									to.Ptr(armkeyvault.KeyPermissionsRecover),
		// 									to.Ptr(armkeyvault.KeyPermissionsPurge)},
		// 									Secrets: []*armkeyvault.SecretPermissions{
		// 										to.Ptr(armkeyvault.SecretPermissionsGet),
		// 										to.Ptr(armkeyvault.SecretPermissionsList),
		// 										to.Ptr(armkeyvault.SecretPermissionsSet),
		// 										to.Ptr(armkeyvault.SecretPermissionsDelete),
		// 										to.Ptr(armkeyvault.SecretPermissionsBackup),
		// 										to.Ptr(armkeyvault.SecretPermissionsRestore),
		// 										to.Ptr(armkeyvault.SecretPermissionsRecover),
		// 										to.Ptr(armkeyvault.SecretPermissionsPurge)},
		// 									},
		// 									TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							}},
		// 							EnableSoftDelete: to.Ptr(true),
		// 							EnabledForDeployment: to.Ptr(true),
		// 							EnabledForDiskEncryption: to.Ptr(true),
		// 							EnabledForTemplateDeployment: to.Ptr(true),
		// 							HsmPoolResourceID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							ProvisioningState: to.Ptr(armkeyvault.VaultProvisioningStateSucceeded),
		// 							SKU: &armkeyvault.SKU{
		// 								Name: to.Ptr(armkeyvault.SKUNamePremium),
		// 								Family: to.Ptr(armkeyvault.SKUFamilyA),
		// 							},
		// 							TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							VaultURI: to.Ptr("https://sample-vault.vault.azure.net/"),
		// 						},
		// 						SystemData: &armkeyvault.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 							CreatedBy: to.Ptr("keyVaultUser1"),
		// 							CreatedByType: to.Ptr(armkeyvault.IdentityTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T12:00:00.000Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("keyVaultUser2"),
		// 							LastModifiedByType: to.Ptr(armkeyvault.IdentityTypeUser),
		// 						},
		// 						Tags: map[string]*string{
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/listDeletedVaults.json
func ExampleVaultsClient_NewListDeletedPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVaultsClient().NewListDeletedPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeletedVaultListResult = armkeyvault.DeletedVaultListResult{
		// 	Value: []*armkeyvault.DeletedVault{
		// 		{
		// 			Name: to.Ptr("vault-agile-drawer-6404"),
		// 			Type: to.Ptr("Microsoft.KeyVault/deletedVaults"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.KeyVault/locations/westus/deletedVaults/sample-vault"),
		// 			Properties: &armkeyvault.DeletedVaultProperties{
		// 				DeletionDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-01-01T00:00:59.000Z"); return t}()),
		// 				Location: to.Ptr("westus"),
		// 				PurgeProtectionEnabled: to.Ptr(true),
		// 				ScheduledPurgeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T00:00:59.000Z"); return t}()),
		// 				Tags: map[string]*string{
		// 				},
		// 				VaultID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/getDeletedVault.json
func ExampleVaultsClient_GetDeleted() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVaultsClient().GetDeleted(ctx, "sample-vault", "westus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeletedVault = armkeyvault.DeletedVault{
	// 	Name: to.Ptr("sample-vault"),
	// 	Type: to.Ptr("Microsoft.KeyVault/deletedVaults"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.KeyVault/locations/westus/deletedVaults/sample-vault"),
	// 	Properties: &armkeyvault.DeletedVaultProperties{
	// 		DeletionDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-01-01T00:00:59.000Z"); return t}()),
	// 		Location: to.Ptr("westus"),
	// 		PurgeProtectionEnabled: to.Ptr(true),
	// 		ScheduledPurgeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-04-01T00:00:59.000Z"); return t}()),
	// 		Tags: map[string]*string{
	// 		},
	// 		VaultID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/purgeDeletedVault.json
func ExampleVaultsClient_BeginPurgeDeleted() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewVaultsClient().BeginPurgeDeleted(ctx, "sample-vault", "westus", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/listVault.json
func ExampleVaultsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewVaultsClient().NewListPager(&armkeyvault.VaultsClientListOptions{Top: to.Ptr[int32](1)})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceListResult = armkeyvault.ResourceListResult{
		// 	Value: []*armkeyvault.Resource{
		// 		{
		// 			Name: to.Ptr("sample-vault"),
		// 			Type: to.Ptr("Microsoft.KeyVault/vaults"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/sample-group/providers/Microsoft.KeyVault/vaults/sample-vault"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/9ec0fcc278aa2128c4fbb2b8a1aa93432d72cce0/specification/keyvault/resource-manager/Microsoft.KeyVault/stable/2023-07-01/examples/checkVaultNameAvailability.json
func ExampleVaultsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armkeyvault.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewVaultsClient().CheckNameAvailability(ctx, armkeyvault.VaultCheckNameAvailabilityParameters{
		Name: to.Ptr("sample-vault"),
		Type: to.Ptr("Microsoft.KeyVault/vaults"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armkeyvault.CheckNameAvailabilityResult{
	// 	NameAvailable: to.Ptr(true),
	// }
}
