//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armorbital

import "time"

// AuthorizedGroundstation - Authorized groundstation.
type AuthorizedGroundstation struct {
	// REQUIRED; Date of authorization expiration.
	ExpirationDate *time.Time

	// REQUIRED; Groundstation name.
	GroundStation *string
}

// AvailableContacts - Customer retrieves list of Available Contacts for a spacecraft resource. Later, one of the available
// contact can be selected to create a contact.
type AvailableContacts struct {
	// Properties of Contact resource.
	Properties *AvailableContactsProperties

	// The reference to the spacecraft resource.
	Spacecraft *AvailableContactsSpacecraft

	// READ-ONLY; Name of Azure Ground Station.
	GroundStationName *string
}

// AvailableContactsListResult - Response for the ListAvailableContacts API service call.
type AvailableContactsListResult struct {
	// A list of available contacts.
	Value []*AvailableContacts

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AvailableContactsProperties - Properties of Contact resource.
type AvailableContactsProperties struct {
	// READ-ONLY; Azimuth of the antenna at the end of the contact in decimal degrees.
	EndAzimuthDegrees *float32

	// READ-ONLY; Spacecraft elevation above the horizon at contact end.
	EndElevationDegrees *float32

	// READ-ONLY; Maximum elevation of the antenna during the contact in decimal degrees.
	MaximumElevationDegrees *float32

	// READ-ONLY; Time to lost receiving a signal (ISO 8601 UTC standard).
	RxEndTime *time.Time

	// READ-ONLY; Earliest time to receive a signal (ISO 8601 UTC standard).
	RxStartTime *time.Time

	// READ-ONLY; Azimuth of the antenna at the start of the contact in decimal degrees.
	StartAzimuthDegrees *float32

	// READ-ONLY; Spacecraft elevation above the horizon at contact start.
	StartElevationDegrees *float32

	// READ-ONLY; Time at which antenna transmit will be disabled (ISO 8601 UTC standard).
	TxEndTime *time.Time

	// READ-ONLY; Time at which antenna transmit will be enabled (ISO 8601 UTC standard).
	TxStartTime *time.Time
}

// AvailableContactsSpacecraft - The reference to the spacecraft resource.
type AvailableContactsSpacecraft struct {
	// REQUIRED; Resource ID.
	ID *string
}

// AvailableGroundStation - Ground Stations available to schedule Contacts.
type AvailableGroundStation struct {
	// REQUIRED; The properties bag for this resource.
	Properties *AvailableGroundStationProperties

	// Azure region.
	Location *string

	// READ-ONLY; ID of groundStation.
	ID *string

	// READ-ONLY; Name of the ground station.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AvailableGroundStationListResult - Response for the AvailableGroundStations API service call.
type AvailableGroundStationListResult struct {
	// A list of ground station resources.
	Value []*AvailableGroundStation

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AvailableGroundStationProperties - The properties bag for this resource.
type AvailableGroundStationProperties struct {
	// Altitude of the ground station.
	AltitudeMeters *float32

	// City of ground station.
	City *string

	// Latitude of the ground station in decimal degrees.
	LatitudeDegrees *float32

	// Longitude of the ground station in decimal degrees.
	LongitudeDegrees *float32

	// Ground station provider name.
	ProviderName *string

	// Release Status of a ground station.
	ReleaseMode *ReleaseMode
}

// AvailableGroundStationPropertiesAutoGenerated - Properties object for Available groundstation.
type AvailableGroundStationPropertiesAutoGenerated struct {
	// Altitude of the ground station.
	AltitudeMeters *float32

	// City of ground station.
	City *string

	// Latitude of the ground station in decimal degrees.
	LatitudeDegrees *float32

	// Longitude of the ground station in decimal degrees.
	LongitudeDegrees *float32

	// Ground station provider name.
	ProviderName *string

	// Release Status of a ground station.
	ReleaseMode *ReleaseMode
}

// Contact - Customer creates a contact resource for a spacecraft resource.
type Contact struct {
	// REQUIRED; Properties of the Contact Resource.
	Properties *ContactsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContactInstanceProperties - Contact Instance Properties.
type ContactInstanceProperties struct {
	// READ-ONLY; Azimuth of the antenna at the end of the contact in decimal degrees.
	EndAzimuthDegrees *float32

	// READ-ONLY; Spacecraft elevation above the horizon at contact end.
	EndElevationDegrees *float32

	// READ-ONLY; Maximum elevation of the antenna during the contact in decimal degrees.
	MaximumElevationDegrees *float32

	// READ-ONLY; Time to lost receiving a signal (ISO 8601 UTC standard).
	RxEndTime *time.Time

	// READ-ONLY; Earliest time to receive a signal (ISO 8601 UTC standard).
	RxStartTime *time.Time

	// READ-ONLY; Azimuth of the antenna at the start of the contact in decimal degrees.
	StartAzimuthDegrees *float32

	// READ-ONLY; Spacecraft elevation above the horizon at contact start.
	StartElevationDegrees *float32

	// READ-ONLY; Time at which antenna transmit will be disabled (ISO 8601 UTC standard).
	TxEndTime *time.Time

	// READ-ONLY; Time at which antenna transmit will be enabled (ISO 8601 UTC standard).
	TxStartTime *time.Time
}

// ContactListResult - Response for the ListContacts API service call.
type ContactListResult struct {
	// A list of contact resources in a resource group.
	Value []*Contact

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ContactParameters - Parameters that define the contact resource.
type ContactParameters struct {
	// REQUIRED; The reference to the contact profile resource.
	ContactProfile *ContactParametersContactProfile

	// REQUIRED; End time of a contact (ISO 8601 UTC standard).
	EndTime *time.Time

	// REQUIRED; Name of Azure Ground Station.
	GroundStationName *string

	// REQUIRED; Start time of a contact (ISO 8601 UTC standard).
	StartTime *time.Time
}

// ContactParametersContactProfile - The reference to the contact profile resource.
type ContactParametersContactProfile struct {
	// REQUIRED; Resource ID.
	ID *string
}

// ContactProfile - Customer creates a Contact Profile Resource, which will contain all of the configurations required for
// scheduling a contact.
type ContactProfile struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Properties of the contact profile resource.
	Properties *ContactProfileProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContactProfileLink - Contact Profile Link.
type ContactProfileLink struct {
	// REQUIRED; Contact Profile Link Channel.
	Channels []*ContactProfileLinkChannel

	// REQUIRED; Direction (Uplink or Downlink).
	Direction *Direction

	// REQUIRED; Link name.
	Name *string

	// REQUIRED; Polarization. e.g. (RHCP, LHCP).
	Polarization *Polarization

	// Effective Isotropic Radiated Power (EIRP) in dBW. It is the required EIRP by the customer. Not used yet.
	EirpdBW *float32

	// Gain to noise temperature in db/K. It is the required G/T by the customer. Not used yet.
	GainOverTemperature *float32
}

// ContactProfileLinkChannel - Contact Profile Link Channel.
type ContactProfileLinkChannel struct {
	// REQUIRED; Bandwidth in MHz.
	BandwidthMHz *float32

	// REQUIRED; Center Frequency in MHz.
	CenterFrequencyMHz *float32

	// REQUIRED; Customer end point to store and retrieve data during a contact with the spacecraft.
	EndPoint *EndPoint

	// REQUIRED; Channel name.
	Name *string

	// Currently unused.
	DecodingConfiguration *string

	// Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If
	// provided, the modem connects to the customer endpoint and sends demodulated data
	// instead of a VITA.49 stream.
	DemodulationConfiguration *string

	// Currently unused.
	EncodingConfiguration *string

	// Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects
	// to the customer endpoint and accepts commands from the customer instead of
	// a VITA.49 stream.
	ModulationConfiguration *string
}

// ContactProfileListResult - Response for the ListContactProfiles API service call.
type ContactProfileListResult struct {
	// A list of contact profile resources in a resource group.
	Value []*ContactProfile

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ContactProfileProperties - Properties of the contact profile resource.
type ContactProfileProperties struct {
	// REQUIRED; Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
	Links []*ContactProfileLink

	// REQUIRED; Network configuration of customer virtual network.
	NetworkConfiguration *ContactProfilesPropertiesNetworkConfiguration

	// Auto-tracking configuration.
	AutoTrackingConfiguration *AutoTrackingConfiguration

	// ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to
	// send telemetry into the hub.
	EventHubURI *string

	// Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft
	// at a given ground station.
	MinimumElevationDegrees *float32

	// Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given
	// ground station.
	MinimumViableContactDuration *string

	// The current state of the resource's creation, deletion, or modification.
	ProvisioningState *ContactProfilesPropertiesProvisioningState

	// Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
	ThirdPartyConfigurations []*ContactProfileThirdPartyConfiguration
}

// ContactProfileThirdPartyConfiguration - Contact Profile third-party partner configuration.
type ContactProfileThirdPartyConfiguration struct {
	// REQUIRED; Name of string referencing the configuration describing contact set-up for a particular mission. Expected values
	// are those which have been created in collaboration with the partner network.
	MissionConfiguration *string

	// REQUIRED; Name of the third-party provider.
	ProviderName *string
}

// ContactProfilesProperties - List of Contact Profile Resource Properties.
type ContactProfilesProperties struct {
	// REQUIRED; Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
	Links []*ContactProfileLink

	// REQUIRED; Network configuration of customer virtual network.
	NetworkConfiguration *ContactProfilesPropertiesNetworkConfiguration

	// Auto-tracking configuration.
	AutoTrackingConfiguration *AutoTrackingConfiguration

	// ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to
	// send telemetry into the hub.
	EventHubURI *string

	// Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft
	// at a given ground station.
	MinimumElevationDegrees *float32

	// Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given
	// ground station.
	MinimumViableContactDuration *string

	// The current state of the resource's creation, deletion, or modification.
	ProvisioningState *ContactProfilesPropertiesProvisioningState

	// Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
	ThirdPartyConfigurations []*ContactProfileThirdPartyConfiguration
}

// ContactProfilesPropertiesNetworkConfiguration - Network configuration of customer virtual network.
type ContactProfilesPropertiesNetworkConfiguration struct {
	// REQUIRED; ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least
	// a class C subnet, and should not have any IP created in it.
	SubnetID *string
}

// ContactsProperties - Properties of the Contact Resource.
type ContactsProperties struct {
	// REQUIRED; The reference to the contact profile resource.
	ContactProfile *ContactsPropertiesContactProfile

	// REQUIRED; Azure Ground Station name.
	GroundStationName *string

	// REQUIRED; Reservation end time of a contact (ISO 8601 UTC standard).
	ReservationEndTime *time.Time

	// REQUIRED; Reservation start time of a contact (ISO 8601 UTC standard).
	ReservationStartTime *time.Time

	// The current state of the resource's creation, deletion, or modification.
	ProvisioningState *ContactsPropertiesProvisioningState

	// READ-ONLY; The configuration associated with the allocated antenna.
	AntennaConfiguration *ContactsPropertiesAntennaConfiguration

	// READ-ONLY; Azimuth of the antenna at the end of the contact in decimal degrees.
	EndAzimuthDegrees *float32

	// READ-ONLY; Spacecraft elevation above the horizon at contact end.
	EndElevationDegrees *float32

	// READ-ONLY; Any error message while scheduling a contact.
	ErrorMessage *string

	// READ-ONLY; Maximum elevation of the antenna during the contact in decimal degrees.
	MaximumElevationDegrees *float32

	// READ-ONLY; Receive end time of a contact (ISO 8601 UTC standard).
	RxEndTime *time.Time

	// READ-ONLY; Receive start time of a contact (ISO 8601 UTC standard).
	RxStartTime *time.Time

	// READ-ONLY; Azimuth of the antenna at the start of the contact in decimal degrees.
	StartAzimuthDegrees *float32

	// READ-ONLY; Spacecraft elevation above the horizon at contact start.
	StartElevationDegrees *float32

	// READ-ONLY; Status of a contact.
	Status *ContactsStatus

	// READ-ONLY; Transmit end time of a contact (ISO 8601 UTC standard).
	TxEndTime *time.Time

	// READ-ONLY; Transmit start time of a contact (ISO 8601 UTC standard).
	TxStartTime *time.Time
}

// ContactsPropertiesAntennaConfiguration - The configuration associated with the allocated antenna.
type ContactsPropertiesAntennaConfiguration struct {
	// The destination IP a packet can be sent to. This would for example be the TCP endpoint you would send data to.
	DestinationIP *string

	// List of Source IP
	SourceIPs []*string
}

// ContactsPropertiesContactProfile - The reference to the contact profile resource.
type ContactsPropertiesContactProfile struct {
	// REQUIRED; Resource ID.
	ID *string
}

// EndPoint - Customer end point to store and retrieve data during a contact with the spacecraft.
type EndPoint struct {
	// REQUIRED; Name of an end point.
	EndPointName *string

	// REQUIRED; IP Address (IPv4).
	IPAddress *string

	// REQUIRED; TCP port to listen on to receive data.
	Port *string

	// REQUIRED; Protocol either UDP or TCP.
	Protocol *Protocol
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationResult - Operation Result Entity.
type OperationResult struct {
	// Operation result error properties.
	Error *OperationResultErrorProperties

	// Operation result properties.
	Properties any

	// READ-ONLY; The operation end time (ISO 8601 UTC standard).
	EndTime *time.Time

	// READ-ONLY; ID of the resource.
	ID *string

	// READ-ONLY; Name of the resource.
	Name *string

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string

	// READ-ONLY; Percentage completed.
	PercentComplete *float64

	// READ-ONLY; The operation start time (ISO 8601 UTC standard).
	StartTime *time.Time

	// READ-ONLY; The status of operation.
	Status *Status

	// READ-ONLY; A list of results when the operation returns multiple results.
	Value []any
}

// OperationResultErrorProperties - Operation result error properties.
type OperationResultErrorProperties struct {
	// READ-ONLY; The code of the error.
	Code *string

	// READ-ONLY; The error message.
	Message *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceIDListResult - Response for an API service call that lists the resource IDs of resources associated with another
// resource.
type ResourceIDListResult struct {
	// A list of Azure Resource IDs.
	Value []*ResourceIDListResultValueItem

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

type ResourceIDListResultValueItem struct {
	// The Azure Resource ID.
	ID *string
}

// ResourceReference - Resource Reference.
type ResourceReference struct {
	// REQUIRED; Resource ID.
	ID *string
}

// Spacecraft - Customer creates a spacecraft resource to schedule a contact.
type Spacecraft struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Spacecraft Properties
	Properties *SpacecraftsProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SpacecraftLink - List of authorized spacecraft links per ground station and the expiration date of the authorization.
type SpacecraftLink struct {
	// REQUIRED; Bandwidth in MHz.
	BandwidthMHz *float32

	// REQUIRED; Center Frequency in MHz.
	CenterFrequencyMHz *float32

	// REQUIRED; Direction (Uplink or Downlink).
	Direction *Direction

	// REQUIRED; Link name.
	Name *string

	// REQUIRED; Polarization. e.g. (RHCP, LHCP).
	Polarization *Polarization

	// READ-ONLY; Authorized Ground Stations
	Authorizations []*AuthorizedGroundstation
}

// SpacecraftListResult - Response for the ListSpacecrafts API service call.
type SpacecraftListResult struct {
	// A list of spacecraft resources in a resource group.
	Value []*Spacecraft

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SpacecraftsProperties - List of Spacecraft Resource Properties.
type SpacecraftsProperties struct {
	// REQUIRED; Immutable list of Spacecraft links.
	Links []*SpacecraftLink

	// REQUIRED; Title line of the two-line element set (TLE).
	TitleLine *string

	// REQUIRED; Line 1 of the two-line element set (TLE).
	TleLine1 *string

	// REQUIRED; Line 2 of the two-line element set (TLE).
	TleLine2 *string

	// NORAD ID of the spacecraft.
	NoradID *string

	// The current state of the resource's creation, deletion, or modification.
	ProvisioningState *SpacecraftsPropertiesProvisioningState
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}
