//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLVulnerabilityAssessmentScansClient contains the methods for the SQLVulnerabilityAssessmentScans group.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentScansClient() instead.
type SQLVulnerabilityAssessmentScansClient struct {
	internal *arm.Client
}

// NewSQLVulnerabilityAssessmentScansClient creates a new instance of SQLVulnerabilityAssessmentScansClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSQLVulnerabilityAssessmentScansClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLVulnerabilityAssessmentScansClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SQLVulnerabilityAssessmentScansClient{
		internal: cl,
	}
	return client, nil
}

// Get - Gets the scan details of a single scan record.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-01-preview
//   - scanID - The scan Id. Type 'latest' to get the scan record for the latest scan.
//   - workspaceID - The workspace Id.
//   - resourceID - The identifier of the resource.
//   - options - SQLVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the SQLVulnerabilityAssessmentScansClient.Get
//     method.
func (client *SQLVulnerabilityAssessmentScansClient) Get(ctx context.Context, scanID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientGetOptions) (SQLVulnerabilityAssessmentScansClientGetResponse, error) {
	var err error
	const operationName = "SQLVulnerabilityAssessmentScansClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scanID, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SQLVulnerabilityAssessmentScansClient) getCreateRequest(ctx context.Context, scanID string, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}"
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2023-02-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLVulnerabilityAssessmentScansClient) getHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentScansClientGetResponse, error) {
	result := SQLVulnerabilityAssessmentScansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Scan); err != nil {
		return SQLVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	return result, nil
}

// List - Gets a list of scan records.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-02-01-preview
//   - workspaceID - The workspace Id.
//   - resourceID - The identifier of the resource.
//   - options - SQLVulnerabilityAssessmentScansClientListOptions contains the optional parameters for the SQLVulnerabilityAssessmentScansClient.List
//     method.
func (client *SQLVulnerabilityAssessmentScansClient) List(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientListOptions) (SQLVulnerabilityAssessmentScansClientListResponse, error) {
	var err error
	const operationName = "SQLVulnerabilityAssessmentScansClient.List"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCreateRequest(ctx, workspaceID, resourceID, options)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	resp, err := client.listHandleResponse(httpResp)
	return resp, err
}

// listCreateRequest creates the List request.
func (client *SQLVulnerabilityAssessmentScansClient) listCreateRequest(ctx context.Context, workspaceID string, resourceID string, options *SQLVulnerabilityAssessmentScansClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("workspaceId", workspaceID)
	reqQP.Set("api-version", "2023-02-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SQLVulnerabilityAssessmentScansClient) listHandleResponse(resp *http.Response) (SQLVulnerabilityAssessmentScansClientListResponse, error) {
	result := SQLVulnerabilityAssessmentScansClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Scans); err != nil {
		return SQLVulnerabilityAssessmentScansClientListResponse{}, err
	}
	return result, nil
}
