//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstorsimple8000series_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesConfigure.json
func ExampleDevicesClient_BeginConfigure() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginConfigure(ctx, "ResourceGroupForSDKTest", "ManagerForSDKTest1", armstorsimple8000series.ConfigureDeviceRequest{
		Properties: &armstorsimple8000series.ConfigureDeviceRequestProperties{
			CurrentDeviceName: to.Ptr("Device001ForSDKTest"),
			FriendlyName:      to.Ptr("Device001ForSDKTest"),
			NetworkInterfaceData0Settings: &armstorsimple8000series.NetworkInterfaceData0Settings{
				ControllerOneIP:  to.Ptr("10.168.220.228"),
				ControllerZeroIP: to.Ptr("10.168.220.227"),
			},
			TimeZone: to.Ptr("Pacific Standard Time"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesListByManager.json
func ExampleDevicesClient_NewListByManagerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListByManagerPager("ResourceGroupForSDKTest", "ManagerForSDKTest1", &armstorsimple8000series.DevicesClientListByManagerOptions{Expand: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeviceList = armstorsimple8000series.DeviceList{
		// 	Value: []*armstorsimple8000series.Device{
		// 		{
		// 			Name: to.Ptr("sugattdeviceforSDK"),
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/sugattdeviceforSDK"),
		// 			Kind: to.Ptr("Series8000"),
		// 			Properties: &armstorsimple8000series.DeviceProperties{
		// 				ActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-14T07:01:51.896Z"); return t}()),
		// 				ActiveController: to.Ptr(armstorsimple8000series.ControllerIDController0),
		// 				AgentGroupVersion: to.Ptr[int32](7),
		// 				AvailableLocalStorageInBytes: to.Ptr[int64](43980464128),
		// 				AvailableTieredStorageInBytes: to.Ptr[int64](1099511627776),
		// 				Culture: to.Ptr("en-US"),
		// 				DeviceConfigurationStatus: to.Ptr(armstorsimple8000series.DeviceConfigurationStatusComplete),
		// 				DeviceDescription: to.Ptr("Device for SDK testing."),
		// 				DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
		// 				DeviceType: to.Ptr(armstorsimple8000series.DeviceTypeSeries8000PhysicalAppliance),
		// 				FriendlyName: to.Ptr("sugattdeviceforSDK"),
		// 				FriendlySoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
		// 				ModelDescription: to.Ptr("100"),
		// 				NetworkInterfaceCardCount: to.Ptr[int32](6),
		// 				ProvisionedLocalStorageInBytes: to.Ptr[int64](0),
		// 				ProvisionedTieredStorageInBytes: to.Ptr[int64](0),
		// 				ProvisionedVolumeSizeInBytes: to.Ptr[int64](0),
		// 				SerialNumber: to.Ptr("123456789"),
		// 				Status: to.Ptr(armstorsimple8000series.DeviceStatusOffline),
		// 				TargetIqn: to.Ptr("iqn.1991-05.com.microsoft:storsimple100-123456789-target"),
		// 				TotalTieredStorageInBytes: to.Ptr[int64](1099511627776),
		// 				UsingStorageInBytes: to.Ptr[int64](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("jemdeviceforsdk"),
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/jemdeviceforsdk"),
		// 			Kind: to.Ptr("Series8000"),
		// 			Properties: &armstorsimple8000series.DeviceProperties{
		// 				ActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-13T05:03:25.868Z"); return t}()),
		// 				ActiveController: to.Ptr(armstorsimple8000series.ControllerIDController0),
		// 				AgentGroupVersion: to.Ptr[int32](7),
		// 				AvailableLocalStorageInBytes: to.Ptr[int64](43765715760),
		// 				AvailableTieredStorageInBytes: to.Ptr[int64](1094142918656),
		// 				Culture: to.Ptr("en-US"),
		// 				DeviceConfigurationStatus: to.Ptr(armstorsimple8000series.DeviceConfigurationStatusComplete),
		// 				DeviceDescription: to.Ptr("Device for SDK testing."),
		// 				DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
		// 				DeviceType: to.Ptr(armstorsimple8000series.DeviceTypeSeries8000PhysicalAppliance),
		// 				FriendlyName: to.Ptr("jemdeviceforsdk"),
		// 				FriendlySoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
		// 				ModelDescription: to.Ptr("100"),
		// 				NetworkInterfaceCardCount: to.Ptr[int32](6),
		// 				ProvisionedLocalStorageInBytes: to.Ptr[int64](0),
		// 				ProvisionedTieredStorageInBytes: to.Ptr[int64](5368709120),
		// 				ProvisionedVolumeSizeInBytes: to.Ptr[int64](5368709120),
		// 				SerialNumber: to.Ptr("123456789"),
		// 				Status: to.Ptr(armstorsimple8000series.DeviceStatusOnline),
		// 				TargetIqn: to.Ptr("Test-Target-IQN"),
		// 				TotalTieredStorageInBytes: to.Ptr[int64](1099511627776),
		// 				UsingStorageInBytes: to.Ptr[int64](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Device05ForSDKTest"),
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices"),
		// 			ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Kind: to.Ptr("Series8000"),
		// 			Properties: &armstorsimple8000series.DeviceProperties{
		// 				ActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-07T18:28:31.661Z"); return t}()),
		// 				ActiveController: to.Ptr(armstorsimple8000series.ControllerIDController0),
		// 				AgentGroupVersion: to.Ptr[int32](7),
		// 				AvailableLocalStorageInBytes: to.Ptr[int64](42262477184),
		// 				AvailableTieredStorageInBytes: to.Ptr[int64](1056561954816),
		// 				Culture: to.Ptr("en-US"),
		// 				DeviceConfigurationStatus: to.Ptr(armstorsimple8000series.DeviceConfigurationStatusComplete),
		// 				DeviceDescription: to.Ptr("Device for SDK testing."),
		// 				DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
		// 				DeviceType: to.Ptr(armstorsimple8000series.DeviceTypeSeries8000PhysicalAppliance),
		// 				FriendlyName: to.Ptr("Device05ForSDKTest"),
		// 				FriendlySoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
		// 				ModelDescription: to.Ptr("100"),
		// 				NetworkInterfaceCardCount: to.Ptr[int32](6),
		// 				ProvisionedLocalStorageInBytes: to.Ptr[int64](0),
		// 				ProvisionedTieredStorageInBytes: to.Ptr[int64](42949672960),
		// 				ProvisionedVolumeSizeInBytes: to.Ptr[int64](42949672960),
		// 				SerialNumber: to.Ptr("123456789"),
		// 				Status: to.Ptr(armstorsimple8000series.DeviceStatusOnline),
		// 				TargetIqn: to.Ptr("iqn.1991-05.com.microsoft:storsimple100-123456789-target"),
		// 				TotalTieredStorageInBytes: to.Ptr[int64](1099511627776),
		// 				UsingStorageInBytes: to.Ptr[int64](0),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesGet.json
func ExampleDevicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().Get(ctx, "Device001ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", &armstorsimple8000series.DevicesClientGetOptions{Expand: to.Ptr("details")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armstorsimple8000series.Device{
	// 	Name: to.Ptr("Device001ForSDKTest"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/devices"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device001ForSDKTest"),
	// 	Kind: to.Ptr("Series8000"),
	// 	Properties: &armstorsimple8000series.DeviceProperties{
	// 		ActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-22T09:36:20.963Z"); return t}()),
	// 		ActiveController: to.Ptr(armstorsimple8000series.ControllerIDController0),
	// 		AgentGroupVersion: to.Ptr[int32](7),
	// 		AvailableLocalStorageInBytes: to.Ptr[int64](43980464128),
	// 		AvailableTieredStorageInBytes: to.Ptr[int64](1099511627776),
	// 		Culture: to.Ptr("en-US"),
	// 		DeviceConfigurationStatus: to.Ptr(armstorsimple8000series.DeviceConfigurationStatusComplete),
	// 		DeviceDescription: to.Ptr("updated device description"),
	// 		DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
	// 		DeviceType: to.Ptr(armstorsimple8000series.DeviceTypeSeries8000PhysicalAppliance),
	// 		FriendlyName: to.Ptr("Device001ForSDKTest"),
	// 		FriendlySoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
	// 		ModelDescription: to.Ptr("100"),
	// 		NetworkInterfaceCardCount: to.Ptr[int32](6),
	// 		ProvisionedLocalStorageInBytes: to.Ptr[int64](0),
	// 		ProvisionedTieredStorageInBytes: to.Ptr[int64](0),
	// 		ProvisionedVolumeSizeInBytes: to.Ptr[int64](0),
	// 		SerialNumber: to.Ptr("123456789"),
	// 		Status: to.Ptr(armstorsimple8000series.DeviceStatusOnline),
	// 		TargetIqn: to.Ptr("iqn.1991-05.com.microsoft:storsimple100-123456789-target"),
	// 		TotalTieredStorageInBytes: to.Ptr[int64](1099511627776),
	// 		UsingStorageInBytes: to.Ptr[int64](0),
	// 		Details: &armstorsimple8000series.DeviceDetails{
	// 			EndpointCount: to.Ptr[int32](0),
	// 			VolumeContainerCount: to.Ptr[int32](0),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesDelete.json
func ExampleDevicesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginDelete(ctx, "Device001ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesUpdate.json
func ExampleDevicesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().Update(ctx, "Device001ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", armstorsimple8000series.DevicePatch{
		Properties: &armstorsimple8000series.DevicePatchProperties{
			DeviceDescription: to.Ptr("updated device description"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Device = armstorsimple8000series.Device{
	// 	Name: to.Ptr("Device001ForSDKTest"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/devices"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device001ForSDKTest"),
	// 	Kind: to.Ptr("Series8000"),
	// 	Properties: &armstorsimple8000series.DeviceProperties{
	// 		ActivationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-22T09:36:20.963Z"); return t}()),
	// 		ActiveController: to.Ptr(armstorsimple8000series.ControllerIDController0),
	// 		AgentGroupVersion: to.Ptr[int32](7),
	// 		AvailableLocalStorageInBytes: to.Ptr[int64](43980464128),
	// 		AvailableTieredStorageInBytes: to.Ptr[int64](1099511627776),
	// 		Culture: to.Ptr("en-US"),
	// 		DeviceConfigurationStatus: to.Ptr(armstorsimple8000series.DeviceConfigurationStatusComplete),
	// 		DeviceDescription: to.Ptr("updated device description"),
	// 		DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
	// 		DeviceType: to.Ptr(armstorsimple8000series.DeviceTypeSeries8000PhysicalAppliance),
	// 		FriendlyName: to.Ptr("Device001ForSDKTest"),
	// 		FriendlySoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
	// 		ModelDescription: to.Ptr("100"),
	// 		NetworkInterfaceCardCount: to.Ptr[int32](6),
	// 		ProvisionedLocalStorageInBytes: to.Ptr[int64](0),
	// 		ProvisionedTieredStorageInBytes: to.Ptr[int64](0),
	// 		ProvisionedVolumeSizeInBytes: to.Ptr[int64](0),
	// 		SerialNumber: to.Ptr("123456789"),
	// 		Status: to.Ptr(armstorsimple8000series.DeviceStatusOnline),
	// 		TargetIqn: to.Ptr("iqn.1991-05.com.microsoft:storsimple100-123456789-target"),
	// 		TotalTieredStorageInBytes: to.Ptr[int64](1099511627776),
	// 		UsingStorageInBytes: to.Ptr[int64](0),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesAuthorizeForServiceEncryptionKeyRollover.json
func ExampleDevicesClient_AuthorizeForServiceEncryptionKeyRollover() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDevicesClient().AuthorizeForServiceEncryptionKeyRollover(ctx, "Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesDeactivate.json
func ExampleDevicesClient_BeginDeactivate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginDeactivate(ctx, "Device001ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesInstallUpdates.json
func ExampleDevicesClient_BeginInstallUpdates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginInstallUpdates(ctx, "sugattdeviceforSDK", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesListFailoverSets.json
func ExampleDevicesClient_NewListFailoverSetsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListFailoverSetsPager("Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FailoverSetsList = armstorsimple8000series.FailoverSetsList{
		// 	Value: []*armstorsimple8000series.FailoverSet{
		// 		{
		// 			EligibilityResult: &armstorsimple8000series.FailoverSetEligibilityResult{
		// 				IsEligibleForFailover: to.Ptr(true),
		// 			},
		// 			VolumeContainers: []*armstorsimple8000series.VolumeContainerFailoverMetadata{
		// 				{
		// 					VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcforsdktest"),
		// 					Volumes: []*armstorsimple8000series.VolumeFailoverMetadata{
		// 						{
		// 							BackupCreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-20T06:30:03.794Z"); return t}()),
		// 							BackupElementID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backups/964d5a65-5294-4707-9c71-becb8850ea12/elements/2553386f-f39e-4223-b9fa-319adc5630fe_0000000000000000"),
		// 							BackupID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backups/964d5a65-5294-4707-9c71-becb8850ea12"),
		// 							BackupPolicyID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/jembkpolicy"),
		// 							SizeInBytes: to.Ptr[int64](5368709120),
		// 							VolumeID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcforsdktest/volumes/jemVol1"),
		// 							VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			EligibilityResult: &armstorsimple8000series.FailoverSetEligibilityResult{
		// 				IsEligibleForFailover: to.Ptr(true),
		// 			},
		// 			VolumeContainers: []*armstorsimple8000series.VolumeContainerFailoverMetadata{
		// 				{
		// 					VolumeContainerID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest"),
		// 					Volumes: []*armstorsimple8000series.VolumeFailoverMetadata{
		// 						{
		// 							BackupCreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-10T10:29:37.215Z"); return t}()),
		// 							BackupElementID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backups/0874889e-f2a3-42d2-a643-f378fc199688/elements/5baae396-46f1-46a0-bc25-d8e2fcada7fa_0000000000000000"),
		// 							BackupID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backups/0874889e-f2a3-42d2-a643-f378fc199688"),
		// 							BackupPolicyID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicyForSDKTest429326237"),
		// 							SizeInBytes: to.Ptr[int64](10737418240),
		// 							VolumeID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/vol01"),
		// 							VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 						},
		// 						{
		// 							BackupCreatedDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-10T10:29:37.215Z"); return t}()),
		// 							BackupElementID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backups/0874889e-f2a3-42d2-a643-f378fc199688/elements/5c7eb677-d688-4afb-a352-ca62454d5921_0000000000000000"),
		// 							BackupID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backups/0874889e-f2a3-42d2-a643-f378fc199688"),
		// 							BackupPolicyID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/backupPolicies/BkUpPolicyForSDKTest429326237"),
		// 							SizeInBytes: to.Ptr[int64](10737418240),
		// 							VolumeID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcForOdataFilterTest/volumes/vol%2540123"),
		// 							VolumeType: to.Ptr(armstorsimple8000series.VolumeTypeTiered),
		// 					}},
		// 			}},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesListMetrics.json
func ExampleDevicesClient_NewListMetricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListMetricsPager("Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", "name/value%20eq%20'PrimaryStorageTieredUsed'%20and%20timeGrain%20eq%20'PT1H'%20and%20startTime%20ge%20'2017-06-17T18:30:00Z'%20and%20endTime%20le%20'2017-06-21T18:30:00Z'%20and%20category%20eq%20'CapacityUtilization'", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricList = armstorsimple8000series.MetricList{
		// 	Value: []*armstorsimple8000series.Metrics{
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Tiered Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageTieredUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metrics"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-21T18:30:00.000Z"); return t}()),
		// 			PrimaryAggregation: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-17T18:30:00.000Z"); return t}()),
		// 			TimeGrain: to.Ptr("01:00:00"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 			Values: []*armstorsimple8000series.MetricData{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesListMetricDefinition.json
func ExampleDevicesClient_NewListMetricDefinitionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListMetricDefinitionPager("Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionList = armstorsimple8000series.MetricDefinitionList{
		// 	Value: []*armstorsimple8000series.MetricDefinition{
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Tiered Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageTieredUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Primary Locally Pinned Storage Used"),
		// 				Value: to.Ptr("PrimaryStorageLocallyPinnedUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Cloud Storage Used"),
		// 				Value: to.Ptr("CloudStorageUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Local Storage Used"),
		// 				Value: to.Ptr("LocalStorageUsed"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("CapacityUtilization"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytes),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read I/O Operations/s"),
		// 				Value: to.Ptr("InitiatorToDeviceReadOperations"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write I/O Operations/s"),
		// 				Value: to.Ptr("InitiatorToDeviceWriteOperations"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read Bytes/s"),
		// 				Value: to.Ptr("InitiatorToDeviceReadBytes"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write Bytes/s"),
		// 				Value: to.Ptr("InitiatorToDeviceWriteBytes"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read Latency"),
		// 				Value: to.Ptr("InitiatorToDeviceReadLatency"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitSeconds),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write Latency"),
		// 				Value: to.Ptr("InitiatorToDeviceWriteLatency"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitSeconds),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Outstanding I/O"),
		// 				Value: to.Ptr("InitiatorToDeviceOutStandingIO"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("InitiatorToDeviceIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read I/O Operations/s"),
		// 				Value: to.Ptr("DeviceToCloudReadOperations"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write I/O Operations/s"),
		// 				Value: to.Ptr("DeviceToCloudWriteOperations"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read Bytes/s"),
		// 				Value: to.Ptr("DeviceToCloudReadBytes"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write Bytes/s"),
		// 				Value: to.Ptr("DeviceToCloudWriteBytes"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Read Latency"),
		// 				Value: to.Ptr("DeviceToCloudReadLatency"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitSeconds),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Write Latency"),
		// 				Value: to.Ptr("DeviceToCloudWriteLatency"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitSeconds),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Outstanding I/O"),
		// 				Value: to.Ptr("DeviceToCloudOutStandingIO"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DeviceToCloudIOPerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitCount),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("CPU Utilization"),
		// 				Value: to.Ptr("CPUUsage"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("DevicePerformance"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("Device"),
		// 					Value: to.Ptr("Device05ForSDKTest"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("PT6H"),
		// 					TimeGrain: to.Ptr("PT1M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitPercent),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Network Out"),
		// 				Value: to.Ptr("NetworkOut"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("NetworkThroughput"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("NetworkInterface"),
		// 					Value: to.Ptr("data0"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 		},
		// 		{
		// 			Name: &armstorsimple8000series.MetricName{
		// 				LocalizedValue: to.Ptr("Network In"),
		// 				Value: to.Ptr("NetworkIn"),
		// 			},
		// 			Type: to.Ptr("Microsoft.StorSimple/managers/devices/metricsDefinitions"),
		// 			Category: to.Ptr("NetworkThroughput"),
		// 			Dimensions: []*armstorsimple8000series.MetricDimension{
		// 				{
		// 					Name: to.Ptr("NetworkInterface"),
		// 					Value: to.Ptr("data0"),
		// 			}},
		// 			MetricAvailabilities: []*armstorsimple8000series.MetricAvailablity{
		// 				{
		// 					Retention: to.Ptr("P1D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P7D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P3M"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P1Y"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armstorsimple8000series.MetricAggregationTypeAverage),
		// 			ResourceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			Unit: to.Ptr(armstorsimple8000series.MetricUnitBytesPerSecond),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesScanForUpdates.json
func ExampleDevicesClient_BeginScanForUpdates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginScanForUpdates(ctx, "sugattdeviceforSDK", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesGetUpdateSummary.json
func ExampleDevicesClient_GetUpdateSummary() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDevicesClient().GetUpdateSummary(ctx, "sugattdeviceforSDK", "ResourceGroupForSDKTest", "ManagerForSDKTest1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Updates = armstorsimple8000series.Updates{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.StorSimple/managers/devices/updateSummary"),
	// 	ID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/sugattdeviceforSDK/updateSummary/default"),
	// 	Kind: to.Ptr("Series8000"),
	// 	Properties: &armstorsimple8000series.UpdatesProperties{
	// 		IsUpdateInProgress: to.Ptr(false),
	// 		LastUpdatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-14T09:07:39.184Z"); return t}()),
	// 		MaintenanceModeUpdatesAvailable: to.Ptr(false),
	// 		RegularUpdatesAvailable: to.Ptr(true),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesFailover.json
func ExampleDevicesClient_BeginFailover() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDevicesClient().BeginFailover(ctx, "Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", armstorsimple8000series.FailoverRequest{
		TargetDeviceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/jemdeviceforsdk"),
		VolumeContainers: []*string{
			to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcforsdktest")},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/storsimple8000series/resource-manager/Microsoft.StorSimple/stable/2017-06-01/examples/DevicesListFailoverTargets.json
func ExampleDevicesClient_NewListFailoverTargetsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstorsimple8000series.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDevicesClient().NewListFailoverTargetsPager("Device05ForSDKTest", "ResourceGroupForSDKTest", "ManagerForSDKTest1", armstorsimple8000series.ListFailoverTargetsRequest{
		VolumeContainers: []*string{
			to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest/volumeContainers/vcforsdktest")},
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FailoverTargetsList = armstorsimple8000series.FailoverTargetsList{
		// 	Value: []*armstorsimple8000series.FailoverTarget{
		// 		{
		// 			AvailableLocalStorageInBytes: to.Ptr[int64](43980464128),
		// 			AvailableTieredStorageInBytes: to.Ptr[int64](1099511627776),
		// 			DataContainersCount: to.Ptr[int32](0),
		// 			DeviceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/sugattdeviceforSDK"),
		// 			DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
		// 			DeviceStatus: to.Ptr(armstorsimple8000series.DeviceStatusOffline),
		// 			EligibilityResult: &armstorsimple8000series.TargetEligibilityResult{
		// 				EligibilityStatus: to.Ptr(armstorsimple8000series.TargetEligibilityStatusNotEligible),
		// 				Messages: []*armstorsimple8000series.TargetEligibilityErrorMessage{
		// 					{
		// 						Message: to.Ptr("The selected target device is in 'Offline' state. The device configuration status is 'True'. Only online devices with the configuration status as complete can be failed over."),
		// 						Resolution: to.Ptr("Ensure that the specified target device is online and the device configuration is complete before you try the device failover."),
		// 						ResultCode: to.Ptr(armstorsimple8000series.TargetEligibilityResultCodeTargetIsNotOnlineError),
		// 				}},
		// 			},
		// 			FriendlyDeviceSoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
		// 			VolumesCount: to.Ptr[int32](0),
		// 		},
		// 		{
		// 			AvailableLocalStorageInBytes: to.Ptr[int64](43980464128),
		// 			AvailableTieredStorageInBytes: to.Ptr[int64](1099511627776),
		// 			DataContainersCount: to.Ptr[int32](0),
		// 			DeviceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/jemdeviceforsdk"),
		// 			DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
		// 			DeviceStatus: to.Ptr(armstorsimple8000series.DeviceStatusOnline),
		// 			EligibilityResult: &armstorsimple8000series.TargetEligibilityResult{
		// 				EligibilityStatus: to.Ptr(armstorsimple8000series.TargetEligibilityStatusEligible),
		// 			},
		// 			FriendlyDeviceSoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
		// 			VolumesCount: to.Ptr[int32](0),
		// 		},
		// 		{
		// 			AvailableLocalStorageInBytes: to.Ptr[int64](40458590976),
		// 			AvailableTieredStorageInBytes: to.Ptr[int64](1011464798208),
		// 			DataContainersCount: to.Ptr[int32](2),
		// 			DeviceID: to.Ptr("/subscriptions/4385cf00-2d3a-425a-832f-f4285b1c9dce/resourceGroups/ResourceGroupForSDKTest/providers/Microsoft.StorSimple/managers/ManagerForSDKTest1/devices/Device05ForSDKTest"),
		// 			DeviceSoftwareVersion: to.Ptr("6.3.9600.17802"),
		// 			DeviceStatus: to.Ptr(armstorsimple8000series.DeviceStatusOnline),
		// 			EligibilityResult: &armstorsimple8000series.TargetEligibilityResult{
		// 				EligibilityStatus: to.Ptr(armstorsimple8000series.TargetEligibilityStatusNotEligible),
		// 				Messages: []*armstorsimple8000series.TargetEligibilityErrorMessage{
		// 					{
		// 						Message: to.Ptr("The specified target device is the same as the source device. This is not supported. "),
		// 						Resolution: to.Ptr("Select a different target device and then retry the failover. "),
		// 						ResultCode: to.Ptr(armstorsimple8000series.TargetEligibilityResultCodeTargetAndSourceCannotBeSameError),
		// 				}},
		// 			},
		// 			FriendlyDeviceSoftwareVersion: to.Ptr("StorSimple 8000 Series Update 4.0"),
		// 			VolumesCount: to.Ptr[int32](7),
		// 	}},
		// }
	}
}
