% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunable.R
\name{tunable}
\alias{tunable}
\title{Declare tunable parameters}
\usage{
tunable(x, ...)
}
\arguments{
\item{x}{An object, such as a recipe, recipe step, workflow, or model
specification.}

\item{...}{Other arguments passed to methods}
}
\value{
A tibble with a column for the parameter \code{name}, information on the
\emph{default} method for generating a corresponding parameter object, the
\code{source} of the parameter (e.g. "recipe", etc.), and the \code{component} within
the source. For the \code{component} column, a little more specificity is given
about the location of the parameter (e.g. "step_normalize" for recipes or
"boost_tree" for models). The \code{component_id} column contains the unique step
\code{id} field or, for models, a logical for whether the model specification
argument was a main parameter or one associated with the engine.
}
\description{
Returns information on potential hyper-parameters that can be optimized.
}
\details{
For a model specification, an engine must be chosen.

If the object has no tunable parameters, a tibble with no rows is returned.

The information about the default parameter object takes the form of a
named list with an element for the function call and an optional element for
the source of the function (e.g. the \code{dials} package). For model
specifications, If the parameter is unknown to the underlying \code{tunable}
method, a \code{NULL} is returned.
}
\section{Methods}{

\Sexpr[stage=render,results=rd]{generics:::methods_rd("tunable")}
}

