% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown-escaping.R
\name{escape_rd_for_md}
\alias{escape_rd_for_md}
\alias{unescape_rd_for_md}
\title{Escape Rd markup, to avoid interpreting it as markdown}
\usage{
escape_rd_for_md(text)

unescape_rd_for_md(rd_text, esc_text)
}
\arguments{
\item{text}{Input text. Potentially contains Rd and/or
markdown markup.}

\item{rd_text}{The markdown parsed and interpreted text.}

\item{esc_text}{The original escaped text from
\code{escape_rd_for_md()}.}
}
\value{
For \code{escape_rd_for_md}:
A \dQuote{safe} version of the input text, where
each fragile Rd tag is replaced by a placeholder. The
original text is added as an attribute for each placeholder.

For \code{unescape_rd_for_md}: Rd text.
}
\description{
This is needed, if we want to stay compatible with
existing markup, even if markdown mode is switched on.
Fragile Rd tags (tags that may contain markup that
can be picked up by the markdown parser), are replaced
by placeholders. After the markdown to Rd conversion
is done, the original text is put back in place of the
placeholders.

It puts back the protected fragile Rd commands into
the text after the markdown parsing.
}
\details{
The list of protected Rd tags is in \code{escaped_for_md}.

Some Rd macros are treated specially:
\itemize{
\item For \code{if}, markdown is only allowed in the second argument.
\item For \code{ifelse} markdown is allowed in the second and third arguments.
}

See also \code{roclet-rd.R} for the list of tags that
uses the markdown-enabled parser. Some tags, e.g.
\verb{@aliases}, \verb{@backref}, etc. only use the
standard Roxygen parser.
}
\keyword{internal}
