/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "ResetFrame.h"

// CamiTK includes
#include <Component.h>
#include <TransformationManager.h>
#include <Log.h>

using namespace camitk;

// -------------------- init --------------------
void ResetFrame::init() {
}

// -------------------- process --------------------
Action::ApplyStatus ResetFrame::process() {

    // Process each targets
    for (Component* selected : getTargets()) {
        selected->resetFrame();
    }
    refreshApplication();
    return SUCCESS;
}

// -------------------- targetDefined --------------------
void ResetFrame::targetDefined() {
}

// -------------------- parameterChanged --------------------
void ResetFrame::parameterChanged(QString parameterName) {
}

