# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ApprovalActionRequest(_Model):
    """Request body for calling post-action.

    :ivar approval_status: Approval status indicating 'Approved' or 'Rejected'. Required. Is one of
     the following types: Literal["Approved"], Literal["Rejected"], str
    :vartype approval_status: str or str or str
    """

    approval_status: Union[Literal["Approved"], Literal["Rejected"], str] = rest_field(
        name="approvalStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval status indicating 'Approved' or 'Rejected'. Required. Is one of the following types:
     Literal[\"Approved\"], Literal[\"Rejected\"], str"""

    @overload
    def __init__(
        self,
        *,
        approval_status: Union[Literal["Approved"], Literal["Rejected"], str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalActionResponse(_Model):
    """Response body after handling of approvalCallbackRequest.

    :ivar message: Confirmation message indicating the result of the operation. Required.
    :vartype message: str
    """

    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confirmation message indicating the result of the operation. Required."""

    @overload
    def __init__(
        self,
        *,
        message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalCallbackRequest(_Model):
    """Request body for calling post-action.

    :ivar resource_request_action: Resource request action indicating action which needed to be
     performed upon calling approval-callback post action. Required. Is one of the following types:
     Literal["Create"], Literal["Delete"], Literal["Update"], Literal["Reset"], str
    :vartype resource_request_action: str or str or str or str or str
    :ivar approval_status: Approval status indicating 'Approved' or 'Rejected'. Required. Is one of
     the following types: Literal["Approved"], Literal["Rejected"], str
    :vartype approval_status: str or str or str
    :ivar approval_callback_payload: Payload requested by client upon approval action.
    :vartype approval_callback_payload: str
    """

    resource_request_action: Union[Literal["Create"], Literal["Delete"], Literal["Update"], Literal["Reset"], str] = (
        rest_field(name="resourceRequestAction", visibility=["read", "create", "update", "delete", "query"])
    )
    """Resource request action indicating action which needed to be performed upon calling
     approval-callback post action. Required. Is one of the following types: Literal[\"Create\"],
     Literal[\"Delete\"], Literal[\"Update\"], Literal[\"Reset\"], str"""
    approval_status: Union[Literal["Approved"], Literal["Rejected"], str] = rest_field(
        name="approvalStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval status indicating 'Approved' or 'Rejected'. Required. Is one of the following types:
     Literal[\"Approved\"], Literal[\"Rejected\"], str"""
    approval_callback_payload: Optional[str] = rest_field(
        name="approvalCallbackPayload", visibility=["read", "create", "update", "delete", "query"]
    )
    """Payload requested by client upon approval action."""

    @overload
    def __init__(
        self,
        *,
        resource_request_action: Union[Literal["Create"], Literal["Delete"], Literal["Update"], Literal["Reset"], str],
        approval_status: Union[Literal["Approved"], Literal["Rejected"], str],
        approval_callback_payload: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalDeletionCallbackRequest(_Model):
    """Request body for calling post-action.

    :ivar resource_request_action: Resource request action indicating action which needed to be
     performed upon calling approval-deletion-callback post action. Required. Is one of the
     following types: Literal["Create"], Literal["Delete"], Literal["Update"], str
    :vartype resource_request_action: str or str or str or str
    """

    resource_request_action: Union[Literal["Create"], Literal["Delete"], Literal["Update"], str] = rest_field(
        name="resourceRequestAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource request action indicating action which needed to be performed upon calling
     approval-deletion-callback post action. Required. Is one of the following types:
     Literal[\"Create\"], Literal[\"Delete\"], Literal[\"Update\"], str"""

    @overload
    def __init__(
        self,
        *,
        resource_request_action: Union[Literal["Create"], Literal["Delete"], Literal["Update"], str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalPatchModel(_Model):
    """Approvals patch model.

    :ivar properties: Approval Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.ApprovalPatchProperties
    """

    properties: Optional["_models.ApprovalPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval Patch properties."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApprovalPatchProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalPatchProperties(_Model):
    """Approvals patch properties.

    :ivar parent_resource_id: Parameter for optimizing query results.
    :vartype parent_resource_id: str
    :ivar grandparent_resource_id: Parameter for optimizing query results.
    :vartype grandparent_resource_id: str
    :ivar approvers: List of approvers for the approval request.
    :vartype approvers: list[~azure.mgmt.virtualenclaves.models.Approver]
    :ivar ticket_id: Ticket ID for the approval request.
    :vartype ticket_id: str
    :ivar created_at: Approval request creation time.
    :vartype created_at: ~datetime.datetime
    :ivar state_changed_at: Approval request state change time, time at which approval request
     state changed from pending to approved or rejected.
    :vartype state_changed_at: ~datetime.datetime
    :ivar request_metadata: Request metadata for the approval request. Required.
    :vartype request_metadata:
     ~azure.mgmt.virtualenclaves.models.RequestMetadataUpdatableProperties
    """

    parent_resource_id: Optional[str] = rest_field(
        name="parentResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter for optimizing query results."""
    grandparent_resource_id: Optional[str] = rest_field(
        name="grandparentResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter for optimizing query results."""
    approvers: Optional[list["_models.Approver"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of approvers for the approval request."""
    ticket_id: Optional[str] = rest_field(name="ticketId", visibility=["read", "create", "update", "delete", "query"])
    """Ticket ID for the approval request."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Approval request creation time."""
    state_changed_at: Optional[datetime.datetime] = rest_field(
        name="stateChangedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Approval request state change time, time at which approval request state changed from pending
     to approved or rejected."""
    request_metadata: "_models.RequestMetadataUpdatableProperties" = rest_field(
        name="requestMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """Request metadata for the approval request. Required."""

    @overload
    def __init__(
        self,
        *,
        request_metadata: "_models.RequestMetadataUpdatableProperties",
        parent_resource_id: Optional[str] = None,
        grandparent_resource_id: Optional[str] = None,
        approvers: Optional[list["_models.Approver"]] = None,
        ticket_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        state_changed_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalProperties(_Model):
    """Approval Base model.

    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    :ivar parent_resource_id: Parameter for optimizing query results.
    :vartype parent_resource_id: str
    :ivar grandparent_resource_id: Parameter for optimizing query results.
    :vartype grandparent_resource_id: str
    :ivar approvers: List of approvers for the approval request.
    :vartype approvers: list[~azure.mgmt.virtualenclaves.models.Approver]
    :ivar ticket_id: Ticket ID for the approval request.
    :vartype ticket_id: str
    :ivar created_at: Approval request creation time.
    :vartype created_at: ~datetime.datetime
    :ivar state_changed_at: Approval request state change time, time at which approval request
     state changed from pending to approved or rejected.
    :vartype state_changed_at: ~datetime.datetime
    :ivar request_metadata: Request metadata for the approval request. Required.
    :vartype request_metadata: ~azure.mgmt.virtualenclaves.models.RequestMetadata
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""
    parent_resource_id: Optional[str] = rest_field(
        name="parentResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter for optimizing query results."""
    grandparent_resource_id: Optional[str] = rest_field(
        name="grandparentResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameter for optimizing query results."""
    approvers: Optional[list["_models.Approver"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of approvers for the approval request."""
    ticket_id: Optional[str] = rest_field(name="ticketId", visibility=["read", "create", "update", "delete", "query"])
    """Ticket ID for the approval request."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Approval request creation time."""
    state_changed_at: Optional[datetime.datetime] = rest_field(
        name="stateChangedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Approval request state change time, time at which approval request state changed from pending
     to approved or rejected."""
    request_metadata: "_models.RequestMetadata" = rest_field(
        name="requestMetadata", visibility=["read", "create", "update", "delete", "query"]
    )
    """Request metadata for the approval request. Required."""

    @overload
    def __init__(
        self,
        *,
        request_metadata: "_models.RequestMetadata",
        parent_resource_id: Optional[str] = None,
        grandparent_resource_id: Optional[str] = None,
        approvers: Optional[list["_models.Approver"]] = None,
        ticket_id: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        state_changed_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ExtensionResource(Resource):
    """The base extension resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    """


class ApprovalResource(ExtensionResource):
    """Approval Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.ApprovalProperties
    """

    properties: Optional["_models.ApprovalProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApprovalProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalSettings(_Model):
    """ApprovalSettings Properties.

    :ivar endpoint_creation: Approval required for endpoint creation (Required or NotRequired).
     Known values are: "Required" and "NotRequired".
    :vartype endpoint_creation: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar endpoint_update: Approval required for endpoint update (Required or NotRequired). Known
     values are: "Required" and "NotRequired".
    :vartype endpoint_update: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar endpoint_deletion: Approval required for endpoint deletion (Required or NotRequired).
     Known values are: "Required" and "NotRequired".
    :vartype endpoint_deletion: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar connection_creation: Approval required for enclave connection creation (Required or
     NotRequired). Known values are: "Required" and "NotRequired".
    :vartype connection_creation: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar connection_update: Approval required for enclave connection update (Required or
     NotRequired). Known values are: "Required" and "NotRequired".
    :vartype connection_update: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar connection_deletion: Approval required for enclave connection deletion (Required or
     NotRequired). Known values are: "Required" and "NotRequired".
    :vartype connection_deletion: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar enclave_creation: Approval required for virtual enclave creation (Required or
     NotRequired). Known values are: "Required" and "NotRequired".
    :vartype enclave_creation: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar enclave_deletion: Approval required for virtual enclave deletion (Required or
     NotRequired). Known values are: "Required" and "NotRequired".
    :vartype enclave_deletion: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar maintenance_mode: Approval required for toggling maintenance mode (Required or
     NotRequired). Known values are: "Required" and "NotRequired".
    :vartype maintenance_mode: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar service_catalog_deployment: Approval required for deploying service catalog templates
     (Required or NotRequired). Known values are: "Required" and "NotRequired".
    :vartype service_catalog_deployment: str or ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar notification_on_approval_creation: Notification will be sent on creation of an Approval
     Request. Known values are: "Required" and "NotRequired".
    :vartype notification_on_approval_creation: str or
     ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar notification_on_approval_action: Notification will be sent on any action taken
     (Approve/Reject) on an Approval Request. Known values are: "Required" and "NotRequired".
    :vartype notification_on_approval_action: str or
     ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar notification_on_approval_deletion: Notification will be sent on deletion of an Approval
     Request. Known values are: "Required" and "NotRequired".
    :vartype notification_on_approval_deletion: str or
     ~azure.mgmt.virtualenclaves.models.ApprovalPolicy
    :ivar mandatory_approvers: List of mandatory approvers for the approval request.
    :vartype mandatory_approvers: list[~azure.mgmt.virtualenclaves.models.MandatoryApprover]
    :ivar minimum_approvers_required: Minimum number of approvers required for the approval
     request.
    :vartype minimum_approvers_required: int
    """

    endpoint_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="endpointCreation", visibility=["read", "create"]
    )
    """Approval required for endpoint creation (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    endpoint_update: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="endpointUpdate", visibility=["read", "create"]
    )
    """Approval required for endpoint update (Required or NotRequired). Known values are: \"Required\"
     and \"NotRequired\"."""
    endpoint_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="endpointDeletion", visibility=["read", "create"]
    )
    """Approval required for endpoint deletion (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    connection_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="connectionCreation", visibility=["read", "create"]
    )
    """Approval required for enclave connection creation (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    connection_update: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="connectionUpdate", visibility=["read", "create"]
    )
    """Approval required for enclave connection update (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    connection_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="connectionDeletion", visibility=["read", "create"]
    )
    """Approval required for enclave connection deletion (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    enclave_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="enclaveCreation", visibility=["read", "create"]
    )
    """Approval required for virtual enclave creation (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    enclave_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="enclaveDeletion", visibility=["read", "create"]
    )
    """Approval required for virtual enclave deletion (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    maintenance_mode: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="maintenanceMode", visibility=["read", "create"]
    )
    """Approval required for toggling maintenance mode (Required or NotRequired). Known values are:
     \"Required\" and \"NotRequired\"."""
    service_catalog_deployment: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="serviceCatalogDeployment", visibility=["read", "create"]
    )
    """Approval required for deploying service catalog templates (Required or NotRequired). Known
     values are: \"Required\" and \"NotRequired\"."""
    notification_on_approval_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="notificationOnApprovalCreation", visibility=["read", "create"]
    )
    """Notification will be sent on creation of an Approval Request. Known values are: \"Required\"
     and \"NotRequired\"."""
    notification_on_approval_action: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="notificationOnApprovalAction", visibility=["read", "create"]
    )
    """Notification will be sent on any action taken (Approve/Reject) on an Approval Request. Known
     values are: \"Required\" and \"NotRequired\"."""
    notification_on_approval_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = rest_field(
        name="notificationOnApprovalDeletion", visibility=["read", "create"]
    )
    """Notification will be sent on deletion of an Approval Request. Known values are: \"Required\"
     and \"NotRequired\"."""
    mandatory_approvers: Optional[list["_models.MandatoryApprover"]] = rest_field(
        name="mandatoryApprovers", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of mandatory approvers for the approval request."""
    minimum_approvers_required: Optional[int] = rest_field(
        name="minimumApproversRequired", visibility=["read", "create"]
    )
    """Minimum number of approvers required for the approval request."""

    @overload
    def __init__(
        self,
        *,
        endpoint_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        endpoint_update: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        endpoint_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        connection_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        connection_update: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        connection_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        enclave_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        enclave_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        maintenance_mode: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        service_catalog_deployment: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        notification_on_approval_creation: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        notification_on_approval_action: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        notification_on_approval_deletion: Optional[Union[str, "_models.ApprovalPolicy"]] = None,
        mandatory_approvers: Optional[list["_models.MandatoryApprover"]] = None,
        minimum_approvers_required: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApprovalSettingsPatchProperties(_Model):
    """ApprovalSettings Properties.

    :ivar mandatory_approvers: List of mandatory approvers for the approval request.
    :vartype mandatory_approvers: list[~azure.mgmt.virtualenclaves.models.MandatoryApprover]
    """

    mandatory_approvers: Optional[list["_models.MandatoryApprover"]] = rest_field(
        name="mandatoryApprovers", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of mandatory approvers for the approval request."""

    @overload
    def __init__(
        self,
        *,
        mandatory_approvers: Optional[list["_models.MandatoryApprover"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Approver(_Model):
    """Approver Metadata for approvals request.

    :ivar approver_entra_id: Entra ObjectID of the approver. Required.
    :vartype approver_entra_id: str
    :ivar action_performed: Action Performed by approver. Known values are: "Approved" and
     "Rejected".
    :vartype action_performed: str or ~azure.mgmt.virtualenclaves.models.ActionPerformed
    :ivar last_updated_at: approval request last updated at. Required.
    :vartype last_updated_at: ~datetime.datetime
    """

    approver_entra_id: str = rest_field(
        name="approverEntraId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Entra ObjectID of the approver. Required."""
    action_performed: Optional[Union[str, "_models.ActionPerformed"]] = rest_field(
        name="actionPerformed", visibility=["read", "create", "update", "delete", "query"]
    )
    """Action Performed by approver. Known values are: \"Approved\" and \"Rejected\"."""
    last_updated_at: datetime.datetime = rest_field(
        name="lastUpdatedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """approval request last updated at. Required."""

    @overload
    def __init__(
        self,
        *,
        approver_entra_id: str,
        last_updated_at: datetime.datetime,
        action_performed: Optional[Union[str, "_models.ActionPerformed"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckAddressSpaceAvailabilityRequest(_Model):
    """Request to the action call to check address space availability.

    :ivar community_resource_id: Resource Id of the Community. Required.
    :vartype community_resource_id: str
    :ivar enclave_virtual_network: Information about the enclave virtual network. Required.
    :vartype enclave_virtual_network: ~azure.mgmt.virtualenclaves.models.EnclaveVirtualNetworkModel
    """

    community_resource_id: str = rest_field(
        name="communityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource Id of the Community. Required."""
    enclave_virtual_network: "_models.EnclaveVirtualNetworkModel" = rest_field(
        name="enclaveVirtualNetwork", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the enclave virtual network. Required."""

    @overload
    def __init__(
        self,
        *,
        community_resource_id: str,
        enclave_virtual_network: "_models.EnclaveVirtualNetworkModel",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckAddressSpaceAvailabilityResponse(_Model):
    """Response of availability of the requested address space.

    :ivar value: Boolean representing whether the address space is available. Required.
    :vartype value: bool
    """

    value: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Boolean representing whether the address space is available. Required."""

    @overload
    def __init__(
        self,
        *,
        value: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityEndpointDestinationRule(_Model):
    """Base type for destination rules.

    :ivar destination_type: Destination Type. Known values are: "FQDN", "FQDNTag", "IPAddress", and
     "PrivateNetwork".
    :vartype destination_type: str or ~azure.mgmt.virtualenclaves.models.DestinationType
    :ivar protocols: Protocols. Options specified by Endpoint Protocol Enum.
    :vartype protocols: list[str or ~azure.mgmt.virtualenclaves.models.CommunityEndpointProtocol]
    :ivar transit_hub_resource_id: Transit Hub Resource Id.
    :vartype transit_hub_resource_id: str
    :ivar endpoint_rule_name: Endpoint Rule Name.
    :vartype endpoint_rule_name: str
    :ivar destination: Destination address. Can include multiple CIDR/IP Addresses or fqdn tags or
     fqdns (for community endpoint) separated by commas.
    :vartype destination: str
    :ivar ports: Port. Can include multiple ports separated by commas or a range indicated by a
     hyphen.
    :vartype ports: str
    """

    destination_type: Optional[Union[str, "_models.DestinationType"]] = rest_field(
        name="destinationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Destination Type. Known values are: \"FQDN\", \"FQDNTag\", \"IPAddress\", and
     \"PrivateNetwork\"."""
    protocols: Optional[list[Union[str, "_models.CommunityEndpointProtocol"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Protocols. Options specified by Endpoint Protocol Enum."""
    transit_hub_resource_id: Optional[str] = rest_field(
        name="transitHubResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Transit Hub Resource Id."""
    endpoint_rule_name: Optional[str] = rest_field(
        name="endpointRuleName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Endpoint Rule Name."""
    destination: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Destination address. Can include multiple CIDR/IP Addresses or fqdn tags or fqdns (for
     community endpoint) separated by commas."""
    ports: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Port. Can include multiple ports separated by commas or a range indicated by a hyphen."""

    @overload
    def __init__(
        self,
        *,
        destination_type: Optional[Union[str, "_models.DestinationType"]] = None,
        protocols: Optional[list[Union[str, "_models.CommunityEndpointProtocol"]]] = None,
        transit_hub_resource_id: Optional[str] = None,
        endpoint_rule_name: Optional[str] = None,
        destination: Optional[str] = None,
        ports: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityEndpointPatchModel(_Model):
    """Community Endpoint Patch Resource.

    :ivar properties: Community Endpoint Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.CommunityEndpointPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.CommunityEndpointPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Community Endpoint Patch properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CommunityEndpointPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityEndpointPatchProperties(_Model):
    """Community Endpoint patchable Properties.

    :ivar rule_collection: Community Endpoint Rule Collection. Required.
    :vartype rule_collection:
     list[~azure.mgmt.virtualenclaves.models.CommunityEndpointDestinationRule]
    """

    rule_collection: list["_models.CommunityEndpointDestinationRule"] = rest_field(
        name="ruleCollection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Community Endpoint Rule Collection. Required."""

    @overload
    def __init__(
        self,
        *,
        rule_collection: list["_models.CommunityEndpointDestinationRule"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityEndpointProperties(_Model):
    """Community Endpoint Resource properties.

    :ivar rule_collection: Community Endpoint Rule Collection. Required.
    :vartype rule_collection:
     list[~azure.mgmt.virtualenclaves.models.CommunityEndpointDestinationRule]
    :ivar resource_collection: List of resource ids created by community endpoint.
    :vartype resource_collection: list[str]
    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    """

    rule_collection: list["_models.CommunityEndpointDestinationRule"] = rest_field(
        name="ruleCollection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Community Endpoint Rule Collection. Required."""
    resource_collection: Optional[list[str]] = rest_field(name="resourceCollection", visibility=["read"])
    """List of resource ids created by community endpoint."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        rule_collection: list["_models.CommunityEndpointDestinationRule"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityEndpointResource(TrackedResource):
    """CommunityEndpoint Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.CommunityEndpointProperties
    """

    properties: Optional["_models.CommunityEndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CommunityEndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityPatchModel(_Model):
    """Community Patch Resource.

    :ivar properties: Community Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.CommunityPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.virtualenclaves.models.ManagedServiceIdentity
    """

    properties: Optional["_models.CommunityPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Community Patch properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CommunityPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityPatchProperties(_Model):
    """Community Resource Properties without default values.

    :ivar dns_servers: DNS Servers.
    :vartype dns_servers: list[str]
    :ivar governed_service_list: List of services governed by a community.
    :vartype governed_service_list: list[~azure.mgmt.virtualenclaves.models.GovernedServiceItem]
    :ivar policy_override: Policy override setting for the community. Specifies whether to apply
     enclave-specific policies or disable policy enforcement. Is one of the following types:
     Literal["Enclave"], Literal["None"], str
    :vartype policy_override: str or str or str
    :ivar community_role_assignments: Community role assignments.
    :vartype community_role_assignments:
     list[~azure.mgmt.virtualenclaves.models.RoleAssignmentItem]
    :ivar firewall_sku: SKU of the community's Azure Firewall (Basic, Standard, Premium). Standard
     is the default. Known values are: "Basic", "Standard", and "Premium".
    :vartype firewall_sku: str or ~azure.mgmt.virtualenclaves.models.FirewallSKU
    :ivar approval_settings: Approval requirements for various actions on the community's
     resources.
    :vartype approval_settings: ~azure.mgmt.virtualenclaves.models.ApprovalSettingsPatchProperties
    :ivar maintenance_mode_configuration: Maintenance Mode configuration.
    :vartype maintenance_mode_configuration:
     ~azure.mgmt.virtualenclaves.models.MaintenanceModeConfigurationPatchModel
    """

    dns_servers: Optional[list[str]] = rest_field(
        name="dnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS Servers."""
    governed_service_list: Optional[list["_models.GovernedServiceItem"]] = rest_field(
        name="governedServiceList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of services governed by a community."""
    policy_override: Optional[Union[Literal["Enclave"], Literal["None"], str]] = rest_field(
        name="policyOverride", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy override setting for the community. Specifies whether to apply enclave-specific policies
     or disable policy enforcement. Is one of the following types: Literal[\"Enclave\"],
     Literal[\"None\"], str"""
    community_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = rest_field(
        name="communityRoleAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Community role assignments."""
    firewall_sku: Optional[Union[str, "_models.FirewallSKU"]] = rest_field(
        name="firewallSku", visibility=["read", "create", "update", "delete", "query"]
    )
    """SKU of the community's Azure Firewall (Basic, Standard, Premium). Standard is the default.
     Known values are: \"Basic\", \"Standard\", and \"Premium\"."""
    approval_settings: Optional["_models.ApprovalSettingsPatchProperties"] = rest_field(
        name="approvalSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval requirements for various actions on the community's resources."""
    maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationPatchModel"] = rest_field(
        name="maintenanceModeConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maintenance Mode configuration."""

    @overload
    def __init__(
        self,
        *,
        dns_servers: Optional[list[str]] = None,
        governed_service_list: Optional[list["_models.GovernedServiceItem"]] = None,
        policy_override: Optional[Union[Literal["Enclave"], Literal["None"], str]] = None,
        community_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = None,
        firewall_sku: Optional[Union[str, "_models.FirewallSKU"]] = None,
        approval_settings: Optional["_models.ApprovalSettingsPatchProperties"] = None,
        maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationPatchModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityProperties(_Model):
    """Community Resource Properties.

    :ivar address_space: Address Space.
    :vartype address_space: str
    :ivar dns_servers: DNS Servers.
    :vartype dns_servers: list[str]
    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    :ivar resource_collection: List of resource ids created by communities.
    :vartype resource_collection: list[str]
    :ivar managed_resource_group_name: Managed resource group name.
    :vartype managed_resource_group_name: str
    :ivar managed_on_behalf_of_configuration: Managed On Behalf Of Configuration.
    :vartype managed_on_behalf_of_configuration:
     ~azure.mgmt.virtualenclaves.models.ManagedOnBehalfOfConfiguration
    :ivar governed_service_list: List of services governed by a community.
    :vartype governed_service_list: list[~azure.mgmt.virtualenclaves.models.GovernedServiceItem]
    :ivar policy_override: Policy override setting for the community. Specifies whether to apply
     enclave-specific policies or disable policy enforcement. Is one of the following types:
     Literal["Enclave"], Literal["None"], str
    :vartype policy_override: str or str or str
    :ivar community_role_assignments: Community role assignments.
    :vartype community_role_assignments:
     list[~azure.mgmt.virtualenclaves.models.RoleAssignmentItem]
    :ivar firewall_sku: SKU of the community's Azure Firewall (Basic, Standard, Premium). Standard
     is the default. Known values are: "Basic", "Standard", and "Premium".
    :vartype firewall_sku: str or ~azure.mgmt.virtualenclaves.models.FirewallSKU
    :ivar approval_settings: Approval requirements for various actions on the community's
     resources.
    :vartype approval_settings: ~azure.mgmt.virtualenclaves.models.ApprovalSettings
    :ivar maintenance_mode_configuration: Maintenance Mode configuration.
    :vartype maintenance_mode_configuration:
     ~azure.mgmt.virtualenclaves.models.MaintenanceModeConfigurationModel
    """

    address_space: Optional[str] = rest_field(name="addressSpace", visibility=["read", "create"])
    """Address Space."""
    dns_servers: Optional[list[str]] = rest_field(
        name="dnsServers", visibility=["read", "create", "update", "delete", "query"]
    )
    """DNS Servers."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""
    resource_collection: Optional[list[str]] = rest_field(name="resourceCollection", visibility=["read"])
    """List of resource ids created by communities."""
    managed_resource_group_name: Optional[str] = rest_field(name="managedResourceGroupName", visibility=["read"])
    """Managed resource group name."""
    managed_on_behalf_of_configuration: Optional["_models.ManagedOnBehalfOfConfiguration"] = rest_field(
        name="managedOnBehalfOfConfiguration", visibility=["read"]
    )
    """Managed On Behalf Of Configuration."""
    governed_service_list: Optional[list["_models.GovernedServiceItem"]] = rest_field(
        name="governedServiceList", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of services governed by a community."""
    policy_override: Optional[Union[Literal["Enclave"], Literal["None"], str]] = rest_field(
        name="policyOverride", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy override setting for the community. Specifies whether to apply enclave-specific policies
     or disable policy enforcement. Is one of the following types: Literal[\"Enclave\"],
     Literal[\"None\"], str"""
    community_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = rest_field(
        name="communityRoleAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Community role assignments."""
    firewall_sku: Optional[Union[str, "_models.FirewallSKU"]] = rest_field(
        name="firewallSku", visibility=["read", "create", "update", "delete", "query"]
    )
    """SKU of the community's Azure Firewall (Basic, Standard, Premium). Standard is the default.
     Known values are: \"Basic\", \"Standard\", and \"Premium\"."""
    approval_settings: Optional["_models.ApprovalSettings"] = rest_field(
        name="approvalSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Approval requirements for various actions on the community's resources."""
    maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationModel"] = rest_field(
        name="maintenanceModeConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maintenance Mode configuration."""

    @overload
    def __init__(
        self,
        *,
        address_space: Optional[str] = None,
        dns_servers: Optional[list[str]] = None,
        governed_service_list: Optional[list["_models.GovernedServiceItem"]] = None,
        policy_override: Optional[Union[Literal["Enclave"], Literal["None"], str]] = None,
        community_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = None,
        firewall_sku: Optional[Union[str, "_models.FirewallSKU"]] = None,
        approval_settings: Optional["_models.ApprovalSettings"] = None,
        maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CommunityResource(TrackedResource):
    """Community Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.CommunityProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.virtualenclaves.models.ManagedServiceIdentity
    """

    properties: Optional["_models.CommunityProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CommunityProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveAddressSpacesModel(_Model):
    """Enclave Address Spaces.

    :ivar enclave_address_space: Enclave Address Space.
    :vartype enclave_address_space: str
    :ivar managed_address_space: Managed Address Space.
    :vartype managed_address_space: str
    """

    enclave_address_space: Optional[str] = rest_field(
        name="enclaveAddressSpace", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave Address Space."""
    managed_address_space: Optional[str] = rest_field(
        name="managedAddressSpace", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed Address Space."""

    @overload
    def __init__(
        self,
        *,
        enclave_address_space: Optional[str] = None,
        managed_address_space: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveConnectionPatchModel(_Model):
    """Enclave Connection Patch Resource.

    :ivar properties: Enclave Connection Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.EnclaveConnectionPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.EnclaveConnectionPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave Connection Patch properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EnclaveConnectionPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveConnectionPatchProperties(_Model):
    """Enclave Connection patchable Properties.

    :ivar source_cidr: Source CIDR.
    :vartype source_cidr: str
    """

    source_cidr: Optional[str] = rest_field(
        name="sourceCidr", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source CIDR."""

    @overload
    def __init__(
        self,
        *,
        source_cidr: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveConnectionProperties(_Model):
    """Enclave Connection Resource properties.

    :ivar state: The state of the enclaveConnection. Known values are: "PendingApproval",
     "PendingUpdate", "Approved", "Active", "Failed", "Connected", and "Disconnected".
    :vartype state: str or ~azure.mgmt.virtualenclaves.models.EnclaveConnectionState
    :ivar community_resource_id: Community Resource Id. Required.
    :vartype community_resource_id: str
    :ivar source_resource_id: Source Resource Id. Required.
    :vartype source_resource_id: str
    :ivar source_cidr: Source CIDR.
    :vartype source_cidr: str
    :ivar destination_endpoint_id: Destination Endpoint Resource Id. Required.
    :vartype destination_endpoint_id: str
    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    :ivar resource_collection: List of resource ids modified by enclave Connections.
    :vartype resource_collection: list[str]
    """

    state: Optional[Union[str, "_models.EnclaveConnectionState"]] = rest_field(visibility=["read"])
    """The state of the enclaveConnection. Known values are: \"PendingApproval\", \"PendingUpdate\",
     \"Approved\", \"Active\", \"Failed\", \"Connected\", and \"Disconnected\"."""
    community_resource_id: str = rest_field(name="communityResourceId", visibility=["read", "create"])
    """Community Resource Id. Required."""
    source_resource_id: str = rest_field(name="sourceResourceId", visibility=["read", "create"])
    """Source Resource Id. Required."""
    source_cidr: Optional[str] = rest_field(
        name="sourceCidr", visibility=["read", "create", "update", "delete", "query"]
    )
    """Source CIDR."""
    destination_endpoint_id: str = rest_field(name="destinationEndpointId", visibility=["read", "create"])
    """Destination Endpoint Resource Id. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""
    resource_collection: Optional[list[str]] = rest_field(name="resourceCollection", visibility=["read"])
    """List of resource ids modified by enclave Connections."""

    @overload
    def __init__(
        self,
        *,
        community_resource_id: str,
        source_resource_id: str,
        destination_endpoint_id: str,
        source_cidr: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveConnectionResource(TrackedResource):
    """EnclaveConnection Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.EnclaveConnectionProperties
    """

    properties: Optional["_models.EnclaveConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EnclaveConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveDefaultSettingsModel(_Model):
    """Virtual Enclave Default Settings.

    :ivar key_vault_resource_id: Key Vault Resource Id.
    :vartype key_vault_resource_id: str
    :ivar storage_account_resource_id: Storage Account Resource Id.
    :vartype storage_account_resource_id: str
    :ivar log_analytics_resource_id_collection: Log Analytics Resource Ids.
    :vartype log_analytics_resource_id_collection: list[str]
    :ivar diagnostic_destination: Diagnostic Destination. Known values are: "CommunityOnly",
     "EnclaveOnly", and "Both".
    :vartype diagnostic_destination: str or
     ~azure.mgmt.virtualenclaves.models.DiagnosticDestination
    """

    key_vault_resource_id: Optional[str] = rest_field(name="keyVaultResourceId", visibility=["read"])
    """Key Vault Resource Id."""
    storage_account_resource_id: Optional[str] = rest_field(name="storageAccountResourceId", visibility=["read"])
    """Storage Account Resource Id."""
    log_analytics_resource_id_collection: Optional[list[str]] = rest_field(
        name="logAnalyticsResourceIdCollection", visibility=["read"]
    )
    """Log Analytics Resource Ids."""
    diagnostic_destination: Optional[Union[str, "_models.DiagnosticDestination"]] = rest_field(
        name="diagnosticDestination", visibility=["read", "create", "update", "delete", "query"]
    )
    """Diagnostic Destination. Known values are: \"CommunityOnly\", \"EnclaveOnly\", and \"Both\"."""

    @overload
    def __init__(
        self,
        *,
        diagnostic_destination: Optional[Union[str, "_models.DiagnosticDestination"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveDefaultSettingsPatchModel(_Model):
    """Virtual Enclave Default Settings.

    :ivar diagnostic_destination: Diagnostic Destination. Known values are: "CommunityOnly",
     "EnclaveOnly", and "Both".
    :vartype diagnostic_destination: str or
     ~azure.mgmt.virtualenclaves.models.DiagnosticDestination
    """

    diagnostic_destination: Optional[Union[str, "_models.DiagnosticDestination"]] = rest_field(
        name="diagnosticDestination", visibility=["read", "create", "update", "delete", "query"]
    )
    """Diagnostic Destination. Known values are: \"CommunityOnly\", \"EnclaveOnly\", and \"Both\"."""

    @overload
    def __init__(
        self,
        *,
        diagnostic_destination: Optional[Union[str, "_models.DiagnosticDestination"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveEndpointDestinationRule(_Model):
    """Enclave Endpoint Rule Properties.

    :ivar protocols: Protocols. Options specified by Endpoint Protocol Enum.
    :vartype protocols: list[str or ~azure.mgmt.virtualenclaves.models.EnclaveEndpointProtocol]
    :ivar endpoint_rule_name: Endpoint Rule Name.
    :vartype endpoint_rule_name: str
    :ivar destination: Destination address. Can include multiple CIDR/IP Addresses or fqdn tags or
     fqdns (for community endpoint) separated by commas.
    :vartype destination: str
    :ivar ports: Port. Can include multiple ports separated by commas or a range indicated by a
     hyphen.
    :vartype ports: str
    """

    protocols: Optional[list[Union[str, "_models.EnclaveEndpointProtocol"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Protocols. Options specified by Endpoint Protocol Enum."""
    endpoint_rule_name: Optional[str] = rest_field(
        name="endpointRuleName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Endpoint Rule Name."""
    destination: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Destination address. Can include multiple CIDR/IP Addresses or fqdn tags or fqdns (for
     community endpoint) separated by commas."""
    ports: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Port. Can include multiple ports separated by commas or a range indicated by a hyphen."""

    @overload
    def __init__(
        self,
        *,
        protocols: Optional[list[Union[str, "_models.EnclaveEndpointProtocol"]]] = None,
        endpoint_rule_name: Optional[str] = None,
        destination: Optional[str] = None,
        ports: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveEndpointPatchModel(_Model):
    """Enclave Endpoint Patch Resource.

    :ivar properties: Enclave Endpoint Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.EnclaveEndpointPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.EnclaveEndpointPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave Endpoint Patch properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.EnclaveEndpointPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveEndpointPatchProperties(_Model):
    """Enclave Endpoint patchable Properties.

    :ivar rule_collection: Enclave Endpoint Rule Collection. Required.
    :vartype rule_collection:
     list[~azure.mgmt.virtualenclaves.models.EnclaveEndpointDestinationRule]
    """

    rule_collection: list["_models.EnclaveEndpointDestinationRule"] = rest_field(
        name="ruleCollection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave Endpoint Rule Collection. Required."""

    @overload
    def __init__(
        self,
        *,
        rule_collection: list["_models.EnclaveEndpointDestinationRule"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveEndpointProperties(_Model):
    """Enclave Endpoint Resource properties.

    :ivar rule_collection: Enclave Endpoint Rule Collection. Required.
    :vartype rule_collection:
     list[~azure.mgmt.virtualenclaves.models.EnclaveEndpointDestinationRule]
    :ivar resource_collection: List of resource ids created by community endpoint.
    :vartype resource_collection: list[str]
    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    """

    rule_collection: list["_models.EnclaveEndpointDestinationRule"] = rest_field(
        name="ruleCollection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave Endpoint Rule Collection. Required."""
    resource_collection: Optional[list[str]] = rest_field(name="resourceCollection", visibility=["read"])
    """List of resource ids created by community endpoint."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""

    @overload
    def __init__(
        self,
        *,
        rule_collection: list["_models.EnclaveEndpointDestinationRule"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveEndpointResource(TrackedResource):
    """EnclaveEndpoint Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.EnclaveEndpointProperties
    """

    properties: Optional["_models.EnclaveEndpointProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.EnclaveEndpointProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveResource(TrackedResource):
    """Virtual Enclave Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.VirtualEnclaveProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.virtualenclaves.models.ManagedServiceIdentity
    """

    properties: Optional["_models.VirtualEnclaveProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.VirtualEnclaveProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnclaveVirtualNetworkModel(_Model):
    """Enclave Virtual Network Properties.

    :ivar network_name: Network Name.
    :vartype network_name: str
    :ivar network_size: Network Size.
    :vartype network_size: str
    :ivar custom_cidr_range: Custom CIDR Range.
    :vartype custom_cidr_range: str
    :ivar subnet_configurations: Subnet Configurations.
    :vartype subnet_configurations: list[~azure.mgmt.virtualenclaves.models.SubnetConfiguration]
    :ivar allow_subnet_communication: Allow Subnet Communication.
    :vartype allow_subnet_communication: bool
    """

    network_name: Optional[str] = rest_field(
        name="networkName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network Name."""
    network_size: Optional[str] = rest_field(name="networkSize", visibility=["read", "create"])
    """Network Size."""
    custom_cidr_range: Optional[str] = rest_field(name="customCidrRange", visibility=["read", "create"])
    """Custom CIDR Range."""
    subnet_configurations: Optional[list["_models.SubnetConfiguration"]] = rest_field(
        name="subnetConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Subnet Configurations."""
    allow_subnet_communication: Optional[bool] = rest_field(
        name="allowSubnetCommunication", visibility=["read", "create"]
    )
    """Allow Subnet Communication."""

    @overload
    def __init__(
        self,
        *,
        network_name: Optional[str] = None,
        network_size: Optional[str] = None,
        custom_cidr_range: Optional[str] = None,
        subnet_configurations: Optional[list["_models.SubnetConfiguration"]] = None,
        allow_subnet_communication: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.virtualenclaves.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.virtualenclaves.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.virtualenclaves.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GovernedServiceItem(_Model):
    """GovernedServiceItem Properties.

    :ivar service_id: Service ID. Required. Known values are: "AKS", "AppService",
     "AzureFirewalls", "ContainerRegistry", "CosmosDB", "DataConnectors", "Insights", "KeyVault",
     "Logic", "MicrosoftSQL", "Monitoring", "PostgreSQL", "PrivateDNSZones", "ServiceBus", and
     "Storage".
    :vartype service_id: str or ~azure.mgmt.virtualenclaves.models.ServiceIdentifier
    :ivar service_name: Service name.
    :vartype service_name: str
    :ivar option: Governance option for this service (Allow, Deny, ExceptionOnly, or
     NotApplicable). Is one of the following types: Literal["Allow"], Literal["Deny"],
     Literal["ExceptionOnly"], Literal["NotApplicable"], str
    :vartype option: str or str or str or str or str
    :ivar enforcement: Initiative enforcement (Enabled or Disabled). Is one of the following types:
     Literal["Enabled"], Literal["Disabled"], str
    :vartype enforcement: str or str or str
    :ivar policy_action: Enforcement mode for policy. AuditOnly, Enforce, or None. Is one of the
     following types: Literal["AuditOnly"], Literal["Enforce"], Literal["None"], str
    :vartype policy_action: str or str or str or str
    :ivar initiatives: Initiatives associated with this service.
    :vartype initiatives: list[str]
    """

    service_id: Union[str, "_models.ServiceIdentifier"] = rest_field(
        name="serviceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service ID. Required. Known values are: \"AKS\", \"AppService\", \"AzureFirewalls\",
     \"ContainerRegistry\", \"CosmosDB\", \"DataConnectors\", \"Insights\", \"KeyVault\", \"Logic\",
     \"MicrosoftSQL\", \"Monitoring\", \"PostgreSQL\", \"PrivateDNSZones\", \"ServiceBus\", and
     \"Storage\"."""
    service_name: Optional[str] = rest_field(name="serviceName", visibility=["read"])
    """Service name."""
    option: Optional[
        Union[Literal["Allow"], Literal["Deny"], Literal["ExceptionOnly"], Literal["NotApplicable"], str]
    ] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Governance option for this service (Allow, Deny, ExceptionOnly, or NotApplicable). Is one of
     the following types: Literal[\"Allow\"], Literal[\"Deny\"], Literal[\"ExceptionOnly\"],
     Literal[\"NotApplicable\"], str"""
    enforcement: Optional[Union[Literal["Enabled"], Literal["Disabled"], str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Initiative enforcement (Enabled or Disabled). Is one of the following types:
     Literal[\"Enabled\"], Literal[\"Disabled\"], str"""
    policy_action: Optional[Union[Literal["AuditOnly"], Literal["Enforce"], Literal["None"], str]] = rest_field(
        name="policyAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enforcement mode for policy. AuditOnly, Enforce, or None. Is one of the following types:
     Literal[\"AuditOnly\"], Literal[\"Enforce\"], Literal[\"None\"], str"""
    initiatives: Optional[list[str]] = rest_field(visibility=["read"])
    """Initiatives associated with this service."""

    @overload
    def __init__(
        self,
        *,
        service_id: Union[str, "_models.ServiceIdentifier"],
        option: Optional[
            Union[Literal["Allow"], Literal["Deny"], Literal["ExceptionOnly"], Literal["NotApplicable"], str]
        ] = None,
        enforcement: Optional[Union[Literal["Enabled"], Literal["Disabled"], str]] = None,
        policy_action: Optional[Union[Literal["AuditOnly"], Literal["Enforce"], Literal["None"], str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceModeConfigurationModel(_Model):
    """Maintenance Mode.

    :ivar mode: Current mode of Maintenance Mode Configuration. Required. Is one of the following
     types: Literal["On"], Literal["CanNotDelete"], Literal["Off"], Literal["General"],
     Literal["Advanced"], str
    :vartype mode: str or str or str or str or str or str
    :ivar principals: The user, group or service principal object affected by Maintenance Mode.
    :vartype principals: list[~azure.mgmt.virtualenclaves.models.Principal]
    :ivar justification: Justification for entering or exiting Maintenance Mode. Is one of the
     following types: Literal["Networking"], Literal["Governance"], Literal["Off"], str
    :vartype justification: str or str or str or str
    """

    mode: Union[
        Literal["On"], Literal["CanNotDelete"], Literal["Off"], Literal["General"], Literal["Advanced"], str
    ] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Current mode of Maintenance Mode Configuration. Required. Is one of the following types:
     Literal[\"On\"], Literal[\"CanNotDelete\"], Literal[\"Off\"], Literal[\"General\"],
     Literal[\"Advanced\"], str"""
    principals: Optional[list["_models.Principal"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The user, group or service principal object affected by Maintenance Mode."""
    justification: Optional[Union[Literal["Networking"], Literal["Governance"], Literal["Off"], str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Justification for entering or exiting Maintenance Mode. Is one of the following types:
     Literal[\"Networking\"], Literal[\"Governance\"], Literal[\"Off\"], str"""

    @overload
    def __init__(
        self,
        *,
        mode: Union[
            Literal["On"], Literal["CanNotDelete"], Literal["Off"], Literal["General"], Literal["Advanced"], str
        ],
        principals: Optional[list["_models.Principal"]] = None,
        justification: Optional[Union[Literal["Networking"], Literal["Governance"], Literal["Off"], str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MaintenanceModeConfigurationPatchModel(_Model):
    """Maintenance Mode Patch Model.

    :ivar mode: Current mode of Maintenance Mode Configuration. Required. Is one of the following
     types: Literal["On"], Literal["CanNotDelete"], Literal["Off"], Literal["General"],
     Literal["Advanced"], str
    :vartype mode: str or str or str or str or str or str
    :ivar principals: The user, group or service principal object affected by Maintenance Mode.
    :vartype principals: list[~azure.mgmt.virtualenclaves.models.Principal]
    :ivar justification: Justification for entering or exiting Maintenance Mode. Is one of the
     following types: Literal["Networking"], Literal["Governance"], Literal["Off"], str
    :vartype justification: str or str or str or str
    """

    mode: Union[
        Literal["On"], Literal["CanNotDelete"], Literal["Off"], Literal["General"], Literal["Advanced"], str
    ] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Current mode of Maintenance Mode Configuration. Required. Is one of the following types:
     Literal[\"On\"], Literal[\"CanNotDelete\"], Literal[\"Off\"], Literal[\"General\"],
     Literal[\"Advanced\"], str"""
    principals: Optional[list["_models.Principal"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The user, group or service principal object affected by Maintenance Mode."""
    justification: Optional[Union[Literal["Networking"], Literal["Governance"], Literal["Off"], str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Justification for entering or exiting Maintenance Mode. Is one of the following types:
     Literal[\"Networking\"], Literal[\"Governance\"], Literal[\"Off\"], str"""

    @overload
    def __init__(
        self,
        *,
        mode: Union[
            Literal["On"], Literal["CanNotDelete"], Literal["Off"], Literal["General"], Literal["Advanced"], str
        ],
        principals: Optional[list["_models.Principal"]] = None,
        justification: Optional[Union[Literal["Networking"], Literal["Governance"], Literal["Off"], str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedOnBehalfOfConfiguration(_Model):
    """Managed-On-Behalf-Of configuration properties. This configuration exists for the resources
    where a resource provider manages those resources on behalf of the resource owner.

    :ivar mobo_broker_resources: Managed-On-Behalf-Of broker resources.
    :vartype mobo_broker_resources: list[~azure.mgmt.virtualenclaves.models.MoboBrokerResource]
    """

    mobo_broker_resources: Optional[list["_models.MoboBrokerResource"]] = rest_field(
        name="moboBrokerResources", visibility=["read"]
    )
    """Managed-On-Behalf-Of broker resources."""


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.virtualenclaves.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.virtualenclaves.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MandatoryApprover(_Model):
    """Approver Metadata for approvals request.

    :ivar approver_entra_id: EntraId of the approver. Required.
    :vartype approver_entra_id: str
    """

    approver_entra_id: str = rest_field(
        name="approverEntraId", visibility=["read", "create", "update", "delete", "query"]
    )
    """EntraId of the approver. Required."""

    @overload
    def __init__(
        self,
        *,
        approver_entra_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MoboBrokerResource(_Model):
    """Managed-On-Behalf-Of broker resource. This resource is created by the Resource Provider to
    manage some resources on behalf of the user.

    :ivar id: Resource identifier of a Managed-On-Behalf-Of broker resource.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource identifier of a Managed-On-Behalf-Of broker resource."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.virtualenclaves.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.virtualenclaves.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.virtualenclaves.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class Principal(_Model):
    """Principal for maintenance mode or role assignments.

    :ivar id: The object id associated with the principal. Required.
    :vartype id: str
    :ivar type: The type of the object id. We currently allow users, groups, and service
     principals. Required. Is one of the following types: Literal["User"], Literal["Group"],
     Literal["ServicePrincipal"], str
    :vartype type: str or str or str or str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object id associated with the principal. Required."""
    type: Union[Literal["User"], Literal["Group"], Literal["ServicePrincipal"], str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the object id. We currently allow users, groups, and service principals. Required.
     Is one of the following types: Literal[\"User\"], Literal[\"Group\"],
     Literal[\"ServicePrincipal\"], str"""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[Literal["User"], Literal["Group"], Literal["ServicePrincipal"], str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestMetadata(_Model):
    """Request Metadata for approvals request.

    :ivar resource_action: Resource Action of the item being approved or declined. Required.
    :vartype resource_action: str
    :ivar approval_callback_route: Route name for the approval callback.
    :vartype approval_callback_route: str
    :ivar approval_callback_payload: Payload to be sent upon any action on approval request.
    :vartype approval_callback_payload: str
    :ivar approval_status: Status of the approval. Uses ApprovalStatus enum. Known values are:
     "Approved", "Rejected", "Pending", "Deleted", and "Expired".
    :vartype approval_status: str or ~azure.mgmt.virtualenclaves.models.ApprovalStatus
    """

    resource_action: str = rest_field(name="resourceAction", visibility=["read", "create", "update", "delete", "query"])
    """Resource Action of the item being approved or declined. Required."""
    approval_callback_route: Optional[str] = rest_field(
        name="approvalCallbackRoute", visibility=["read", "create", "update", "delete", "query"]
    )
    """Route name for the approval callback."""
    approval_callback_payload: Optional[str] = rest_field(
        name="approvalCallbackPayload", visibility=["read", "create", "update", "delete", "query"]
    )
    """Payload to be sent upon any action on approval request."""
    approval_status: Optional[Union[str, "_models.ApprovalStatus"]] = rest_field(
        name="approvalStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the approval. Uses ApprovalStatus enum. Known values are: \"Approved\", \"Rejected\",
     \"Pending\", \"Deleted\", and \"Expired\"."""

    @overload
    def __init__(
        self,
        *,
        resource_action: str,
        approval_callback_route: Optional[str] = None,
        approval_callback_payload: Optional[str] = None,
        approval_status: Optional[Union[str, "_models.ApprovalStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestMetadataUpdatableProperties(_Model):
    """Request Metadata patch properties.

    :ivar resource_action: Resource Action of the item being approved or declined. Required.
    :vartype resource_action: str
    :ivar approval_callback_route: Route name for the approval callback.
    :vartype approval_callback_route: str
    :ivar approval_callback_payload: Payload to be sent upon any action on approval request.
    :vartype approval_callback_payload: str
    :ivar approval_status: Status of the approval. Uses ApprovalStatus enum. Known values are:
     "Approved", "Rejected", "Pending", "Deleted", and "Expired".
    :vartype approval_status: str or ~azure.mgmt.virtualenclaves.models.ApprovalStatus
    """

    resource_action: str = rest_field(name="resourceAction", visibility=["read", "create", "update", "delete", "query"])
    """Resource Action of the item being approved or declined. Required."""
    approval_callback_route: Optional[str] = rest_field(
        name="approvalCallbackRoute", visibility=["read", "create", "update", "delete", "query"]
    )
    """Route name for the approval callback."""
    approval_callback_payload: Optional[str] = rest_field(
        name="approvalCallbackPayload", visibility=["read", "create", "update", "delete", "query"]
    )
    """Payload to be sent upon any action on approval request."""
    approval_status: Optional[Union[str, "_models.ApprovalStatus"]] = rest_field(
        name="approvalStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the approval. Uses ApprovalStatus enum. Known values are: \"Approved\", \"Rejected\",
     \"Pending\", \"Deleted\", and \"Expired\"."""

    @overload
    def __init__(
        self,
        *,
        resource_action: str,
        approval_callback_route: Optional[str] = None,
        approval_callback_payload: Optional[str] = None,
        approval_status: Optional[Union[str, "_models.ApprovalStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RoleAssignmentItem(_Model):
    """Role assignment item that indicates which principals should be assigned this role definition.

    :ivar role_definition_id: Role definition identifier. Required.
    :vartype role_definition_id: str
    :ivar principals: List of principal IDs to which to assign this role definition.
    :vartype principals: list[~azure.mgmt.virtualenclaves.models.Principal]
    """

    role_definition_id: str = rest_field(
        name="roleDefinitionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Role definition identifier. Required."""
    principals: Optional[list["_models.Principal"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of principal IDs to which to assign this role definition."""

    @overload
    def __init__(
        self,
        *,
        role_definition_id: str,
        principals: Optional[list["_models.Principal"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubnetConfiguration(_Model):
    """Subnet Configuration.

    :ivar subnet_name: Subnet name. Required.
    :vartype subnet_name: str
    :ivar subnet_resource_id: Subnet Resource ID.
    :vartype subnet_resource_id: str
    :ivar network_prefix_size: Network prefix size. Required.
    :vartype network_prefix_size: int
    :ivar subnet_delegation: Subnet delegation.
    :vartype subnet_delegation: str
    :ivar address_prefix: Address prefix.
    :vartype address_prefix: str
    :ivar network_security_group_resource_id: Network security group ID.
    :vartype network_security_group_resource_id: str
    """

    subnet_name: str = rest_field(name="subnetName", visibility=["read", "create", "update", "delete", "query"])
    """Subnet name. Required."""
    subnet_resource_id: Optional[str] = rest_field(name="subnetResourceId", visibility=["read"])
    """Subnet Resource ID."""
    network_prefix_size: int = rest_field(
        name="networkPrefixSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Network prefix size. Required."""
    subnet_delegation: Optional[str] = rest_field(
        name="subnetDelegation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Subnet delegation."""
    address_prefix: Optional[str] = rest_field(name="addressPrefix", visibility=["read"])
    """Address prefix."""
    network_security_group_resource_id: Optional[str] = rest_field(
        name="networkSecurityGroupResourceId", visibility=["read"]
    )
    """Network security group ID."""

    @overload
    def __init__(
        self,
        *,
        subnet_name: str,
        network_prefix_size: int,
        subnet_delegation: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.virtualenclaves.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.virtualenclaves.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransitHubPatchModel(_Model):
    """TH Patch Resource.

    :ivar properties: The TransitHub resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.TransitHubPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.TransitHubPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The TransitHub resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.TransitHubPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransitHubPatchProperties(_Model):
    """Transit Hub patchable Properties.

    :ivar state: The state of the transitHub. Known values are: "PendingApproval", "Approved",
     "PendingUpdate", "Active", and "Failed".
    :vartype state: str or ~azure.mgmt.virtualenclaves.models.TransitHubState
    :ivar transit_option: The TransitOption of the transitHub.
    :vartype transit_option: ~azure.mgmt.virtualenclaves.models.TransitOption
    """

    state: Optional[Union[str, "_models.TransitHubState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of the transitHub. Known values are: \"PendingApproval\", \"Approved\",
     \"PendingUpdate\", \"Active\", and \"Failed\"."""
    transit_option: Optional["_models.TransitOption"] = rest_field(
        name="transitOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """The TransitOption of the transitHub."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.TransitHubState"]] = None,
        transit_option: Optional["_models.TransitOption"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransitHubProperties(_Model):
    """Describes the properties of an Transit Hub.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and
     "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    :ivar state: The state of the transitHub. Known values are: "PendingApproval", "Approved",
     "PendingUpdate", "Active", and "Failed".
    :vartype state: str or ~azure.mgmt.virtualenclaves.models.TransitHubState
    :ivar transit_option: The TransitOption of the transitHub.
    :vartype transit_option: ~azure.mgmt.virtualenclaves.models.TransitOption
    :ivar resource_collection: List of resource ids modified by transitHubs.
    :vartype resource_collection: list[str]
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Accepted\", \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""
    state: Optional[Union[str, "_models.TransitHubState"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The state of the transitHub. Known values are: \"PendingApproval\", \"Approved\",
     \"PendingUpdate\", \"Active\", and \"Failed\"."""
    transit_option: Optional["_models.TransitOption"] = rest_field(
        name="transitOption", visibility=["read", "create", "update", "delete", "query"]
    )
    """The TransitOption of the transitHub."""
    resource_collection: Optional[list[str]] = rest_field(name="resourceCollection", visibility=["read"])
    """List of resource ids modified by transitHubs."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.TransitHubState"]] = None,
        transit_option: Optional["_models.TransitOption"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransitHubResource(TrackedResource):
    """TransitHub Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.TransitHubProperties
    """

    properties: Optional["_models.TransitHubProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.TransitHubProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransitOption(_Model):
    """TransitOption Properties.

    :ivar type: Transit Option Type. Known values are: "ExpressRoute", "Gateway", and "Peering".
    :vartype type: str or ~azure.mgmt.virtualenclaves.models.TransitOptionType
    :ivar params: Transit Option Params.
    :vartype params: ~azure.mgmt.virtualenclaves.models.TransitOptionParams
    """

    type: Optional[Union[str, "_models.TransitOptionType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Transit Option Type. Known values are: \"ExpressRoute\", \"Gateway\", and \"Peering\"."""
    params: Optional["_models.TransitOptionParams"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Transit Option Params."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.TransitOptionType"]] = None,
        params: Optional["_models.TransitOptionParams"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TransitOptionParams(_Model):
    """TransitOptionParams Properties.

    :ivar scale_units: Transit Option Params scaleUnits.
    :vartype scale_units: int
    :ivar remote_virtual_network_id: Transit Option Params remoteVirtualNetworkId.
    :vartype remote_virtual_network_id: str
    """

    scale_units: Optional[int] = rest_field(
        name="scaleUnits", visibility=["read", "create", "update", "delete", "query"]
    )
    """Transit Option Params scaleUnits."""
    remote_virtual_network_id: Optional[str] = rest_field(
        name="remoteVirtualNetworkId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Transit Option Params remoteVirtualNetworkId."""

    @overload
    def __init__(
        self,
        *,
        scale_units: Optional[int] = None,
        remote_virtual_network_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""


class VirtualEnclavePatchModel(_Model):
    """Virtual Enclave Patch Model.

    :ivar properties: Virtual Enclave Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.VirtualEnclavePatchProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.virtualenclaves.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.VirtualEnclavePatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Virtual Enclave Patch properties."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.VirtualEnclavePatchProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualEnclavePatchProperties(_Model):
    """Virtual Enclave Patchable Properties.

    :ivar enclave_virtual_network: Virtual Network. Required.
    :vartype enclave_virtual_network: ~azure.mgmt.virtualenclaves.models.EnclaveVirtualNetworkModel
    :ivar bastion_enabled: Deploy Bastion service (True or False).
    :vartype bastion_enabled: bool
    :ivar enclave_role_assignments: Enclave role assignments.
    :vartype enclave_role_assignments: list[~azure.mgmt.virtualenclaves.models.RoleAssignmentItem]
    :ivar workload_role_assignments: Workload role assignments.
    :vartype workload_role_assignments: list[~azure.mgmt.virtualenclaves.models.RoleAssignmentItem]
    :ivar governed_service_list: Enclave specific policies.
    :vartype governed_service_list: list[~azure.mgmt.virtualenclaves.models.GovernedServiceItem]
    :ivar enclave_default_settings: Enclave default settings.
    :vartype enclave_default_settings:
     ~azure.mgmt.virtualenclaves.models.EnclaveDefaultSettingsPatchModel
    :ivar maintenance_mode_configuration: Maintenance Mode configuration.
    :vartype maintenance_mode_configuration:
     ~azure.mgmt.virtualenclaves.models.MaintenanceModeConfigurationPatchModel
    """

    enclave_virtual_network: "_models.EnclaveVirtualNetworkModel" = rest_field(
        name="enclaveVirtualNetwork", visibility=["read", "create", "update", "delete", "query"]
    )
    """Virtual Network. Required."""
    bastion_enabled: Optional[bool] = rest_field(
        name="bastionEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Deploy Bastion service (True or False)."""
    enclave_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = rest_field(
        name="enclaveRoleAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave role assignments."""
    workload_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = rest_field(
        name="workloadRoleAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Workload role assignments."""
    governed_service_list: Optional[list["_models.GovernedServiceItem"]] = rest_field(
        name="governedServiceList", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave specific policies."""
    enclave_default_settings: Optional["_models.EnclaveDefaultSettingsPatchModel"] = rest_field(
        name="enclaveDefaultSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave default settings."""
    maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationPatchModel"] = rest_field(
        name="maintenanceModeConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maintenance Mode configuration."""

    @overload
    def __init__(
        self,
        *,
        enclave_virtual_network: "_models.EnclaveVirtualNetworkModel",
        bastion_enabled: Optional[bool] = None,
        enclave_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = None,
        workload_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = None,
        governed_service_list: Optional[list["_models.GovernedServiceItem"]] = None,
        enclave_default_settings: Optional["_models.EnclaveDefaultSettingsPatchModel"] = None,
        maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationPatchModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualEnclaveProperties(_Model):
    """Virtual Enclave Resource properties.

    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    :ivar enclave_virtual_network: Virtual Network. Required.
    :vartype enclave_virtual_network: ~azure.mgmt.virtualenclaves.models.EnclaveVirtualNetworkModel
    :ivar enclave_address_spaces: Enclave Address Spaces.
    :vartype enclave_address_spaces: ~azure.mgmt.virtualenclaves.models.EnclaveAddressSpacesModel
    :ivar community_resource_id: Community Resource Id. Required.
    :vartype community_resource_id: str
    :ivar resource_collection: List of resource ids created by Virtual Enclave.
    :vartype resource_collection: list[str]
    :ivar managed_resource_group_name: Managed resource group name.
    :vartype managed_resource_group_name: str
    :ivar managed_on_behalf_of_configuration: Managed On Behalf Of Configuration.
    :vartype managed_on_behalf_of_configuration:
     ~azure.mgmt.virtualenclaves.models.ManagedOnBehalfOfConfiguration
    :ivar bastion_enabled: Deploy Bastion service (True or False).
    :vartype bastion_enabled: bool
    :ivar enclave_role_assignments: Enclave role assignments.
    :vartype enclave_role_assignments: list[~azure.mgmt.virtualenclaves.models.RoleAssignmentItem]
    :ivar workload_role_assignments: Workload role assignments.
    :vartype workload_role_assignments: list[~azure.mgmt.virtualenclaves.models.RoleAssignmentItem]
    :ivar governed_service_list: Enclave specific policies.
    :vartype governed_service_list: list[~azure.mgmt.virtualenclaves.models.GovernedServiceItem]
    :ivar enclave_default_settings: Enclave default settings.
    :vartype enclave_default_settings:
     ~azure.mgmt.virtualenclaves.models.EnclaveDefaultSettingsModel
    :ivar maintenance_mode_configuration: Maintenance Mode configuration.
    :vartype maintenance_mode_configuration:
     ~azure.mgmt.virtualenclaves.models.MaintenanceModeConfigurationModel
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""
    enclave_virtual_network: "_models.EnclaveVirtualNetworkModel" = rest_field(
        name="enclaveVirtualNetwork", visibility=["read", "create", "update", "delete", "query"]
    )
    """Virtual Network. Required."""
    enclave_address_spaces: Optional["_models.EnclaveAddressSpacesModel"] = rest_field(
        name="enclaveAddressSpaces", visibility=["read"]
    )
    """Enclave Address Spaces."""
    community_resource_id: str = rest_field(name="communityResourceId", visibility=["read", "create"])
    """Community Resource Id. Required."""
    resource_collection: Optional[list[str]] = rest_field(name="resourceCollection", visibility=["read"])
    """List of resource ids created by Virtual Enclave."""
    managed_resource_group_name: Optional[str] = rest_field(name="managedResourceGroupName", visibility=["read"])
    """Managed resource group name."""
    managed_on_behalf_of_configuration: Optional["_models.ManagedOnBehalfOfConfiguration"] = rest_field(
        name="managedOnBehalfOfConfiguration", visibility=["read"]
    )
    """Managed On Behalf Of Configuration."""
    bastion_enabled: Optional[bool] = rest_field(
        name="bastionEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Deploy Bastion service (True or False)."""
    enclave_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = rest_field(
        name="enclaveRoleAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave role assignments."""
    workload_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = rest_field(
        name="workloadRoleAssignments", visibility=["read", "create", "update", "delete", "query"]
    )
    """Workload role assignments."""
    governed_service_list: Optional[list["_models.GovernedServiceItem"]] = rest_field(
        name="governedServiceList", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave specific policies."""
    enclave_default_settings: Optional["_models.EnclaveDefaultSettingsModel"] = rest_field(
        name="enclaveDefaultSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enclave default settings."""
    maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationModel"] = rest_field(
        name="maintenanceModeConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maintenance Mode configuration."""

    @overload
    def __init__(
        self,
        *,
        enclave_virtual_network: "_models.EnclaveVirtualNetworkModel",
        community_resource_id: str,
        bastion_enabled: Optional[bool] = None,
        enclave_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = None,
        workload_role_assignments: Optional[list["_models.RoleAssignmentItem"]] = None,
        governed_service_list: Optional[list["_models.GovernedServiceItem"]] = None,
        enclave_default_settings: Optional["_models.EnclaveDefaultSettingsModel"] = None,
        maintenance_mode_configuration: Optional["_models.MaintenanceModeConfigurationModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadPatchModel(_Model):
    """Workload Patch Resource.

    :ivar properties: Workload Patch properties.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.WorkloadPatchProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.WorkloadPatchProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Workload Patch properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.WorkloadPatchProperties"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadPatchProperties(_Model):
    """Workload patchable Properties.

    :ivar resource_group_collection: List of resource group ids.
    :vartype resource_group_collection: list[str]
    """

    resource_group_collection: Optional[list[str]] = rest_field(
        name="resourceGroupCollection", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of resource group ids."""

    @overload
    def __init__(
        self,
        *,
        resource_group_collection: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadProperties(_Model):
    """Workload Resource properties.

    :ivar provisioning_state: Provisioning State. Known values are: "Succeeded", "Failed",
     "Canceled", "Accepted", "Creating", "Deleting", "NotSpecified", "Running", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.virtualenclaves.models.ProvisioningState
    :ivar resource_group_collection: List of resource group ids.
    :vartype resource_group_collection: list[str]
    :ivar managed_on_behalf_of_configuration: Managed On Behalf Of Configuration.
    :vartype managed_on_behalf_of_configuration:
     ~azure.mgmt.virtualenclaves.models.ManagedOnBehalfOfConfiguration
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State. Known values are: \"Succeeded\", \"Failed\", \"Canceled\", \"Accepted\",
     \"Creating\", \"Deleting\", \"NotSpecified\", \"Running\", and \"Updating\"."""
    resource_group_collection: Optional[list[str]] = rest_field(
        name="resourceGroupCollection", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of resource group ids."""
    managed_on_behalf_of_configuration: Optional["_models.ManagedOnBehalfOfConfiguration"] = rest_field(
        name="managedOnBehalfOfConfiguration", visibility=["read"]
    )
    """Managed On Behalf Of Configuration."""

    @overload
    def __init__(
        self,
        *,
        resource_group_collection: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkloadResource(TrackedResource):
    """Workload Model Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.virtualenclaves.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.virtualenclaves.models.WorkloadProperties
    """

    properties: Optional["_models.WorkloadProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.WorkloadProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
