/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.messages.GherkinMessagesExample;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

final class GherkinMessagesExamples
implements Node.Examples {
    private final Examples examples;
    private final List<Node.Example> children;
    private final Location location;
    private final Node parent;

    GherkinMessagesExamples(Node parent, Examples examples) {
        this.parent = parent;
        this.examples = examples;
        this.location = GherkinMessagesLocation.from(examples.getLocation());
        AtomicInteger row = new AtomicInteger(1);
        this.children = examples.getTableBody().stream().map(tableRow -> new GherkinMessagesExample((Node)this, (TableRow)tableRow, row.getAndIncrement())).collect(Collectors.toList());
    }

    public Collection<Node.Example> elements() {
        return this.children;
    }

    public Location getLocation() {
        return this.location;
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.examples.getKeyword());
    }

    public Optional<String> getName() {
        String name = this.examples.getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }

    public Optional<Node> getParent() {
        return Optional.of(this.parent);
    }
}

