/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Properties;

public abstract class PublicKeyKeyEncryptionMethodGenerator
implements PGPKeyEncryptionMethodGenerator {
    public static final String SESSION_KEY_OBFUSCATION_PROPERTY = "org.bouncycastle.openpgp.session_key_obfuscation";
    public static final long WILDCARD_KEYID = 0L;
    public static final long WILDCARD = 0L;
    public static final byte[] WILDCARD_FINGERPRINT = new byte[0];
    private final PGPPublicKey pubKey;
    protected boolean sessionKeyObfuscation;
    protected boolean useWildcardRecipient;

    private static boolean getSessionKeyObfuscationDefault() {
        return !Properties.isOverrideSetTo((String)SESSION_KEY_OBFUSCATION_PROPERTY, (boolean)false);
    }

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pubKey) {
        switch (pubKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Can't use an RSA_SIGN key for encryption.");
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            case 22: 
            case 27: 
            case 28: {
                throw new IllegalArgumentException("Can't use EdDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pubKey.getAlgorithm());
            }
        }
        this.pubKey = pubKey;
        this.sessionKeyObfuscation = PublicKeyKeyEncryptionMethodGenerator.getSessionKeyObfuscationDefault();
    }

    public PublicKeyKeyEncryptionMethodGenerator setSessionKeyObfuscation(boolean enabled) {
        this.sessionKeyObfuscation = enabled;
        return this;
    }

    @Deprecated
    public PublicKeyKeyEncryptionMethodGenerator setUseWildcardKeyID(boolean enabled) {
        return this.setUseWildcardRecipient(enabled);
    }

    public PublicKeyKeyEncryptionMethodGenerator setUseWildcardRecipient(boolean enabled) {
        this.useWildcardRecipient = enabled;
        return this;
    }

    public byte[][] encodeEncryptedSessionInfo(byte[] encryptedSessionInfo) throws PGPException {
        byte[][] data;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                data = new byte[][]{this.convertToEncodedMPI(encryptedSessionInfo)};
                break;
            }
            case 16: 
            case 20: {
                byte[] b1 = new byte[encryptedSessionInfo.length / 2];
                byte[] b2 = new byte[encryptedSessionInfo.length / 2];
                System.arraycopy(encryptedSessionInfo, 0, b1, 0, b1.length);
                System.arraycopy(encryptedSessionInfo, b1.length, b2, 0, b2.length);
                data = new byte[][]{this.convertToEncodedMPI(b1), this.convertToEncodedMPI(b2)};
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                data = new byte[][]{encryptedSessionInfo};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return data;
    }

    private byte[] convertToEncodedMPI(byte[] encryptedSessionInfo) throws PGPException {
        try {
            return new MPInteger(new BigInteger(1, encryptedSessionInfo)).getEncoded();
        }
        catch (IOException e) {
            throw new PGPException("Invalid MPI encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public ContainedPacket generate(PGPDataEncryptorBuilder dataEncryptorBuilder, byte[] sessionKey) throws PGPException {
        int keyVersion;
        byte[] keyFingerprint;
        if (dataEncryptorBuilder.getAeadAlgorithm() <= 0 || dataEncryptorBuilder.isV5StyleAEAD()) {
            long keyId = this.useWildcardRecipient ? 0L : this.pubKey.getKeyID();
            byte[] encryptedSessionInfo = this.encryptSessionInfo(this.pubKey, sessionKey, (byte)dataEncryptorBuilder.getAlgorithm(), true);
            byte[][] encodedEncSessionInfo = this.encodeEncryptedSessionInfo(encryptedSessionInfo);
            return PublicKeyEncSessionPacket.createV3PKESKPacket(keyId, this.pubKey.getAlgorithm(), encodedEncSessionInfo);
        }
        if (this.useWildcardRecipient) {
            keyFingerprint = WILDCARD_FINGERPRINT;
            keyVersion = 0;
        } else {
            keyFingerprint = this.pubKey.getFingerprint();
            keyVersion = this.pubKey.getVersion();
        }
        byte[] encryptedSessionInfo = this.encryptSessionInfo(this.pubKey, sessionKey, (byte)dataEncryptorBuilder.getAlgorithm(), false);
        byte[][] encodedEncSessionInfo = this.encodeEncryptedSessionInfo(encryptedSessionInfo);
        return PublicKeyEncSessionPacket.createV6PKESKPacket(keyVersion, keyFingerprint, this.pubKey.getAlgorithm(), encodedEncSessionInfo);
    }

    protected byte[] createSessionInfo(byte algorithm, byte[] keyBytes) {
        byte[] sessionInfo;
        if (algorithm != 0) {
            sessionInfo = new byte[keyBytes.length + 3];
            sessionInfo[0] = algorithm;
            System.arraycopy(keyBytes, 0, sessionInfo, 1, keyBytes.length);
            this.addCheckSum(sessionInfo, 1);
        } else {
            sessionInfo = new byte[keyBytes.length + 2];
            System.arraycopy(keyBytes, 0, sessionInfo, 0, keyBytes.length);
            this.addCheckSum(sessionInfo, 0);
        }
        return sessionInfo;
    }

    private void addCheckSum(byte[] sessionInfo, int pos) {
        int check = 0;
        for (int i = pos; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        sessionInfo[sessionInfo.length - 2] = (byte)(check >> 8);
        sessionInfo[sessionInfo.length - 1] = (byte)check;
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2, byte var3, boolean var4) throws PGPException;

    protected static byte[] getSessionInfo(byte[] ephPubEncoding, byte optSymKeyAlgorithm, byte[] wrappedSessionKey) {
        int len = ephPubEncoding.length + wrappedSessionKey.length + (optSymKeyAlgorithm == 0 ? 1 : 2);
        byte[] out = new byte[len];
        System.arraycopy(ephPubEncoding, 0, out, 0, ephPubEncoding.length);
        out[ephPubEncoding.length] = (byte)(len - ephPubEncoding.length - 1);
        if (optSymKeyAlgorithm != 0) {
            out[ephPubEncoding.length + 1] = optSymKeyAlgorithm;
        }
        System.arraycopy(wrappedSessionKey, 0, out, len - wrappedSessionKey.length, wrappedSessionKey.length);
        return out;
    }
}

