"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTabs", {
  enumerable: true,
  get: function get() {
    return _tabs.EuiTabs;
  }
});
exports.OuiTabs = exports.SIZES = exports.DISPLAYS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _tabs = require("../../eui_components/tabs/tabs");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var displayToClassNameMap = {
  condensed: 'ouiTabs--condensed',
  default: null
};
var DISPLAYS = (0, _common.keysOf)(displayToClassNameMap);
exports.DISPLAYS = DISPLAYS;
var sizeToClassNameMap = {
  s: 'ouiTabs--small',
  m: null,
  l: 'ouiTabs--large'
};
var SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.SIZES = SIZES;
var OuiTabs = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'default' : _ref$display,
    _ref$expand = _ref.expand,
    expand = _ref$expand === void 0 ? false : _ref$expand,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "display", "expand", "size"]);
  var classes = (0, _classnames.default)('ouiTabs', displayToClassNameMap[display], sizeToClassNameMap[size], {
    'ouiTabs--expand': expand
  }, className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: ref,
    className: classes
  }, children && {
    role: 'tablist'
  }, rest), children);
});
exports.OuiTabs = OuiTabs;
OuiTabs.displayName = 'OuiTabs';

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */