/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.DefaultAccountHolder;
import com.intellij.collaboration.auth.ServerAccount;
import com.intellij.collaboration.ui.ComboBoxWithActionsModel;
import com.intellij.collaboration.ui.SimpleFocusBorder;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.popup.list.ComboBoxPopup;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import com.intellij.util.ui.cloneDialog.AccountMenuItemRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001cB+\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ_\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00182\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0005R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory;", "A", "Lcom/intellij/collaboration/auth/Account;", "", "accountsState", "Lkotlinx/coroutines/flow/StateFlow;", "", "selectionState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/MutableStateFlow;)V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "defaultAccountHolder", "Lcom/intellij/collaboration/auth/DefaultAccountHolder;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "avatarSize", "", "popupAvatarSize", "emptyStateTooltip", "", "Lorg/jetbrains/annotations/Nls;", "actions", "", "Ljavax/swing/Action;", "Controller", "intellij.platform.collaborationTools"})
public final class AccountSelectorComponentFactory<A extends Account> {
    @NotNull
    private final StateFlow<Collection<A>> accountsState;
    @NotNull
    private final MutableStateFlow<A> selectionState;

    public AccountSelectorComponentFactory(@NotNull StateFlow<? extends Collection<? extends A>> accountsState, @NotNull MutableStateFlow<A> selectionState) {
        Intrinsics.checkNotNullParameter(accountsState, (String)"accountsState");
        Intrinsics.checkNotNullParameter(selectionState, (String)"selectionState");
        this.accountsState = accountsState;
        this.selectionState = selectionState;
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope, @Nullable DefaultAccountHolder<A> defaultAccountHolder, @NotNull IconsProvider<A> avatarIconsProvider, int avatarSize, int popupAvatarSize, @NotNull String emptyStateTooltip, @NotNull StateFlow<? extends List<? extends Action>> actions) {
        JLabel jLabel;
        A defaultAccount;
        ComboBoxWithActionsModel comboBoxWithActionsModel;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)emptyStateTooltip, (String)"emptyStateTooltip");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        ComboBoxWithActionsModel $this$create_u24lambda_u240 = comboBoxWithActionsModel = new ComboBoxWithActionsModel();
        boolean bl = false;
        Flow flow = (Flow)this.accountsState;
        Flow flow2 = (Flow)actions;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> AccountSelectorComponentFactory.create$lambda$0$1(AccountSelectorComponentFactory::create$lambda$0$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        SwingBindingsKt.bindIn($this$create_u24lambda_u240, scope, flow, this.selectionState, (Flow<? extends List<? extends Action>>)flow2, comparator);
        DefaultAccountHolder<A> defaultAccountHolder2 = defaultAccountHolder;
        Object object = defaultAccount = defaultAccountHolder2 != null ? defaultAccountHolder2.getAccount() : null;
        if ($this$create_u24lambda_u240.getSelectedItem() == null && defaultAccount != null) {
            $this$create_u24lambda_u240.setSelectedItem(new ComboBoxWithActionsModel.Item.Wrapper<A>(defaultAccount));
        }
        if ($this$create_u24lambda_u240.getSize() > 0 && $this$create_u24lambda_u240.getSelectedItem() == null) {
            int n = $this$create_u24lambda_u240.getSize();
            for (int i = 0; i < n; ++i) {
                Object item = $this$create_u24lambda_u240.getElementAt(i);
                if (!(item instanceof ComboBoxWithActionsModel.Item.Wrapper)) continue;
                $this$create_u24lambda_u240.setSelectedItem(item);
                break;
            }
        }
        ComboBoxWithActionsModel comboModel = comboBoxWithActionsModel;
        JLabel $this$create_u24lambda_u241 = jLabel = new JLabel();
        boolean bl2 = false;
        $this$create_u24lambda_u241.setOpaque(false);
        $this$create_u24lambda_u241.setCursor(Cursor.getPredefinedCursor(12));
        $this$create_u24lambda_u241.setFocusable(true);
        $this$create_u24lambda_u241.setBorder(new SimpleFocusBorder());
        JLabel label = jLabel;
        new Controller(comboModel, label, avatarIconsProvider, avatarSize, popupAvatarSize, emptyStateTooltip);
        return label;
    }

    public static /* synthetic */ JComponent create$default(AccountSelectorComponentFactory accountSelectorComponentFactory, CoroutineScope coroutineScope, DefaultAccountHolder defaultAccountHolder, IconsProvider iconsProvider, int n, int n2, String string, StateFlow stateFlow, int n3, Object object) {
        if ((n3 & 0x40) != 0) {
            stateFlow = (StateFlow)StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        }
        return accountSelectorComponentFactory.create(coroutineScope, defaultAccountHolder, iconsProvider, n, n2, string, (StateFlow<List<Action>>)stateFlow);
    }

    private static final String create$lambda$0$0(Account it) {
        return it.getName();
    }

    private static final String create$lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u0001!BH\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u00020\u0016*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u001eH\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040 H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory$Controller;", "A", "Lcom/intellij/collaboration/auth/Account;", "Lcom/intellij/ui/popup/list/ComboBoxPopup$Context;", "Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel$Item;", "accountsModel", "Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel;", "label", "Ljavax/swing/JLabel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "avatarSize", "", "popupAvatarSize", "emptyStateTooltip", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel;Ljavax/swing/JLabel;Lcom/intellij/collaboration/ui/icon/IconsProvider;IILjava/lang/String;)V", "popup", "Lcom/intellij/ui/popup/list/ComboBoxPopup;", "updateLabel", "", "showPopup", "registerPopupOnKeyboardShortcut", "Ljavax/swing/JComponent;", "keyCode", "getProject", "Lcom/intellij/openapi/project/Project;", "getModel", "Ljavax/swing/ListModel;", "getRenderer", "Ljavax/swing/ListCellRenderer;", "PopupItemRenderer", "intellij.platform.collaborationTools"})
    private static final class Controller<A extends Account>
    implements ComboBoxPopup.Context<ComboBoxWithActionsModel.Item<A>> {
        @NotNull
        private final ComboBoxWithActionsModel<A> accountsModel;
        @NotNull
        private final JLabel label;
        @NotNull
        private final IconsProvider<A> avatarIconsProvider;
        private final int avatarSize;
        private final int popupAvatarSize;
        @NotNull
        private final String emptyStateTooltip;
        @Nullable
        private ComboBoxPopup<?> popup;

        public Controller(@NotNull ComboBoxWithActionsModel<A> accountsModel, @NotNull JLabel label, @NotNull IconsProvider<A> avatarIconsProvider, int avatarSize, int popupAvatarSize, @NotNull String emptyStateTooltip) {
            Intrinsics.checkNotNullParameter(accountsModel, (String)"accountsModel");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            Intrinsics.checkNotNullParameter((Object)emptyStateTooltip, (String)"emptyStateTooltip");
            this.accountsModel = accountsModel;
            this.label = label;
            this.avatarIconsProvider = avatarIconsProvider;
            this.avatarSize = avatarSize;
            this.popupAvatarSize = popupAvatarSize;
            this.emptyStateTooltip = emptyStateTooltip;
            this.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.updateLabel();
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.updateLabel();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.updateLabel();
                }
            });
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.showPopup();
                }
            });
            this.registerPopupOnKeyboardShortcut(this.label, 10);
            this.registerPopupOnKeyboardShortcut(this.label, 32);
            this.updateLabel();
        }

        private final void updateLabel() {
            Object object = this.accountsModel.getSelectedItem();
            Account selectedAccount = object != null ? (Account)((ComboBoxWithActionsModel.Item.Wrapper)object).getWrappee() : null;
            JLabel $this$updateLabel_u24lambda_u240 = this.label;
            boolean bl = false;
            $this$updateLabel_u24lambda_u240.setIcon(this.avatarIconsProvider.getIcon(selectedAccount, this.avatarSize));
            Object object2 = selectedAccount;
            if (object2 == null || (object2 = ((Account)object2).getName()) == null) {
                object2 = this.emptyStateTooltip;
            }
            $this$updateLabel_u24lambda_u240.setToolTipText((String)object2);
        }

        /*
         * WARNING - void declaration
         */
        private final void showPopup() {
            void $this$showPopup_u24lambda_u242;
            if (!this.label.isEnabled()) {
                return;
            }
            Object object = this.accountsModel.getSelectedItem();
            Object object2 = arg_0 -> Controller.showPopup$lambda$1(arg_0 -> Controller.showPopup$lambda$0(this, arg_0), arg_0);
            object = new ComboBoxPopup<ComboBoxWithActionsModel.Item<A>>(this, object, (Consumer<Object>)object2){
                final /* synthetic */ Controller<A> this$0;
                {
                    this.this$0 = $receiver;
                    super((ComboBoxPopup.Context)$receiver, $super_call_param$1, $super_call_param$2);
                }

                protected ListCellRenderer<ComboBoxWithActionsModel.Item<A>> getListElementRenderer() {
                    return this.this$0.getRenderer();
                }
            };
            object2 = object;
            Controller controller = this;
            boolean bl = false;
            $this$showPopup_u24lambda_u242.addListener(new JBPopupListener(this){
                final /* synthetic */ Controller<A> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Controller.access$setPopup$p(this.this$0, null);
                }
            });
            $this$showPopup_u24lambda_u242.showUnderneathOf((Component)this.label);
            controller.popup = (ComboBoxPopup)object;
        }

        private final void registerPopupOnKeyboardShortcut(JComponent $this$registerPopupOnKeyboardShortcut, int keyCode) {
            $this$registerPopupOnKeyboardShortcut.registerKeyboardAction(arg_0 -> Controller.registerPopupOnKeyboardShortcut$lambda$0(this, arg_0), KeyStroke.getKeyStroke(keyCode, 0), 0);
        }

        @Nullable
        public Project getProject() {
            return null;
        }

        @NotNull
        public ListModel<ComboBoxWithActionsModel.Item<A>> getModel() {
            return this.accountsModel;
        }

        @NotNull
        public ListCellRenderer<ComboBoxWithActionsModel.Item<A>> getRenderer() {
            return new PopupItemRenderer();
        }

        private static final Unit showPopup$lambda$0(Controller this$0, ComboBoxWithActionsModel.Item it) {
            this$0.accountsModel.setSelectedItem(it);
            return Unit.INSTANCE;
        }

        private static final void showPopup$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final void registerPopupOnKeyboardShortcut$lambda$0(Controller this$0, ActionEvent it) {
            this$0.showPopup();
        }

        public static final /* synthetic */ void access$setPopup$p(Controller $this, ComboBoxPopup comboBoxPopup) {
            $this.popup = comboBoxPopup;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JF\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00010\u0002\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory$Controller$PopupItemRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel$Item;", "<init>", "(Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory$Controller;)V", "delegateRenderer", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "focused", "intellij.platform.collaborationTools"})
        private final class PopupItemRenderer
        implements ListCellRenderer<ComboBoxWithActionsModel.Item<A>> {
            @NotNull
            private final AccountMenuItemRenderer delegateRenderer = new AccountMenuItemRenderer();

            @Override
            @NotNull
            public Component getListCellRendererComponent(@Nullable JList<? extends ComboBoxWithActionsModel.Item<A>> list, @NotNull ComboBoxWithActionsModel.Item<A> value, int index, boolean selected, boolean focused) {
                AccountMenuItem accountMenuItem;
                Intrinsics.checkNotNullParameter(value, (String)"value");
                ComboBoxWithActionsModel.Item item = value;
                if (item instanceof ComboBoxWithActionsModel.Item.Wrapper) {
                    String string;
                    Object t = ((ComboBoxWithActionsModel.Item.Wrapper)value).getWrappee();
                    Controller controller = Controller.this;
                    Account account = (Account)t;
                    boolean bl = false;
                    Icon icon = controller.avatarIconsProvider.getIcon(account, controller.popupAvatarSize);
                    Object object = account instanceof ServerAccount ? (ServerAccount)account : null;
                    if ((object != null && (object = ((ServerAccount)object).getServer()) != null ? object.toString() : (string = null)) == null) {
                        string = "";
                    }
                    String serverAddress = string;
                    accountMenuItem = (AccountMenuItem)new AccountMenuItem.Account(account.getName(), serverAddress, icon, null, false, 24, null);
                } else if (item instanceof ComboBoxWithActionsModel.Item.Action) {
                    Action it = ((ComboBoxWithActionsModel.Item.Action)value).getAction();
                    boolean bl = false;
                    String string = ActionUtilKt.getName(it);
                    if (string == null) {
                        string = "";
                    }
                    accountMenuItem = (AccountMenuItem)new AccountMenuItem.Action(string, PopupItemRenderer::getListCellRendererComponent$lambda$1$0, null, ((ComboBoxWithActionsModel.Item.Action)value).getNeedSeparatorAbove(), 4, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                AccountMenuItem item2 = accountMenuItem;
                return this.delegateRenderer.getListCellRendererComponent(null, item2, index, selected, focused);
            }

            private static final Unit getListCellRendererComponent$lambda$1$0() {
                return Unit.INSTANCE;
            }
        }
    }
}

