/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.text;

import ai.grazie.text.TextRange$;
import ai.grazie.utils.multiplatform.SafeJsExport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 22\u00020\u0001:\u000223B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0011\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0003H\u0087\u0002J\u0011\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0000H\u0087\u0002J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0000J\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\"2\u0006\u0010\u001e\u001a\u00020\u0000\u00a2\u0006\u0002\u0010#J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\t\u0010)\u001a\u00020\u0018H\u00d6\u0001J%\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0001\u00a2\u0006\u0002\b1R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u00064"}, d2={"Lai/grazie/text/TextRange;", "", "start", "", "endExclusive", "<init>", "(II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getStart", "()I", "getEndExclusive", "endInclusive", "getEndInclusive", "length", "getLength", "isEmpty", "", "isNotEmpty", "shift", "value", "substring", "", "text", "contains", "position", "range", "intersects", "other", "intersect", "covers", "subtract", "", "(Lai/grazie/text/TextRange;)[Lai/grazie/text/TextRange;", "component1", "component2", "copy", "equals", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$model_text", "Companion", "$serializer", "model-text"})
@SourceDebugExtension(value={"SMAP\nTextRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRange.kt\nai/grazie/text/TextRange\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n3829#2:98\n4344#2,2:99\n37#3:101\n36#3,3:102\n37#3:105\n36#3,3:106\n*S KotlinDebug\n*F\n+ 1 TextRange.kt\nai/grazie/text/TextRange\n*L\n63#1:98\n63#1:99,2\n63#1:101\n63#1:102,3\n79#1:105\n79#1:106,3\n*E\n"})
public final class TextRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int start;
    private final int endExclusive;

    public TextRange(int start, int endExclusive) {
        this.start = start;
        this.endExclusive = endExclusive;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEndExclusive() {
        return this.endExclusive;
    }

    public final int getEndInclusive() {
        return this.endExclusive - 1;
    }

    public final int getLength() {
        return this.endExclusive - this.start;
    }

    public final boolean isEmpty() {
        return this.start >= this.endExclusive;
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final TextRange shift(int value) {
        return new TextRange(this.start + value, this.endExclusive + value);
    }

    @NotNull
    public final String substring(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String string = text2.substring(this.start, Math.min(this.endExclusive, text2.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public final boolean contains(int position) {
        int n = this.start;
        return position < this.endExclusive ? n <= position : false;
    }

    public final boolean contains(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return range.start >= this.start && range.endExclusive <= this.endExclusive;
    }

    public final boolean intersects(@NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.endExclusive > other.start && other.endExclusive > this.start;
    }

    @NotNull
    public final TextRange intersect(@NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new TextRange(Math.max(this.start, other.start), Math.min(this.endExclusive, other.endExclusive));
    }

    public final boolean covers(@NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.endExclusive >= other.endExclusive && this.start <= other.start;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextRange[] subtract(@NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.intersects(other)) {
            TextRange[] textRangeArray = new TextRange[]{this};
            return textRangeArray;
        }
        if (other.isEmpty()) {
            TextRange[] textRangeArray = new TextRange[]{this};
            return textRangeArray;
        }
        if (this.isEmpty()) {
            TextRange[] textRangeArray = new TextRange[]{this};
            return textRangeArray;
        }
        if (other.contains(this)) {
            return new TextRange[0];
        }
        if (this.contains(other)) {
            void $this$filterTo$iv$iv;
            TextRange[] textRangeArray = new TextRange[]{new TextRange(this.start, other.start), new TextRange(other.endExclusive, this.endExclusive)};
            TextRange[] $this$filter$iv = textRangeArray;
            boolean $i$f$filter = false;
            TextRange[] textRangeArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.isNotEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TextRange[0]);
        }
        TextRange intersection = this.intersect(other);
        if (intersection.isEmpty()) {
            return new TextRange[0];
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        for (TextRange value : this.subtract(intersection)) {
            boolean bl;
            TextRange previous = (TextRange)CollectionsKt.lastOrNull((List)result2);
            if (previous == null || previous.endExclusive != value.start) {
                bl = result2.add(value);
                continue;
            }
            result2.removeLast();
            bl = result2.add(new TextRange(previous.start, value.endExclusive));
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TextRange[0]);
    }

    public final int component1() {
        return this.start;
    }

    public final int component2() {
        return this.endExclusive;
    }

    @NotNull
    public final TextRange copy(int start, int endExclusive) {
        return new TextRange(start, endExclusive);
    }

    public static /* synthetic */ TextRange copy$default(TextRange textRange, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = textRange.start;
        }
        if ((n3 & 2) != 0) {
            n2 = textRange.endExclusive;
        }
        return textRange.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "TextRange(start=" + this.start + ", endExclusive=" + this.endExclusive + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.start);
        result2 = result2 * 31 + Integer.hashCode(this.endExclusive);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextRange)) {
            return false;
        }
        TextRange textRange = (TextRange)other;
        if (this.start != textRange.start) {
            return false;
        }
        return this.endExclusive == textRange.endExclusive;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$model_text(TextRange self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeIntElement(serialDesc, 0, self.start);
        output.encodeIntElement(serialDesc, 1, self.endExclusive);
    }

    public /* synthetic */ TextRange(int seen0, int start, int endExclusive, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.start = start;
        this.endExclusive = endExclusive;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u001b\u0010\b\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a8\u0006\u000e"}, d2={"Lai/grazie/text/TextRange$Companion;", "", "<init>", "()V", "invoke", "Lai/grazie/text/TextRange;", "range", "Lkotlin/ranges/IntRange;", "covering", "ranges", "", "([Lai/grazie/text/TextRange;)Lai/grazie/text/TextRange;", "serializer", "Lkotlinx/serialization/KSerializer;", "model-text"})
    @SourceDebugExtension(value={"SMAP\nTextRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextRange.kt\nai/grazie/text/TextRange$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextRange invoke(@NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new TextRange(range.getStart(), range.getEndInclusive() + 1);
        }

        @Nullable
        public final TextRange covering(@NotNull TextRange[] ranges) {
            int n;
            Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
            if (ranges.length == 0) {
                return null;
            }
            Object[] objectArray = ranges;
            if (objectArray.length == 0) {
                throw new NoSuchElementException();
            }
            TextRange it22 = objectArray[0];
            int n2 = 0;
            int it22 = it22.getStart();
            n2 = 1;
            int n3 = ArraysKt.getLastIndex((Object[])objectArray);
            if (n2 <= n3) {
                while (true) {
                    Object it32 = objectArray[n2];
                    boolean bl = false;
                    int it32 = ((TextRange)it32).getStart();
                    if (it22 > it32) {
                        it22 = it32;
                    }
                    if (n2 == n3) break;
                    ++n2;
                }
            }
            objectArray = ranges;
            int n4 = it22;
            if (objectArray.length == 0) {
                throw new NoSuchElementException();
            }
            Object it = objectArray[0];
            boolean bl = false;
            int n5 = ((TextRange)it).getEndExclusive();
            int n6 = 1;
            n3 = ArraysKt.getLastIndex((Object[])objectArray);
            if (n6 <= n3) {
                while (true) {
                    Object it3 = objectArray[n6];
                    $i$a$-maxOf-TextRange$Companion$covering$2 = false;
                    int n7 = ((TextRange)it3).getEndExclusive();
                    if (n5 < n7) {
                        n5 = n7;
                    }
                    if (n6 == n3) break;
                    ++n6;
                }
            }
            int n8 = n = n5;
            int n9 = n4;
            return new TextRange(n9, n8);
        }

        @NotNull
        public final KSerializer<TextRange> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

