<%
    import datetime
    [protover_major, protover_minor, *_] = config.rfnoc_version.split('.')
%>//
% if hasattr(config, 'copyright'):
// ${config.copyright}
//
% endif
% if hasattr(config, 'license'):
// ${config.license}
//
% endif
// Module: secure_image_core (for ${config.device.type})
//
// Description:
//
//   The RFNoC Secure Image Core contains the Verilog description of the parts
//   of the RFNoC design that require additional security.
//
//   This file was automatically generated by the RFNoC image builder tool.
//   Re-running that tool will overwrite this file!
//
% if args.get('source'):
// Source: ${args.get('source')}
% endif
%if not args.get('no_date'):
// File generated on: ${datetime.datetime.now().isoformat()}
% endif
% if args.get('source_hash') and not args.get('no_hash'):
// Source SHA256: ${args.get('source_hash')}
% endif
//

<%
  def p(pad_len):
    return lambda text: ("{text:>" + str(pad_len) + "}").format(text=text)
%>\

`default_nettype none


module secure_image_core #(
% if config.noc_blocks:
  parameter int    BLOCK_PORT_IDS [${len(config.noc_blocks) - 1}:0] = {${", ".join(f"{i}" for i in range(len(config.noc_blocks)))}},
% endif
  parameter        CHDR_W       = ${config.chdr_width},
  parameter        BLOCK_CHDR_W = ${config.block_chdr_width},
  parameter [15:0] PROTOVER     = {8'd1, 8'd0},
  parameter        BLOCK_MTU    = 0
) (
  // Global Clocks and Resets
  input  wire              chdr_aclk,
  input  wire              ctrl_aclk,
  input  wire              core_arst,
  input  wire              rfnoc_ctrl_clk,
  input  wire              rfnoc_chdr_clk,
  input  wire              rfnoc_ctrl_rst,
  input  wire              rfnoc_chdr_rst,
% for clk_rst, attr_name, default_names in (('clk', 'clocks', config.DEFAULT_CLK_NAMES), ('rst', 'resets', config.DEFAULT_RST_NAMES)):
<%
  clk_rst_list = [
    c for c in getattr(config.device, attr_name)
    if c['name'] not in default_names
  ]
%>\
  % for c in clk_rst_list:
    % if loop.first:
  // Custom ${attr_name} for secure image core
    % endif
<% wire_dir = {'in': 'output', 'out': 'input'}[c['direction']] %>\
  ${wire_dir} wire               ${c['name']}_${clk_rst},
  % endfor
% endfor
<%include
  file="/modules/device_io_ports.v.mako"
  args="io_ports=config.device.io_ports, config=config, width_pad=12, final_ports=False"/>\
% for block_name, block_info in config.noc_blocks.items():
  % if loop.first:
  // Block ports for secure image core
  % endif
  // ${block_name}
  % for port_name, port_info in block_info['data']['inputs'].items():
  input  wire [BLOCK_CHDR_W-1:0] s_${block_name}_${port_name}_tdata ,
  input  wire                    s_${block_name}_${port_name}_tlast ,
  output wire                    s_${block_name}_${port_name}_tready,
  input  wire                    s_${block_name}_${port_name}_tvalid,
  % endfor
  % for port_name, port_info in block_info['data']['outputs'].items():
  output wire [BLOCK_CHDR_W-1:0] m_${block_name}_${port_name}_tdata ,
  output wire                    m_${block_name}_${port_name}_tlast ,
  input  wire                    m_${block_name}_${port_name}_tready,
  output wire                    m_${block_name}_${port_name}_tvalid,
  % endfor
  input  wire [            31:0] s_${block_name}_ctrl_tdata ,
  input  wire                    s_${block_name}_ctrl_tlast ,
  output wire                    s_${block_name}_ctrl_tready,
  input  wire                    s_${block_name}_ctrl_tvalid,
  output wire [            31:0] m_${block_name}_ctrl_tdata ,
  output wire                    m_${block_name}_ctrl_tlast ,
  input  wire                    m_${block_name}_ctrl_tready,
  output wire                    m_${block_name}_ctrl_tvalid,
% endfor
% if config.get_ta_gen_mode() == 'user_defined':
  % for ta_name, ta in config.transport_adapters.items():
    % if loop.first:
  // TA data ports for secure image core
    % endif
<%
  num_ports = sum(p.get('num_ports', 1) for p in ta.data.get('inputs', {}).values())
%>\
    % for n in range(num_ports):
  input  wire [CHDR_W-1:0] ${f"xb_to_{ta_name}_{n}_tdata " | p(8)},
  input  wire              ${f"xb_to_{ta_name}_{n}_tlast " | p(8)},
  output wire              ${f"xb_to_{ta_name}_{n}_tready" | p(8)},
  input  wire              ${f"xb_to_{ta_name}_{n}_tvalid" | p(8)},
    % endfor
    % for n in range(num_ports):
  output wire [CHDR_W-1:0] ${f"{ta_name}_{n}_to_xb_tdata " | p(8)},
  output wire              ${f"{ta_name}_{n}_to_xb_tlast " | p(8)},
  input  wire              ${f"{ta_name}_{n}_to_xb_tready" | p(8)},
  output wire              ${f"{ta_name}_{n}_to_xb_tvalid" | p(8)},
    % endfor
  % endfor
% endif
% if config.noc_blocks:
  // Backend interface
  input  wire [${f"512*{len(config.noc_blocks)}-1" | p(8)}:0] rfnoc_core_config,
  output wire [${f"512*{len(config.noc_blocks)}-1" | p(8)}:0] rfnoc_core_status,
% endif
  input wire               __terminate
);

% if config.get_ta_gen_mode() == 'user_defined':
  //---------------------------------------------------------------------------
  // Transport Adapters
  //---------------------------------------------------------------------------

% for ta_name, ta in config.transport_adapters.items():
<%include
  file="/modules/transport_adapter.v.mako"
  args="ta_name=ta_name, ta=ta, config=config, core_domain='secure_core'"
/>\
% endfor

% endif

%for i, name in enumerate(config.noc_blocks):
<%include
  file="/modules/rfnoc_block.v.mako"
  args="i=i, block_name=name, config=config, core_domain='secure_core'"
/>\
%endfor

% for i, name in enumerate(config.modules):
  % if loop.first:
  //---------------------------------------------------------------------------
  // Generic Modules
  //---------------------------------------------------------------------------

  % endif
<%include
  file="/modules/module.v.mako"
  args="i=i, module_name=name, config=config, core_domain='secure_core'"
/>\
% endfor

  //---------------------------------------------------------------------------
  // Clock Domains and Resets
  //---------------------------------------------------------------------------
<%include
  file="/modules/connect_clk_domains.v.mako"
  args="connections=config.clk_domains, core_domain='secure_core', clk_or_rst='clk'"
/>\
<%include
  file="/modules/connect_clk_domains.v.mako"
  args="connections=config.resets, core_domain='secure_core', clk_or_rst='rst'"
/>\


  //---------------------------------------------------------------------------
  // IO Port Connection
  //---------------------------------------------------------------------------

  // Master/Slave Connections:
<%include
  file="/modules/connect_io_ports.v.mako"
  args="connections=[c for c in config.connections if c['srctype'] == 'master'], core_domain='secure_core'"
/>\
  // Broadcaster/Listener Connections:
<%include
  file="/modules/connect_io_ports.v.mako"
  args="connections=[c for c in config.connections if c['srctype'] == 'broadcaster'], core_domain='secure_core'"
/>\

endmodule

`default_nettype wire
