/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.widgets;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.GridLayout;
import com.jogamp.graph.ui.widgets.RangeSlider;
import com.jogamp.graph.ui.widgets.Widget;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.Cube;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;

public class RangedGroup
extends Widget {
    private final Group content;
    private final Group clippedContent;
    private final RangeSlider horizSlider;
    private final RangeSlider vertSlider;
    private final Vec2f contentPosZero = new Vec2f();
    private final Frustum tempF00 = new Frustum();
    private final Cube tempC00 = new Cube();

    public RangedGroup(int n, Group group, Vec2f vec2f, SliderParam sliderParam, SliderParam sliderParam2) {
        super(new GridLayout(1 + (null != sliderParam2 ? 1 : 0), 0.0f, 0.0f, Alignment.None));
        this.content = group;
        this.clippedContent = new Group(new GridLayout(1, 0.0f, 0.0f, Alignment.None));
        this.clippedContent.setFixedSize(vec2f);
        this.clippedContent.addShape(group);
        this.addShape(this.clippedContent);
        if (null != sliderParam) {
            this.horizSlider = new RangeSlider(n, sliderParam.size, new Vec2f(0.0f, group.getBounds().getWidth()), sliderParam.unitSize, vec2f.x(), 0.0f).setInverted(sliderParam.inverted);
            this.addShape(this.horizSlider);
            this.horizSlider.addChangeListener((rangeSlider, f, f2, f3, f4, vec3f, mouseEvent) -> {
                Vec3f vec3f2 = group.getPosition();
                if (this.horizSlider.isInverted()) {
                    group.moveTo(this.contentPosZero.x() - f2, vec3f2.y(), vec3f2.z());
                } else {
                    group.moveTo(this.contentPosZero.x() + f2, vec3f2.y(), vec3f2.z());
                }
            });
        } else {
            this.horizSlider = null;
        }
        if (null != sliderParam2) {
            this.vertSlider = new RangeSlider(n, sliderParam2.size, new Vec2f(0.0f, group.getBounds().getHeight()), sliderParam2.unitSize, vec2f.y(), 0.0f).setInverted(sliderParam2.inverted);
            this.addShape(this.vertSlider);
            this.vertSlider.addChangeListener((rangeSlider, f, f2, f3, f4, vec3f, mouseEvent) -> {
                Vec3f vec3f2 = group.getPosition();
                if (this.vertSlider.isInverted()) {
                    group.moveTo(vec3f2.x(), this.contentPosZero.y() + f2, vec3f2.z());
                } else {
                    group.moveTo(vec3f2.x(), this.contentPosZero.y() - f2, vec3f2.z());
                }
            });
        } else {
            this.vertSlider = null;
        }
        this.onDraw((shape, gL2ES2, regionRenderer) -> {
            group.moveTo(this.contentPosZero.x(), this.contentPosZero.y(), 0.0f);
            return true;
        });
    }

    public Group getContent() {
        return this.content;
    }

    public Vec2f getContentSize(Vec2f vec2f) {
        return this.clippedContent.getFixedSize(vec2f);
    }

    public Group getClippedContent() {
        return this.clippedContent;
    }

    public RangeSlider getHorizSlider() {
        return this.horizSlider;
    }

    public RangeSlider getVertSlider() {
        return this.vertSlider;
    }

    @Override
    protected void validateImpl(GL2ES2 gL2ES2, GLProfile gLProfile) {
        if (this.isShapeDirty()) {
            Vec3f vec3f = this.content.getPosition().copy();
            super.validateImpl(gL2ES2, gLProfile);
            AABBox aABBox = this.content.getBounds();
            Vec3f vec3f2 = this.clippedContent.getFixedSize();
            this.contentPosZero.set(0, 0.0f);
            if (null != this.horizSlider) {
                this.horizSlider.setMinMax(new Vec2f(0.0f, this.content.getBounds().getWidth()));
                if (this.horizSlider.isInverted()) {
                    this.contentPosZero.setX(aABBox.getWidth() - vec3f2.x());
                }
            }
            if (null != this.vertSlider) {
                this.vertSlider.setMinMax(new Vec2f(0.0f, this.content.getBounds().getHeight()));
                if (this.vertSlider.isInverted()) {
                    this.contentPosZero.setY(vec3f2.y() - aABBox.getHeight());
                }
            }
            this.content.moveTo(vec3f);
        }
    }

    @Override
    protected void drawImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer, Vec4f vec4f) {
        if (this.content.isVisible()) {
            PMVMatrix4f pMVMatrix4f = regionRenderer.getMatrix();
            Frustum frustum = this.tempC00.set(this.clippedContent.getBounds()).transform(pMVMatrix4f.getMv()).updateFrustumPlanes(this.tempF00);
            this.content.setClipMvFrustum(frustum);
            super.drawImpl0(gL2ES2, regionRenderer, vec4f);
            this.content.setClipMvFrustum(null);
        }
    }

    public static final class SliderParam {
        public final Vec2f size;
        public final float unitSize;
        public final boolean inverted;

        public SliderParam(Vec2f vec2f, float f, boolean bl) {
            this.size = vec2f;
            this.unitSize = f;
            this.inverted = bl;
        }
    }
}

