---
stage: none
group: Tutorials
info: For assistance with this tutorials page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
description: 計画、アジャイル、イシューボード
title: 'チュートリアル: 作業の計画と追跡する'
---

コードをホストするプロジェクトを作成し、イシュー、エピックなどを使用して作業を計画します。

## 基本を学ぶ {#learn-the-fundamentals}

ここでは、GitLabの計画機能について説明します。

| トピック | 説明 | 初心者向け |
|-------|-------------|--------------------|
| [GitLabアジャイルプロジェクト管理](https://university.gitlab.com/courses/gitlab-agile-project-management-s2) | この自分のペースで進められるコースで、計画機能を使用してプロジェクトを管理する方法を学びます。 | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [エピックとイシューボード](https://www.youtube.com/watch?v=eQUnHwbKEkY) | プロジェクト管理にエピックとイシューボードを使用する方法をご覧ください。 | {{< icon name="star" >}} |
| <i class="fa fa-youtube-play youtube" aria-hidden="true"></i> [ポートフォリオ計画 - ポートフォリオ管理](https://www.youtube.com/watch?v=d9scVJUIF4c) | 要件、イシュー、エピック、マイルストーン、およびタイムトラッキングでポートフォリオを管理する方法をご覧ください。 | {{< icon name="star" >}} |

## プロジェクトの設定と管理 {#set-up-and-manage-projects}

ワークフローを効果的に管理するために、プロジェクトを設定します。

| トピック | 説明 | 初心者向け |
|-------|-------------|--------------------|
| [アイデア管理用のプロジェクトをセットアップする](idea_management/_index.md) | イシューボードとスコープ付きラベルを使用して、チームでアイデアを管理します。 | {{< icon name="star" >}} |
| [イシュートリアージ用のプロジェクトをセットアップする](issue_triage/_index.md) | ラベルを使用して、イシューのトリアージのプロジェクトを設定します。 | {{< icon name="star" >}} |
| [イシュートリアージ用のプロジェクトをセットアップする](issue_triage_group/_index.md) | ラベルを使用して、イシューのトリアージの複数のプロジェクトを含むグループを設定します。 | |
| [イシュートリアージ用のプロジェクトをセットアップする](issue_triage_complex_group/_index.md) | ラベルを使用して、イシュートリアージ用のサブグループを含む複雑なグループをセットアップします。 | |
| [プロジェクト用の保護されたワークフローを構築する](protected_workflow/_index.md) | チームのワークフローを設定し、承認ルールで保護を強制します。 | |

## ワークフローを選択 {#choose-your-workflow}

好みのアジャイルフレームワークを実装するために、計画機能を使用する方法を学びます。

| トピック | 説明 | 初心者向け |
|-------|-------------|--------------------|
| [KanbanにGitLabを使用する](kanban/_index.md) | イシューボード、スコープ付きラベル、およびバリューストリーム分析をKanbanに使用します。 | {{< icon name="star" >}} |
| [アジャイルイテレーションの実行](agile_sprint/_index.md) | グループ、プロジェクト、およびイテレーションを使用して、アジャイル開発イテレーションを実行します。 | |
| [ScrumにGitLabを使用する](scrum_events/_index.md) | GitLabでコアScrumセレモニーとワークフローを実行する方法を学びます。 | |

## チームとのコラボレーション {#collaborate-with-your-team}

チームの連携とコラボレーションのためのワークフローを最適化します。

| トピック | 説明 | 初心者向け |
|-------|-------------|--------------------|
| [チーム間の引き継ぎ用のイシューボードをセットアップする](boards_for_teams/_index.md) | イシューボードとスコープ付きラベルを使用して、多くのチーム間でコラボレーションを設定します。 | {{< icon name="star" >}} |
| [チームスタンドアップ用のイシューボードをセットアップする](boards_for_standups/_index.md) | イシューボードとワークフローのラベルを使用して、チームのスタンドアップを促進します。 | {{< icon name="star" >}} |
