/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.RigidTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/AbstractNullabilityChecker\n+ 2 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,907:1\n141#2,13:908\n154#2,13:922\n141#2,13:935\n154#2,13:949\n1#3:921\n1#3:948\n*S KotlinDebug\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/AbstractNullabilityChecker\n*L\n849#1:908,13\n849#1:922,13\n863#1:935,13\n863#1:949,13\n849#1:921\n863#1:948\n*E\n"})
public final class AbstractNullabilityChecker {
    @NotNull
    public static final AbstractNullabilityChecker INSTANCE = new AbstractNullabilityChecker();

    private AbstractNullabilityChecker() {
    }

    public final boolean isPossibleSubtype(@NotNull TypeCheckerState state, @NotNull RigidTypeMarker subType, @NotNull RigidTypeMarker superType) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)subType, (String)"subType");
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        return this.runIsPossibleSubtype(state, subType, superType);
    }

    private final boolean runIsPossibleSubtype(TypeCheckerState state, RigidTypeMarker subType, RigidTypeMarker superType) {
        TypeSystemContext $this$runIsPossibleSubtype_u24lambda_u240 = state.getTypeSystemContext();
        boolean bl = false;
        if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
            boolean bl2;
            boolean bl3 = bl2 = $this$runIsPossibleSubtype_u24lambda_u240.isSingleClassifierType(subType) || $this$runIsPossibleSubtype_u24lambda_u240.isIntersection($this$runIsPossibleSubtype_u24lambda_u240.typeConstructor(subType)) || state.isAllowedTypeVariable(subType);
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-AbstractNullabilityChecker$runIsPossibleSubtype$1$32 = false;
                String $i$a$-assert-AbstractNullabilityChecker$runIsPossibleSubtype$1$32 = "Not singleClassifierType and not intersection subType: " + subType;
                throw new AssertionError((Object)$i$a$-assert-AbstractNullabilityChecker$runIsPossibleSubtype$1$32);
            }
            boolean bl4 = bl2 = $this$runIsPossibleSubtype_u24lambda_u240.isSingleClassifierType(superType) || state.isAllowedTypeVariable(superType);
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string = "Not singleClassifierType superType: " + superType;
                throw new AssertionError((Object)string);
            }
        }
        if ($this$runIsPossibleSubtype_u24lambda_u240.isMarkedNullable(superType)) {
            return true;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u240.isNotNullTypeParameter(subType)) {
            return true;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u240.isDefinitelyNotNullType(subType)) {
            return true;
        }
        if (subType instanceof CapturedTypeMarker && $this$runIsPossibleSubtype_u24lambda_u240.isProjectionNotNull((CapturedTypeMarker)subType)) {
            return true;
        }
        if (INSTANCE.hasNotNullSupertype(state, subType, TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u240.isDefinitelyNotNullType(superType)) {
            return false;
        }
        if (INSTANCE.hasNotNullSupertype(state, superType, TypeCheckerState.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u240.isClassType(subType)) {
            return false;
        }
        return INSTANCE.hasPathByNotMarkedNullableNodes(state, subType, $this$runIsPossibleSubtype_u24lambda_u240.typeConstructor(superType));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasNotNullSupertype(@NotNull TypeCheckerState $this$hasNotNullSupertype, @NotNull RigidTypeMarker type, @NotNull TypeCheckerState.SupertypesPolicy supertypesPolicy) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$hasNotNullSupertype, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)supertypesPolicy, (String)"supertypesPolicy");
            TypeSystemContext $this$hasNotNullSupertype_u24lambda_u240 = $this$hasNotNullSupertype.getTypeSystemContext();
            boolean bl2 = false;
            TypeCheckerState typeCheckerState = $this$hasNotNullSupertype;
            RigidTypeMarker start$iv = type;
            boolean $i$f$anySupertype = false;
            RigidTypeMarker it = start$iv;
            boolean bl3 = false;
            if ($this$hasNotNullSupertype_u24lambda_u240.isClassType(it) && !$this$hasNotNullSupertype_u24lambda_u240.isMarkedNullable(it) || $this$hasNotNullSupertype_u24lambda_u240.isDefinitelyNotNullType(it)) {
                bl = true;
            } else {
                void this_$iv;
                this_$iv.initialize();
                ArrayDeque<RigidTypeMarker> arrayDeque = this_$iv.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<RigidTypeMarker> deque$iv = arrayDeque;
                Set<RigidTypeMarker> set = this_$iv.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<RigidTypeMarker> visitedSupertypes$iv = set;
                deque$iv.push(start$iv);
                while (!((Collection)deque$iv).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy policy$iv;
                    RigidTypeMarker current$iv = deque$iv.pop();
                    Intrinsics.checkNotNull((Object)current$iv);
                    if (!visitedSupertypes$iv.add(current$iv)) continue;
                    it = current$iv;
                    boolean bl4 = false;
                    TypeCheckerState.SupertypesPolicy supertypesPolicy2 = $this$hasNotNullSupertype_u24lambda_u240.isMarkedNullable(it) ? (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.None.INSTANCE : supertypesPolicy;
                    TypeCheckerState.SupertypesPolicy it$iv = supertypesPolicy2;
                    boolean bl5 = false;
                    if ((!Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? supertypesPolicy2 : null) == null) continue;
                    policy$iv = policy$iv;
                    TypeSystemContext $this$anySupertype_u24lambda_u241$iv = this_$iv.getTypeSystemContext();
                    boolean bl6 = false;
                    Collection<KotlinTypeMarker> supertypes$iv = $this$anySupertype_u24lambda_u241$iv.supertypes($this$anySupertype_u24lambda_u241$iv.typeConstructor(current$iv));
                    for (KotlinTypeMarker supertype$iv : supertypes$iv) {
                        RigidTypeMarker newType$iv;
                        it = newType$iv = policy$iv.transformType((TypeCheckerState)this_$iv, supertype$iv);
                        bl3 = false;
                        if ($this$hasNotNullSupertype_u24lambda_u240.isClassType(it) && !$this$hasNotNullSupertype_u24lambda_u240.isMarkedNullable(it) || $this$hasNotNullSupertype_u24lambda_u240.isDefinitelyNotNullType(it)) {
                            this_$iv.clear();
                            bl = true;
                            break block5;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                this_$iv.clear();
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasPathByNotMarkedNullableNodes(@NotNull TypeCheckerState state, @NotNull RigidTypeMarker start, @NotNull TypeConstructorMarker end) {
        boolean bl;
        block5: {
            void start$iv;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            TypeSystemContext $this$hasPathByNotMarkedNullableNodes_u24lambda_u240 = state.getTypeSystemContext();
            boolean bl2 = false;
            TypeCheckerState typeCheckerState = state;
            RigidTypeMarker rigidTypeMarker = start;
            boolean $i$f$anySupertype = false;
            RigidTypeMarker it = start$iv;
            boolean bl3 = false;
            if (INSTANCE.isApplicableAsEndNode(state, it, end)) {
                bl = true;
            } else {
                void this_$iv;
                this_$iv.initialize();
                ArrayDeque<RigidTypeMarker> arrayDeque = this_$iv.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<RigidTypeMarker> deque$iv = arrayDeque;
                Set<RigidTypeMarker> set = this_$iv.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<RigidTypeMarker> visitedSupertypes$iv = set;
                deque$iv.push((RigidTypeMarker)start$iv);
                while (!((Collection)deque$iv).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy policy$iv;
                    RigidTypeMarker current$iv = deque$iv.pop();
                    Intrinsics.checkNotNull((Object)current$iv);
                    if (!visitedSupertypes$iv.add(current$iv)) continue;
                    it = current$iv;
                    boolean bl4 = false;
                    TypeCheckerState.SupertypesPolicy supertypesPolicy = $this$hasPathByNotMarkedNullableNodes_u24lambda_u240.isMarkedNullable(it) ? (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.None.INSTANCE : (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    TypeCheckerState.SupertypesPolicy it$iv = supertypesPolicy;
                    boolean bl5 = false;
                    if ((!Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? supertypesPolicy : null) == null) continue;
                    policy$iv = policy$iv;
                    TypeSystemContext $this$anySupertype_u24lambda_u241$iv = this_$iv.getTypeSystemContext();
                    boolean bl6 = false;
                    Collection<KotlinTypeMarker> supertypes$iv = $this$anySupertype_u24lambda_u241$iv.supertypes($this$anySupertype_u24lambda_u241$iv.typeConstructor(current$iv));
                    for (KotlinTypeMarker supertype$iv : supertypes$iv) {
                        RigidTypeMarker newType$iv;
                        it = newType$iv = policy$iv.transformType((TypeCheckerState)this_$iv, supertype$iv);
                        bl3 = false;
                        if (INSTANCE.isApplicableAsEndNode(state, it, end)) {
                            this_$iv.clear();
                            bl = true;
                            break block5;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                this_$iv.clear();
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isApplicableAsEndNode(TypeCheckerState state, RigidTypeMarker type, TypeConstructorMarker end) {
        TypeSystemContext $this$isApplicableAsEndNode_u24lambda_u240 = state.getTypeSystemContext();
        boolean bl = false;
        if ($this$isApplicableAsEndNode_u24lambda_u240.isNothing(type)) {
            return true;
        }
        if ($this$isApplicableAsEndNode_u24lambda_u240.isMarkedNullable(type)) {
            return false;
        }
        if (state.isStubTypeEqualsToAnything() && $this$isApplicableAsEndNode_u24lambda_u240.isStubType(type)) {
            return true;
        }
        return $this$isApplicableAsEndNode_u24lambda_u240.areEqualTypeConstructors($this$isApplicableAsEndNode_u24lambda_u240.typeConstructor(type), end);
    }
}

