/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.util.concurrency.ChildContext;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

final class ContextRunnable
implements Runnable {
    @NotNull
    private final ChildContext myContext;
    @NotNull
    private final Runnable myRunnable;

    @Async.Schedule
    ContextRunnable(@NotNull ChildContext context, @NotNull Runnable runnable) {
        if (context == null) {
            ContextRunnable.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            ContextRunnable.$$$reportNull$$$0(1);
        }
        if (runnable instanceof ContextRunnable) {
            throw new IllegalArgumentException("Can not wrap ContextRunnable into ContextRunnable");
        }
        this.myContext = context;
        this.myRunnable = runnable;
    }

    @Override
    @Async.Execute
    public void run() {
        ThreadContext.resetThreadContext(() -> {
            this.myContext.runInChildContext(this.myRunnable);
            return null;
        });
    }

    public Runnable getDelegate() {
        return this.myRunnable;
    }

    public String toString() {
        return this.myRunnable.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/concurrency/ContextRunnable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

