/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ValueManager;

@ApiStatus.Internal
public abstract class VariablesHost<VALUE_MANAGER extends ValueManager> {
    private static final PromiseManager<VariablesHost, List<Variable>> VARIABLES_LOADER = new PromiseManager<VariablesHost, List<Variable>>(VariablesHost.class){

        public boolean isUpToDate(@NotNull VariablesHost host, @NotNull List<Variable> data) {
            if (host == null) {
                1.$$$reportNull$$$0(0);
            }
            if (data == null) {
                1.$$$reportNull$$$0(1);
            }
            return ((ValueManager)host.valueManager).getCacheStamp() == host.cacheStamp;
        }

        @NotNull
        public Promise load(@NotNull VariablesHost host) {
            if (host == null) {
                1.$$$reportNull$$$0(2);
            }
            Promise<List<Variable>> promise = ((ValueManager)host.valueManager).isObsolete() ? Promises.cancelledPromise() : host.load();
            if (promise == null) {
                1.$$$reportNull$$$0(3);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/debugger/VariablesHost$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/debugger/VariablesHost$1";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isUpToDate";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    };
    private volatile Promise<List<Variable>> result;
    private volatile int cacheStamp;
    public final VALUE_MANAGER valueManager;

    public VariablesHost(@NotNull VALUE_MANAGER manager) {
        if (manager == null) {
            VariablesHost.$$$reportNull$$$0(0);
        }
        this.cacheStamp = -1;
        this.valueManager = manager;
    }

    @NotNull
    public final Promise<List<Variable>> get() {
        Promise promise = VARIABLES_LOADER.get((Object)this);
        if (promise == null) {
            VariablesHost.$$$reportNull$$$0(1);
        }
        return promise;
    }

    @Nullable
    public final Promise.State getState() {
        return VARIABLES_LOADER.getState((Object)this);
    }

    public final void set(@NotNull List<Variable> result) {
        if (result == null) {
            VariablesHost.$$$reportNull$$$0(2);
        }
        this.updateCacheStamp();
        VARIABLES_LOADER.set((Object)this, result);
    }

    @NotNull
    protected abstract Promise<List<Variable>> load();

    public final void updateCacheStamp() {
        this.cacheStamp = ((ValueManager)this.valueManager).getCacheStamp();
    }

    public Promise<?> clearCaches() {
        this.cacheStamp = -1;
        VARIABLES_LOADER.reset((Object)this);
        return Promises.resolvedPromise();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/debugger/VariablesHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/debugger/VariablesHost";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

