/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;

@Service(value={Service.Level.PROJECT})
public final class MavenDomElementDescriptorHolder {
    private static final Logger LOG = Logger.getInstance(MavenDomElementDescriptorHolder.class);
    private final Project myProject;
    private final Map<FileKind, CachedValue<XmlNSDescriptorImpl>> myDescriptorsMap = new HashMap<FileKind, CachedValue<XmlNSDescriptorImpl>>();

    public MavenDomElementDescriptorHolder(Project project) {
        this.myProject = project;
    }

    public static MavenDomElementDescriptorHolder getInstance(@NotNull Project project) {
        if (project == null) {
            MavenDomElementDescriptorHolder.$$$reportNull$$$0(0);
        }
        return (MavenDomElementDescriptorHolder)project.getService(MavenDomElementDescriptorHolder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlElementDescriptor getDescriptor(@NotNull XmlTag tag) {
        XmlNSDescriptorImpl desc;
        FileKind kind;
        if (tag == null) {
            MavenDomElementDescriptorHolder.$$$reportNull$$$0(1);
        }
        if ((kind = MavenDomElementDescriptorHolder.getFileKind(tag.getContainingFile())) == null) {
            return null;
        }
        MavenDomElementDescriptorHolder mavenDomElementDescriptorHolder = this;
        synchronized (mavenDomElementDescriptorHolder) {
            desc = this.tryGetOrCreateDescriptor(kind);
            if (desc == null) {
                return null;
            }
        }
        LOG.assertTrue(tag.isValid());
        LOG.assertTrue(desc.isValid());
        return desc.getElementDescriptor(tag.getName(), desc.getDefaultNamespace());
    }

    @Nullable
    private XmlNSDescriptorImpl tryGetOrCreateDescriptor(FileKind kind) {
        CachedValue result2 = this.myDescriptorsMap.get((Object)kind);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.doCreateDescriptor(kind), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            this.myDescriptorsMap.put(kind, (CachedValue<XmlNSDescriptorImpl>)result2);
        }
        return (XmlNSDescriptorImpl)result2.getValue();
    }

    @Nullable
    private XmlNSDescriptorImpl doCreateDescriptor(FileKind kind) {
        VirtualFile schema;
        String location;
        String schemaUrl = kind.getSchemaUrl();
        if (schemaUrl.equals(location = ExternalResourceManager.getInstance().getResourceLocation(schemaUrl))) {
            return null;
        }
        try {
            schema = VfsUtil.findFileByURL((URL)new URL(location));
        }
        catch (MalformedURLException ignore) {
            return null;
        }
        if (schema == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(schema);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlNSDescriptorImpl result2 = new XmlNSDescriptorImpl();
        result2.init((PsiElement)psiFile);
        return result2;
    }

    @Nullable
    private static FileKind getFileKind(PsiFile file2) {
        if (MavenDomUtil.isProjectFile(file2)) {
            return MavenDomElementDescriptorHolder.getProjectFileKind(file2);
        }
        if (MavenDomUtil.isProfilesFile(file2)) {
            return FileKind.PROFILES_FILE;
        }
        if (MavenDomUtil.isSettingsFile(file2)) {
            return MavenDomElementDescriptorHolder.getSettingsFileKind(file2);
        }
        return null;
    }

    @NotNull
    private static FileKind getProjectFileKind(PsiFile file2) {
        String modelVersion = MavenDomUtil.getXmlProjectModelVersion(file2);
        if ("4.1.0".equals(modelVersion)) {
            FileKind fileKind = FileKind.PROJECT_FILE_4_1;
            if (fileKind == null) {
                MavenDomElementDescriptorHolder.$$$reportNull$$$0(2);
            }
            return fileKind;
        }
        FileKind fileKind = FileKind.PROJECT_FILE_4_0;
        if (fileKind == null) {
            MavenDomElementDescriptorHolder.$$$reportNull$$$0(3);
        }
        return fileKind;
    }

    @NotNull
    private static FileKind getSettingsFileKind(PsiFile file2) {
        String nameSpace = MavenDomUtil.getXmlSettingsNameSpace(file2);
        if (nameSpace == null) {
            FileKind fileKind = FileKind.SETTINGS_FILE;
            if (fileKind == null) {
                MavenDomElementDescriptorHolder.$$$reportNull$$$0(4);
            }
            return fileKind;
        }
        if (nameSpace.contains("1.1.0")) {
            FileKind fileKind = FileKind.SETTINGS_FILE_1_1;
            if (fileKind == null) {
                MavenDomElementDescriptorHolder.$$$reportNull$$$0(5);
            }
            return fileKind;
        }
        if (nameSpace.contains("1.2.0")) {
            FileKind fileKind = FileKind.SETTINGS_FILE_1_2;
            if (fileKind == null) {
                MavenDomElementDescriptorHolder.$$$reportNull$$$0(6);
            }
            return fileKind;
        }
        FileKind fileKind = FileKind.SETTINGS_FILE;
        if (fileKind == null) {
            MavenDomElementDescriptorHolder.$$$reportNull$$$0(7);
        }
        return fileKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/MavenDomElementDescriptorHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenDomElementDescriptorHolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFileKind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFileKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static enum FileKind {
        PROJECT_FILE_4_0{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/maven-4.0.0.xsd";
            }
        }
        ,
        PROJECT_FILE_4_1{

            @Override
            public String getSchemaUrl() {
                return "https://maven.apache.org/xsd/maven-4.1.0.xsd";
            }
        }
        ,
        PROFILES_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/profiles-1.0.0.xsd";
            }
        }
        ,
        SETTINGS_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/settings-1.0.0.xsd";
            }
        }
        ,
        SETTINGS_FILE_1_1{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/settings-1.1.0.xsd";
            }
        }
        ,
        SETTINGS_FILE_1_2{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/settings-1.2.0.xsd";
            }
        };


        public abstract String getSchemaUrl();
    }
}

