/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxImportClassFix;

public final class JavaFxTagNameReference
extends TagNameReference {
    private static final Logger LOGGER = Logger.getInstance(JavaFxTagNameReference.class);

    public JavaFxTagNameReference(ASTNode element, boolean startTagFlag) {
        super(element, startTagFlag);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange rangeInElement = super.getRangeInElement();
        XmlTag tagElement = this.getTagElement();
        if (tagElement != null) {
            String tagElementName = tagElement.getName();
            int dotIdx = tagElementName.indexOf(".");
            int startOffset = rangeInElement.getStartOffset();
            if (dotIdx > -1 && startOffset + dotIdx + 2 < rangeInElement.getEndOffset()) {
                return new TextRange(startOffset + dotIdx + 1, rangeInElement.getEndOffset());
            }
        }
        TextRange textRange = rangeInElement;
        if (textRange == null) {
            JavaFxTagNameReference.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String qualifiedName;
        if (element == null) {
            JavaFxTagNameReference.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiClass && (qualifiedName = ((PsiClass)element).getQualifiedName()) != null) {
            String shortName = StringUtil.getShortName((String)qualifiedName);
            XmlTag tagElement = this.getTagElement();
            if (tagElement != null) {
                String oldTagName = tagElement.getName();
                if (oldTagName.contains(".")) {
                    return tagElement.setName(qualifiedName);
                }
                return tagElement.setName(shortName);
            }
            return this.getElement();
        }
        return super.bindToElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static final class JavaFxUnresolvedTagRefsProvider
    extends UnresolvedReferenceQuickFixProvider<JavaFxTagNameReference> {
        public void registerFixes(@NotNull JavaFxTagNameReference ref, @NotNull QuickFixActionRegistrar registrar) {
            XmlTag element;
            if (ref == null) {
                JavaFxUnresolvedTagRefsProvider.$$$reportNull$$$0(0);
            }
            if (registrar == null) {
                JavaFxUnresolvedTagRefsProvider.$$$reportNull$$$0(1);
            }
            if ((element = ref.getTagElement()) != null) {
                registrar.register((IntentionAction)new JavaFxImportClassFix(this, ref, element){

                    @Override
                    XmlTag getTagElement(@NotNull JavaFxTagNameReference ref) {
                        if (ref == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return ref.getTagElement();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference$JavaFxUnresolvedTagRefsProvider$1", "getTagElement"));
                    }
                });
            }
        }

        @NotNull
        public Class<JavaFxTagNameReference> getReferenceClass() {
            return JavaFxTagNameReference.class;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "registrar";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxTagNameReference$JavaFxUnresolvedTagRefsProvider";
            objectArray[2] = "registerFixes";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

