/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.api.CellAttributes;
import org.jetbrains.kotlinx.dataframe.api.RgbColor;
import org.jetbrains.kotlinx.dataframe.impl.api.FormatKt;
import org.jetbrains.kotlinx.dataframe.impl.api.SingleAttribute;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0005J\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0005J\u001e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J6\u0010*\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00050-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00050-J6\u0010/\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00050-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00050-R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010#\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010%\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlinx/dataframe/api/FormattingDsl;", "", "<init>", "()V", "rgb", "Lorg/jetbrains/kotlinx/dataframe/api/RgbColor;", "r", "", "g", "b", "black", "getBlack", "()Lorg/jetbrains/kotlinx/dataframe/api/RgbColor;", "white", "getWhite", "green", "getGreen", "red", "getRed", "blue", "getBlue", "gray", "getGray", "darkGray", "getDarkGray", "lightGray", "getLightGray", "attr", "Lorg/jetbrains/kotlinx/dataframe/api/CellAttributes;", "name", "", "value", "background", "color", "textColor", "italic", "getItalic", "()Lorg/jetbrains/kotlinx/dataframe/api/CellAttributes;", "bold", "getBold", "underline", "getUnderline", "linearBg", "", "from", "Lkotlin/Pair;", "to", "linear", "core"})
public final class FormattingDsl {
    @NotNull
    public static final FormattingDsl INSTANCE = new FormattingDsl();
    @NotNull
    private static final RgbColor black = INSTANCE.rgb((short)0, (short)0, (short)0);
    @NotNull
    private static final RgbColor white = INSTANCE.rgb((short)255, (short)255, (short)255);
    @NotNull
    private static final RgbColor green = INSTANCE.rgb((short)0, (short)255, (short)0);
    @NotNull
    private static final RgbColor red = INSTANCE.rgb((short)255, (short)0, (short)0);
    @NotNull
    private static final RgbColor blue = INSTANCE.rgb((short)0, (short)0, (short)255);
    @NotNull
    private static final RgbColor gray = INSTANCE.rgb((short)128, (short)128, (short)128);
    @NotNull
    private static final RgbColor darkGray = INSTANCE.rgb((short)169, (short)169, (short)169);
    @NotNull
    private static final RgbColor lightGray = INSTANCE.rgb((short)211, (short)211, (short)211);
    @NotNull
    private static final CellAttributes italic = INSTANCE.attr("font-style", "italic");
    @NotNull
    private static final CellAttributes bold = INSTANCE.attr("font-weight", "bold");
    @NotNull
    private static final CellAttributes underline = INSTANCE.attr("text-decoration", "underline");

    private FormattingDsl() {
    }

    @NotNull
    public final RgbColor rgb(short r, short g, short b) {
        return new RgbColor(r, g, b);
    }

    @NotNull
    public final RgbColor getBlack() {
        return black;
    }

    @NotNull
    public final RgbColor getWhite() {
        return white;
    }

    @NotNull
    public final RgbColor getGreen() {
        return green;
    }

    @NotNull
    public final RgbColor getRed() {
        return red;
    }

    @NotNull
    public final RgbColor getBlue() {
        return blue;
    }

    @NotNull
    public final RgbColor getGray() {
        return gray;
    }

    @NotNull
    public final RgbColor getDarkGray() {
        return darkGray;
    }

    @NotNull
    public final RgbColor getLightGray() {
        return lightGray;
    }

    @NotNull
    public final CellAttributes attr(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new SingleAttribute(name, value);
    }

    @NotNull
    public final CellAttributes background(@NotNull RgbColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return this.attr("background-color", color.toString());
    }

    @NotNull
    public final CellAttributes background(short r, short g, short b) {
        return this.background(new RgbColor(r, g, b));
    }

    @NotNull
    public final CellAttributes textColor(@NotNull RgbColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return this.attr("color", color.toString());
    }

    @NotNull
    public final CellAttributes textColor(short r, short g, short b) {
        return this.textColor(new RgbColor(r, g, b));
    }

    @NotNull
    public final CellAttributes getItalic() {
        return italic;
    }

    @NotNull
    public final CellAttributes getBold() {
        return bold;
    }

    @NotNull
    public final CellAttributes getUnderline() {
        return underline;
    }

    @NotNull
    public final CellAttributes linearBg(@NotNull Number value, @NotNull Pair<? extends Number, RgbColor> from, @NotNull Pair<? extends Number, RgbColor> to) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        return this.background(this.linear(value, from, to));
    }

    @NotNull
    public final RgbColor linear(@NotNull Number value, @NotNull Pair<? extends Number, RgbColor> from, @NotNull Pair<? extends Number, RgbColor> to) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        double a = ((Number)from.getFirst()).doubleValue();
        double b = ((Number)to.getFirst()).doubleValue();
        return a < b ? FormatKt.linearGradient(value.doubleValue(), a, (RgbColor)from.getSecond(), b, (RgbColor)to.getSecond()) : FormatKt.linearGradient(value.doubleValue(), b, (RgbColor)to.getSecond(), a, (RgbColor)from.getSecond());
    }
}

