/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDataKt;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/data/CurrentBranchConditionCache;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "parent", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/openapi/Disposable;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "conditions", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$ConditionHolder;", "getContainedInCurrentBranchCondition", "Ljava/util/function/Predicate;", "", "root", "doGetContainedInCurrentBranchCondition", "clear", "", "dispose", "ConditionHolder", "State", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCurrentBranchConditionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrentBranchConditionCache.kt\ncom/intellij/vcs/log/data/CurrentBranchConditionCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,83:1\n1285#2,2:84\n1299#2,4:86\n216#3,2:90\n*S KotlinDebug\n*F\n+ 1 CurrentBranchConditionCache.kt\ncom/intellij/vcs/log/data/CurrentBranchConditionCache\n*L\n20#1:84,2\n20#1:86,4\n62#1:90,2\n*E\n"})
public final class CurrentBranchConditionCache
implements Disposable {
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Map<VirtualFile, AtomicReference<ConditionHolder>> conditions;

    /*
     * WARNING - void declaration
     */
    public CurrentBranchConditionCache(@NotNull VcsLogData logData, @NotNull Disposable parent) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.logData = logData;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"VcsLog Current Branch Condition", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        Iterable iterable = VcsLogDataKt.getRoots(this.logData);
        CurrentBranchConditionCache currentBranchConditionCache = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var6_7 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Predicate predicate = Predicates.alwaysFalse();
            Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"alwaysFalse(...)");
            AtomicReference<ConditionHolder> atomicReference = new AtomicReference<ConditionHolder>(new ConditionHolder(predicate, State.OUTDATED));
            map.put(t, atomicReference);
        }
        currentBranchConditionCache.conditions = destination$iv$iv;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public final Predicate<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        ConditionHolder inProgress;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        AtomicReference<ConditionHolder> atomicReference = this.conditions.get(root);
        if (atomicReference == null) {
            Predicate predicate = Predicates.alwaysFalse();
            Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"alwaysFalse(...)");
            return predicate;
        }
        AtomicReference<ConditionHolder> holder = atomicReference;
        ConditionHolder oldCondition = holder.get();
        if (oldCondition.isOutdated() && holder.compareAndSet(oldCondition, inProgress = oldCondition.inProgress())) {
            this.executor.execute(() -> CurrentBranchConditionCache.getContainedInCurrentBranchCondition$lambda$0(holder, inProgress, this, root));
        }
        return holder.get().getCondition();
    }

    private final Predicate<Integer> doGetContainedInCurrentBranchCondition(VirtualFile root) {
        DataPack dataPack = this.logData.getDataPack();
        if (dataPack == DataPack.EMPTY) {
            Predicate predicate = Predicates.alwaysFalse();
            Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"alwaysFalse(...)");
            return predicate;
        }
        try {
            String string = VcsLogDataKt.getLogProvider(this.logData, root).getCurrentBranch(root);
            if (string == null) {
                Predicate predicate = Predicates.alwaysFalse();
                Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"alwaysFalse(...)");
                return predicate;
            }
            String branchName = string;
            VcsRef vcsRef = VcsLogUtil.findBranch(dataPack.getRefsModel(), root, branchName);
            if (vcsRef == null) {
                Predicate predicate = Predicates.alwaysFalse();
                Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"alwaysFalse(...)");
                return predicate;
            }
            VcsRef branchRef = vcsRef;
            Hash hash = branchRef.getCommitHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getCommitHash(...)");
            VirtualFile virtualFile = branchRef.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            int branchIndex = this.logData.getCommitIndex(hash, virtualFile);
            return dataPack.getPermanentGraph().getContainedInBranchCondition((Collection)SetsKt.setOf((Object)branchIndex));
        }
        catch (ProcessCanceledException e) {
            Predicate predicate = Predicates.alwaysFalse();
            Intrinsics.checkNotNullExpressionValue((Object)predicate, (String)"alwaysFalse(...)");
            return predicate;
        }
    }

    public final void clear() {
        Map<VirtualFile, AtomicReference<ConditionHolder>> $this$forEach$iv = this.conditions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, AtomicReference<ConditionHolder>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, AtomicReference<ConditionHolder>> element$iv;
            Map.Entry<VirtualFile, AtomicReference<ConditionHolder>> entry = element$iv = iterator.next();
            boolean bl = false;
            AtomicReference<ConditionHolder> holder = entry.getValue();
            holder.updateAndGet(CurrentBranchConditionCache::clear$lambda$0$0);
        }
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    private static final void getContainedInCurrentBranchCondition$lambda$0(AtomicReference $holder, ConditionHolder $inProgress, CurrentBranchConditionCache this$0, VirtualFile $root) {
        if (Intrinsics.areEqual($holder.get(), (Object)$inProgress)) {
            $holder.compareAndSet($inProgress, new ConditionHolder(this$0.doGetContainedInCurrentBranchCondition($root), State.VALID));
        }
    }

    private static final ConditionHolder clear$lambda$0$0(ConditionHolder it) {
        return it.outdated();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0012J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$ConditionHolder;", "", "condition", "Ljava/util/function/Predicate;", "", "state", "Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;", "<init>", "(Ljava/util/function/Predicate;Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;)V", "getCondition", "()Ljava/util/function/Predicate;", "getState", "()Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;", "withState", "s", "outdated", "inProgress", "isOutdated", "", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.vcs.log.impl"})
    private static final class ConditionHolder {
        @NotNull
        private final Predicate<Integer> condition;
        @NotNull
        private final State state;

        public ConditionHolder(@NotNull Predicate<Integer> condition, @NotNull State state) {
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.condition = condition;
            this.state = state;
        }

        @NotNull
        public final Predicate<Integer> getCondition() {
            return this.condition;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        private final ConditionHolder withState(State s) {
            return this.state == s ? this : new ConditionHolder(this.condition, s);
        }

        @NotNull
        public final ConditionHolder outdated() {
            return this.withState(State.OUTDATED);
        }

        @NotNull
        public final ConditionHolder inProgress() {
            return this.withState(State.IN_PROGRESS);
        }

        public final boolean isOutdated() {
            return this.state == State.OUTDATED;
        }

        @NotNull
        public final Predicate<Integer> component1() {
            return this.condition;
        }

        @NotNull
        public final State component2() {
            return this.state;
        }

        @NotNull
        public final ConditionHolder copy(@NotNull Predicate<Integer> condition, @NotNull State state) {
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            return new ConditionHolder(condition, state);
        }

        public static /* synthetic */ ConditionHolder copy$default(ConditionHolder conditionHolder, Predicate predicate, State state, int n, Object object) {
            if ((n & 1) != 0) {
                predicate = conditionHolder.condition;
            }
            if ((n & 2) != 0) {
                state = conditionHolder.state;
            }
            return conditionHolder.copy(predicate, state);
        }

        @NotNull
        public String toString() {
            return "ConditionHolder(condition=" + this.condition + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result = this.condition.hashCode();
            result = result * 31 + this.state.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConditionHolder)) {
                return false;
            }
            ConditionHolder conditionHolder = (ConditionHolder)other;
            if (!Intrinsics.areEqual(this.condition, conditionHolder.condition)) {
                return false;
            }
            return this.state == conditionHolder.state;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/data/CurrentBranchConditionCache$State;", "", "<init>", "(Ljava/lang/String;I)V", "VALID", "OUTDATED", "IN_PROGRESS", "intellij.platform.vcs.log.impl"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State VALID = new State();
        public static final /* enum */ State OUTDATED = new State();
        public static final /* enum */ State IN_PROGRESS = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.VALID, State.OUTDATED, State.IN_PROGRESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

