/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableFromCallableDescriptor;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/FreshVariableNewTypeSubstitutor;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "freshVariables", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/TypeVariableFromCallableDescriptor;", "<init>", "(Ljava/util/List;)V", "getFreshVariables", "()Ljava/util/List;", "substituteNotNullTypeWithConstructor", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "constructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "isEmpty", "", "()Z", "Companion", "resolution"})
public final class FreshVariableNewTypeSubstitutor
implements NewTypeSubstitutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TypeVariableFromCallableDescriptor> freshVariables;
    @NotNull
    private static final FreshVariableNewTypeSubstitutor Empty = new FreshVariableNewTypeSubstitutor(CollectionsKt.emptyList());

    public FreshVariableNewTypeSubstitutor(@NotNull List<TypeVariableFromCallableDescriptor> freshVariables) {
        Intrinsics.checkNotNullParameter(freshVariables, "freshVariables");
        this.freshVariables = freshVariables;
    }

    @NotNull
    public final List<TypeVariableFromCallableDescriptor> getFreshVariables() {
        return this.freshVariables;
    }

    @Override
    @Nullable
    public UnwrappedType substituteNotNullTypeWithConstructor(@NotNull TypeConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        int indexProposal = typeParameterDescriptor.getIndex();
        TypeVariableFromCallableDescriptor typeVariableFromCallableDescriptor = CollectionsKt.getOrNull(this.freshVariables, indexProposal);
        if (typeVariableFromCallableDescriptor == null) {
            return null;
        }
        TypeVariableFromCallableDescriptor typeVariable = typeVariableFromCallableDescriptor;
        if (!Intrinsics.areEqual(typeVariable.getOriginalTypeParameter().getTypeConstructor(), constructor)) {
            return null;
        }
        return typeVariable.getDefaultType();
    }

    @Override
    public boolean isEmpty() {
        return this.freshVariables.isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/FreshVariableNewTypeSubstitutor$Companion;", "", "<init>", "()V", "Empty", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/FreshVariableNewTypeSubstitutor;", "getEmpty", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/FreshVariableNewTypeSubstitutor;", "resolution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FreshVariableNewTypeSubstitutor getEmpty() {
            return Empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

