/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageClassFilterEditor;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageConfigurable
extends SettingsEditor<RunConfigurationBase<?>> {
    private final Project myProject;
    private CoverageClassFilterEditor myClassFilterEditor;
    private CoverageClassFilterEditor myExcludeClassFilterEditor;

    public CoverageConfigurable(RunConfigurationBase<?> config) {
        this.myProject = config.getProject();
    }

    protected void resetEditorFrom(@NotNull RunConfigurationBase<?> runConfiguration) {
        JavaCoverageEnabledConfiguration configuration;
        if (runConfiguration == null) {
            CoverageConfigurable.$$$reportNull$$$0(0);
        }
        if ((configuration = JavaCoverageEnabledConfiguration.getFrom(runConfiguration)) == null) {
            return;
        }
        this.myClassFilterEditor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, true));
        this.myExcludeClassFilterEditor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, false));
    }

    protected void applyEditorTo(@NotNull RunConfigurationBase runConfiguration) {
        Object[] oldCoveragePatterns;
        JavaCoverageEnabledConfiguration configuration;
        if (runConfiguration == null) {
            CoverageConfigurable.$$$reportNull$$$0(1);
        }
        if ((configuration = JavaCoverageEnabledConfiguration.getFrom(runConfiguration)) == null) {
            return;
        }
        Object[] newCoveragePatterns = (ClassFilter[])ArrayUtil.mergeArrays((Object[])this.myClassFilterEditor.getFilters(), (Object[])this.myExcludeClassFilterEditor.getFilters());
        if (newCoveragePatterns.length != (oldCoveragePatterns = (ClassFilter[])ObjectUtils.chooseNotNull((Object)configuration.getCoveragePatterns(), (Object)ClassFilter.EMPTY_ARRAY)).length || !ContainerUtil.newHashSet((Object[])newCoveragePatterns).equals(ContainerUtil.newHashSet((Object[])oldCoveragePatterns))) {
            configuration.setCoveragePatterns((ClassFilter[])newCoveragePatterns);
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel((LayoutManager)new VerticalLayout(4));
        result.add((Component)new TitledSeparator(JavaCoverageBundle.message("record.coverage.filters.title", new Object[0])));
        this.myClassFilterEditor = new CoverageClassFilterEditor(this.myProject);
        result.add((Component)((Object)this.myClassFilterEditor));
        result.add((Component)new TitledSeparator(JavaCoverageBundle.message("exclude.coverage.filters.title", new Object[0])));
        this.myExcludeClassFilterEditor = new CoverageClassFilterEditor(this.myProject){

            @NotNull
            protected ClassFilter createFilter(String pattern) {
                ClassFilter filter = super.createFilter(pattern);
                filter.setInclude(false);
                ClassFilter classFilter = filter;
                if (classFilter == null) {
                    1.$$$reportNull$$$0(0);
                }
                return classFilter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/coverage/CoverageConfigurable$1", "createFilter"));
            }
        };
        result.add((Component)((Object)this.myExcludeClassFilterEditor));
        JPanel jPanel = result;
        if (jPanel == null) {
            CoverageConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    static ClassFilter @NotNull [] getCoveragePatterns(@Nullable JavaCoverageEnabledConfiguration configuration, boolean include) {
        if (configuration == null) {
            if (ClassFilter.EMPTY_ARRAY == null) {
                CoverageConfigurable.$$$reportNull$$$0(3);
            }
            return ClassFilter.EMPTY_ARRAY;
        }
        ClassFilter[] classFilterArray = (ClassFilter[])Arrays.stream((ClassFilter[])ObjectUtils.chooseNotNull((Object)configuration.getCoveragePatterns(), (Object)ClassFilter.EMPTY_ARRAY)).filter(classFilter -> classFilter.INCLUDE == include).toArray(ClassFilter[]::new);
        if (classFilterArray == null) {
            CoverageConfigurable.$$$reportNull$$$0(4);
        }
        return classFilterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveragePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

