/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.RecordContext;

final class TimeDefinitions {
    private TimeDefinitions() {
    }

    static class WindowEndTimeDefinition<K extends Windowed<?>>
    implements TimeDefinition<K> {
        private static final WindowEndTimeDefinition<?> INSTANCE = new WindowEndTimeDefinition();

        private WindowEndTimeDefinition() {
        }

        static <K extends Windowed<?>> WindowEndTimeDefinition<K> instance() {
            return INSTANCE;
        }

        @Override
        public long time(RecordContext context, K key) {
            return ((Windowed)key).window().end();
        }
    }

    static class RecordTimeDefinition<K>
    implements TimeDefinition<K> {
        private static final RecordTimeDefinition<?> INSTANCE = new RecordTimeDefinition();

        private RecordTimeDefinition() {
        }

        static <K> RecordTimeDefinition<K> instance() {
            return INSTANCE;
        }

        @Override
        public long time(RecordContext context, K key) {
            return context.timestamp();
        }
    }

    static interface TimeDefinition<K> {
        public long time(RecordContext var1, K var2);
    }
}

