/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonLexer;
import com.intellij.json.highlighting.JsonHighlightingLexer;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    public static final TextAttributesKey JSON_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"JSON.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey JSON_BRACES = TextAttributesKey.createTextAttributesKey((String)"JSON.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey JSON_COMMA = TextAttributesKey.createTextAttributesKey((String)"JSON.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey JSON_COLON = TextAttributesKey.createTextAttributesKey((String)"JSON.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey JSON_NUMBER = TextAttributesKey.createTextAttributesKey((String)"JSON.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey JSON_STRING = TextAttributesKey.createTextAttributesKey((String)"JSON.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey JSON_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"JSON.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey JSON_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JSON.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey JSON_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"JSON.BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
    public static final TextAttributesKey JSON_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"JSON.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey JSON_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"JSON.PROPERTY_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey JSON_VALID_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JSON.VALID_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey JSON_INVALID_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"JSON.INVALID_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    public static final TextAttributesKey JSON_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"JSON.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return new MyHighlighter(virtualFile);
    }

    @NotNull
    protected Lexer getLexer() {
        return new JsonLexer();
    }

    protected boolean isCanEscapeEol() {
        return false;
    }

    private final class MyHighlighter
    extends SyntaxHighlighterBase {
        private final Map<IElementType, TextAttributesKey> ourAttributes = new HashMap<IElementType, TextAttributesKey>();
        @Nullable
        private final VirtualFile myFile;

        MyHighlighter(VirtualFile file) {
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_BRACES, (IElementType[])new IElementType[]{JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_BRACKETS, (IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_COMMA, (IElementType[])new IElementType[]{JsonElementTypes.COMMA});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_COLON, (IElementType[])new IElementType[]{JsonElementTypes.COLON});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_STRING, (IElementType[])new IElementType[]{JsonElementTypes.DOUBLE_QUOTED_STRING});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_STRING, (IElementType[])new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_NUMBER, (IElementType[])new IElementType[]{JsonElementTypes.NUMBER});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_KEYWORD, (IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE, JsonElementTypes.NULL});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_LINE_COMMENT, (IElementType[])new IElementType[]{JsonElementTypes.LINE_COMMENT});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_BLOCK_COMMENT, (IElementType[])new IElementType[]{JsonElementTypes.BLOCK_COMMENT});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_IDENTIFIER, (IElementType[])new IElementType[]{JsonElementTypes.IDENTIFIER});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)HighlighterColors.BAD_CHARACTER, (IElementType[])new IElementType[]{TokenType.BAD_CHARACTER});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_VALID_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_INVALID_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
            MyHighlighter.fillMap(this.ourAttributes, (TextAttributesKey)JSON_INVALID_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
            this.myFile = file;
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            return new JsonHighlightingLexer(this.isPermissiveDialect(), JsonSyntaxHighlighterFactory.this.isCanEscapeEol(), JsonSyntaxHighlighterFactory.this.getLexer());
        }

        private boolean isPermissiveDialect() {
            FileType fileType = this.myFile == null ? null : this.myFile.getFileType();
            boolean isPermissiveDialect = false;
            if (fileType instanceof JsonFileType) {
                Language language = ((JsonFileType)fileType).getLanguage();
                isPermissiveDialect = language instanceof JsonLanguage && ((JsonLanguage)language).hasPermissiveStrings();
            }
            return isPermissiveDialect;
        }

        public TextAttributesKey @NotNull [] getTokenHighlights(IElementType type) {
            TextAttributesKey[] textAttributesKeyArray = MyHighlighter.pack((TextAttributesKey)this.ourAttributes.get(type));
            if (textAttributesKeyArray == null) {
                MyHighlighter.$$$reportNull$$$0(0);
            }
            return textAttributesKeyArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonSyntaxHighlighterFactory$MyHighlighter", "getTokenHighlights"));
        }
    }
}

